/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.crafting.ElectrolyticCrucibleBatteryRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockElectrolyticCrucibleBattery;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityElectrolyticCrucibleBatterySlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.multiblock.PoICache;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.common.util.network.BinaryMessageTileSync;
import mctmods.immersivetechnology.common.util.network.IBinaryMessageReceiver;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityElectrolyticCrucibleBatteryMaster
extends TileEntityElectrolyticCrucibleBatterySlave
implements ITFluidTank.TankListener,
IBinaryMessageReceiver {
    private static final int inputTankSize = Config.ITConfig.Machines.ElectrolyticCrucibleBattery.electrolyticCrucibleBattery_input_tankSize;
    private static final int outputTankSize = Config.ITConfig.Machines.ElectrolyticCrucibleBattery.electrolyticCrucibleBattery_output_tankSize;
    public FluidTank[] tanks = new FluidTank[]{new ITFluidTank(inputTankSize, this), new ITFluidTank(outputTankSize, this), new ITFluidTank(outputTankSize, this), new ITFluidTank(outputTankSize, this)};
    ElectrolyticCrucibleBatteryRecipe recipe;
    private float soundVolume;
    private int clientUpdateCooldown = 20;
    private double distanceToTE = 0.0;
    private int playerDimension;
    private boolean isRunning;
    private boolean notify;
    private PoICache input0;
    private PoICache output0;
    private PoICache output1;
    private PoICache output2;
    private PoICache output3;
    private BlockPos soundOrigin;
    private BlockPos input0Front;
    private BlockPos output0Front;
    private BlockPos output1Front;
    private BlockPos output2Front;
    private BlockPos output3Front;
    private int redstonePos;
    private int energyPos0;
    private int energyPos1;
    private int energyPos2;

    @Override
    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("tank2"));
        this.tanks[3].readFromNBT(nbt.func_74775_l("tank3"));
    }

    @Override
    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank2", (NBTBase)this.tanks[2].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank3", (NBTBase)this.tanks[3].writeToNBT(new NBTTagCompound()));
    }

    public void requestUpdate() {
        ByteBuf buffer = Unpooled.copyBoolean((boolean)true);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToServer((IMessage)new BinaryMessageTileSync(center, buffer));
    }

    public void notifyNearbyClients() {
        if (this.clientUpdateCooldown > 0) {
            this.notify = true;
            return;
        }
        this.clientUpdateCooldown = 20;
        ByteBuf buffer = Unpooled.copyBoolean((boolean)this.isRunning);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllAround((IMessage)new BinaryMessageTileSync(center, buffer), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 40.0));
    }

    @Override
    public void receiveMessageFromClient(ByteBuf message, EntityPlayerMP player) {
        ByteBuf buffer = Unpooled.copyBoolean((boolean)this.isRunning);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendTo((IMessage)new BinaryMessageTileSync(center, buffer), player);
    }

    @Override
    public void receiveMessageFromServer(ByteBuf message) {
        this.isRunning = message.readBoolean();
    }

    public void handleSounds() {
        if (this.isRunning) {
            if (this.soundVolume < 1.0f) {
                this.soundVolume += 0.02f;
            }
        } else if (this.soundVolume > 0.0f) {
            this.soundVolume -= 0.02f;
        }
        if (this.soundVolume == 0.0f) {
            ITSoundHandler.StopSound(this.soundOrigin);
        } else {
            float attenuation = Math.max((float)this.distanceToTE / 16.0f, 1.0f);
            ITSounds.gasTurbineArc.PlayRepeating(this.soundOrigin, this.soundVolume / attenuation, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        ITSoundHandler.StopSound(this.soundOrigin);
        super.onChunkUnload();
    }

    @Override
    public void disassemble() {
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(this.soundOrigin), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.soundOrigin.func_177958_n(), (double)this.soundOrigin.func_177956_o(), (double)this.soundOrigin.func_177952_p(), 0.0));
        super.disassemble();
    }

    private void clientUpdate() {
        if (this.input0 == null) {
            this.InitializePoIs();
            this.requestUpdate();
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double currentDistance = player.func_70092_e((double)this.soundOrigin.func_177958_n(), (double)this.soundOrigin.func_177956_o(), (double)this.soundOrigin.func_177952_p());
        if (this.func_145831_w().field_73011_w.getDimension() == player.field_71093_bK && currentDistance < 400.0 && (this.distanceToTE > 400.0 || this.playerDimension != player.field_71093_bK)) {
            this.requestUpdate();
        }
        this.distanceToTE = currentDistance;
        this.playerDimension = player.field_71093_bK;
        this.handleSounds();
    }

    private void serverUpdate() {
        this.pumpOutputOut();
        boolean update = false;
        if (this.processQueue.size() < this.getProcessQueueMaxLength() && this.tanks[0].getFluidAmount() > 0) {
            TileEntityMultiblockMetal.MultiblockProcessInMachine process;
            this.recipe = ElectrolyticCrucibleBatteryRecipe.findRecipe(this.tanks[0].getFluid());
            if (!(this.recipe == null || this.tanks[1].fill(this.recipe.fluidOutput0, false) != this.recipe.fluidOutput0.amount || this.recipe.fluidOutput1 != null && this.tanks[2].fill(this.recipe.fluidOutput1, false) != this.recipe.fluidOutput1.amount || this.recipe.fluidOutput2 != null && this.tanks[3].fill(this.recipe.fluidOutput2, false) != this.recipe.fluidOutput2.amount || !this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)(process = new TileEntityMultiblockMetal.MultiblockProcessInMachine((IMultiblockRecipe)this.recipe, new int[0]).setInputTanks(new int[]{0})), true))) {
                this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)process, false);
                update = true;
            }
        }
        if (this.tickedProcesses > 0) {
            if (!this.isRunning) {
                this.isRunning = true;
                this.notifyNearbyClients();
            }
        } else if (this.isRunning) {
            this.isRunning = false;
            this.notifyNearbyClients();
        }
        if (this.clientUpdateCooldown > 0) {
            --this.clientUpdateCooldown;
        }
        if (this.notify) {
            this.notifyNearbyClients();
        }
        if (update) {
            this.efficientMarkDirty();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.clientUpdate();
            return;
        }
        this.serverUpdate();
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public void onProcessFinish(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<ElectrolyticCrucibleBatteryRecipe> process) {
        this.tanks[1].fill(((ElectrolyticCrucibleBatteryRecipe)process.recipe).fluidOutput0, true);
        if (((ElectrolyticCrucibleBatteryRecipe)process.recipe).fluidOutput1 != null) {
            this.tanks[2].fill(((ElectrolyticCrucibleBatteryRecipe)process.recipe).fluidOutput1, true);
        }
        if (((ElectrolyticCrucibleBatteryRecipe)process.recipe).fluidOutput2 != null) {
            this.tanks[3].fill(((ElectrolyticCrucibleBatteryRecipe)process.recipe).fluidOutput2, true);
        }
        if (((ElectrolyticCrucibleBatteryRecipe)process.recipe).itemOutput != null && !((ElectrolyticCrucibleBatteryRecipe)process.recipe).itemOutput.func_190926_b()) {
            ItemStack output = null;
            TileEntity inventoryTile = this.field_145850_b.func_175625_s(this.output3Front);
            if (inventoryTile != null) {
                output = Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)((ElectrolyticCrucibleBatteryRecipe)process.recipe).itemOutput.func_77946_l(), (EnumFacing)this.facing.func_176734_d());
            }
            if (output == null) {
                Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)this.output3Front, (ItemStack)((ElectrolyticCrucibleBatteryRecipe)process.recipe).itemOutput, (EnumFacing)this.facing);
            }
        }
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntityElectrolyticCrucibleBatteryMaster master() {
        this.master = this;
        return this;
    }

    private void InitializePoIs() {
        block24: for (PoIJSONSchema poi : MultiblockElectrolyticCrucibleBattery.instance.pointsOfInterest) {
            switch (poi.name) {
                case "redstone": {
                    this.redstonePos = poi.position;
                    continue block24;
                }
                case "energy0": {
                    this.energyPos0 = poi.position;
                    continue block24;
                }
                case "energy1": {
                    this.energyPos1 = poi.position;
                    continue block24;
                }
                case "energy2": {
                    this.energyPos2 = poi.position;
                    continue block24;
                }
                case "input0": {
                    this.input0 = new PoICache(this.facing, poi, this.mirrored);
                    this.input0Front = this.getBlockPosForPos(this.input0.position).func_177972_a(this.input0.facing);
                    continue block24;
                }
                case "output0": {
                    this.output0 = new PoICache(this.facing, poi, this.mirrored);
                    this.output0Front = this.getBlockPosForPos(this.output0.position).func_177972_a(this.output0.facing);
                    continue block24;
                }
                case "output1": {
                    this.output1 = new PoICache(this.facing, poi, this.mirrored);
                    this.output1Front = this.getBlockPosForPos(this.output1.position).func_177972_a(this.output1.facing);
                    continue block24;
                }
                case "output2": {
                    this.output2 = new PoICache(this.facing, poi, this.mirrored);
                    this.output2Front = this.getBlockPosForPos(this.output2.position).func_177972_a(this.output2.facing);
                    continue block24;
                }
                case "output3": {
                    this.output3 = new PoICache(this.facing, poi, this.mirrored);
                    this.output3Front = this.getBlockPosForPos(this.output3.position).func_177972_a(this.output3.facing);
                    continue block24;
                }
                case "sound": {
                    this.soundOrigin = this.getBlockPosForPos(poi.position);
                }
            }
        }
    }

    public IFluidTank[] getAccessibleFluidTanks(EnumFacing side, int position) {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        if (side == null) {
            return this.tanks;
        }
        if (this.input0.isPoI(side, position)) {
            return new FluidTank[]{this.tanks[0]};
        }
        if (this.output0.isPoI(side, position)) {
            return new FluidTank[]{this.tanks[1]};
        }
        if (this.output1.isPoI(side, position)) {
            return new FluidTank[]{this.tanks[2]};
        }
        if (this.output2.isPoI(side, position)) {
            return new FluidTank[]{this.tanks[3]};
        }
        return ITUtils.emptyIFluidTankList;
    }

    public boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource, int position) {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        if (this.input0.isPoI(side, position)) {
            if (this.tanks[0].getFluidAmount() >= this.tanks[0].getCapacity()) {
                return false;
            }
            if (this.tanks[0].getFluid() == null) {
                return ElectrolyticCrucibleBatteryRecipe.findRecipeFluid(resource.getFluid()) != null;
            }
            return resource.getFluid() == this.tanks[0].getFluid().getFluid();
        }
        return false;
    }

    public boolean canDrainTankFrom(int iTank, EnumFacing side, int position) {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        if (this.output0.isPoI(side, position)) {
            return this.tanks[1].getFluidAmount() > 0;
        }
        if (this.output1.isPoI(side, position)) {
            return this.tanks[2].getFluidAmount() > 0;
        }
        if (this.output2.isPoI(side, position)) {
            return this.tanks[3].getFluidAmount() > 0;
        }
        return false;
    }

    private void pumpOutputOut() {
        int drained;
        int accepted;
        FluidStack out;
        IFluidHandler output;
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        if (this.tanks[1].getFluidAmount() > 0 && (output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.output0Front, (EnumFacing)this.output0.facing.func_176734_d())) != null) {
            out = this.tanks[1].getFluid();
            accepted = output.fill(out, false);
            if (accepted == 0) {
                return;
            }
            drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
            this.tanks[1].drain(drained, true);
        }
        if (this.tanks[2].getFluidAmount() > 0 && (output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.output1Front, (EnumFacing)this.output1.facing.func_176734_d())) != null) {
            out = this.tanks[2].getFluid();
            accepted = output.fill(out, false);
            if (accepted == 0) {
                return;
            }
            drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
            this.tanks[2].drain(drained, true);
        }
        if (this.tanks[3].getFluidAmount() > 0 && (output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.output2Front, (EnumFacing)this.output2.facing.func_176734_d())) != null) {
            out = this.tanks[3].getFluid();
            accepted = output.fill(out, false);
            if (accepted == 0) {
                return;
            }
            drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
            this.tanks[3].drain(drained, true);
        }
    }

    @Override
    @Nonnull
    public int[] getRedstonePos() {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        return new int[]{this.redstonePos};
    }

    @Override
    @Nonnull
    public int[] getEnergyPos() {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        return new int[]{this.energyPos0, this.energyPos1, this.energyPos2};
    }
}

