/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.minesweeper;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.achievement.AdvancementManager;
import ru.timeconqueror.lootgames.api.minigame.ILootGameFactory;
import ru.timeconqueror.lootgames.api.minigame.LootGame;
import ru.timeconqueror.lootgames.api.util.GameUtils;
import ru.timeconqueror.lootgames.api.util.NBTUtils;
import ru.timeconqueror.lootgames.api.util.Pos2i;
import ru.timeconqueror.lootgames.block.BlockDungeonLamp;
import ru.timeconqueror.lootgames.config.LGConfigGOL;
import ru.timeconqueror.lootgames.config.LGConfigMinesweeper;
import ru.timeconqueror.lootgames.minigame.gameoflight.GameOfLight;
import ru.timeconqueror.lootgames.minigame.minesweeper.MSBoard;
import ru.timeconqueror.lootgames.minigame.minesweeper.block.BlockMSActivator;
import ru.timeconqueror.lootgames.minigame.minesweeper.task.TaskMSCreateExplosion;
import ru.timeconqueror.lootgames.registry.ModBlocks;
import ru.timeconqueror.lootgames.registry.ModSounds;
import ru.timeconqueror.timecore.api.auxiliary.DirectionTetra;
import ru.timeconqueror.timecore.api.auxiliary.MessageUtils;
import ru.timeconqueror.timecore.api.auxiliary.NetworkUtils;

public class GameMineSweeper
extends LootGame {
    @SideOnly(value=Side.CLIENT)
    public boolean cIsGenerated;
    @SideOnly(value=Side.CLIENT)
    public int detonationTimeInTicks;
    private int currentLevel = 1;
    private MSBoard board;
    private Stage stage;
    private int ticks;
    private int attemptCount = 0;
    private boolean playRevealNeighboursSound = true;

    public GameMineSweeper(int boardSize, int bombCount) {
        this.board = new MSBoard(boardSize, bombCount);
        this.stage = Stage.WAITING;
        this.setOnWin(this::onGameWon);
        this.setOnLose(this::onGameLost);
    }

    public static Pos2i convertToGamePos(BlockPos masterPos, BlockPos subordinatePos) {
        BlockPos temp = subordinatePos.func_177973_b((Vec3i)masterPos);
        return new Pos2i(temp.func_177958_n(), temp.func_177952_p());
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.isServerSide()) {
            if (this.stage == Stage.DETONATING) {
                if (this.ticks >= LGConfigMinesweeper.detonationTimeInTicks) {
                    this.onDetonateTimePassed();
                }
                ++this.ticks;
            } else if (this.stage == Stage.EXPLODING) {
                --this.ticks;
                if (this.ticks <= 0) {
                    NetworkUtils.sendMessageToAllNearby((BlockPos)this.getCentralGamePos(), (ITextComponent)MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.ms.new_attempt", new Object[0]), (TextFormatting)TextFormatting.AQUA), (double)this.getDefaultBroadcastDistance());
                    NetworkUtils.sendMessageToAllNearby((BlockPos)this.getCentralGamePos(), (ITextComponent)MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.attemptCount", new Object[]{LGConfigMinesweeper.attemptCount - this.attemptCount}), (TextFormatting)TextFormatting.RED), (double)this.getDefaultBroadcastDistance());
                    this.updateStage(Stage.WAITING);
                    this.board.resetBoard();
                    this.sendUpdatePacket("reset_flag_counter", new NBTTagCompound());
                    this.saveDataAndSendToClient();
                }
            }
        } else if (this.stage == Stage.DETONATING) {
            ++this.ticks;
        }
    }

    @Override
    protected BlockPos getRoomFloorPos() {
        return this.getMasterPos();
    }

    @Override
    protected BlockPos getCentralRoomPos() {
        return this.getCentralGamePos();
    }

    public void onFieldClicked(Pos2i clickedPos, boolean sneaking) {
        this.getWorld().func_184133_a(null, this.convertToBlockPos(clickedPos), SoundEvents.field_187685_dH, SoundCategory.MASTER, 0.6f, 0.8f);
        if (!this.board.isGenerated()) {
            this.generateBoard(clickedPos);
        } else {
            this.playRevealNeighboursSound = true;
            if (sneaking) {
                if (this.board.isHidden(clickedPos)) {
                    this.swapFieldMark(clickedPos);
                } else {
                    this.revealAllNeighbours(clickedPos, false);
                }
            } else if (this.board.getMark(clickedPos) == 0) {
                this.revealField(clickedPos);
            }
        }
    }

    public boolean isBoardGenerated() {
        return this.board.isGenerated();
    }

    public int getBoardSize() {
        return this.board.size();
    }

    public void generateBoard(Pos2i clickedPos) {
        this.board.generate(clickedPos);
        this.sendUpdatePacket("gen_board", this.writeNBTForClient());
        if (this.board.getType(clickedPos) == 0) {
            this.revealAllNeighbours(clickedPos, true);
        }
        this.saveData();
    }

    public void revealField(Pos2i pos) {
        if (this.stage == Stage.WAITING && this.board.isHidden(pos)) {
            this.board.reveal(pos);
            int type = this.board.getType(pos);
            NBTTagCompound c = new NBTTagCompound();
            c.func_74768_a("x", pos.getX());
            c.func_74768_a("y", pos.getY());
            c.func_74768_a("type", type);
            c.func_74757_a("hidden", false);
            c.func_74768_a("mark", 0);
            this.sendUpdatePacket("field_changed", c);
            if (type == 0) {
                if (this.playRevealNeighboursSound) {
                    this.getWorld().func_184133_a(null, this.convertToBlockPos(pos), ModSounds.msOnEmptyRevealNeighbours, SoundCategory.MASTER, 0.6f, 1.0f);
                    this.playRevealNeighboursSound = false;
                }
                this.revealAllNeighbours(pos, true);
            } else if (type == -1) {
                this.getWorld().func_184133_a(null, this.convertToBlockPos(pos), ModSounds.msBombActivated, SoundCategory.MASTER, 0.6f, 1.0f);
                this.onBombTriggered();
            }
            this.saveData();
            if (this.board.checkWin()) {
                this.onLevelSuccessfullyFinished();
            }
        }
    }

    public void swapFieldMark(Pos2i pos) {
        if (this.stage == Stage.WAITING) {
            if (this.board.isHidden(pos)) {
                this.board.swapMark(pos);
                NBTTagCompound c = new NBTTagCompound();
                c.func_74768_a("x", pos.getX());
                c.func_74768_a("y", pos.getY());
                c.func_74768_a("type", 0);
                c.func_74757_a("hidden", true);
                c.func_74768_a("mark", this.board.getMark(pos));
                this.sendUpdatePacket("field_changed", c);
                this.saveData();
            }
            if (this.board.checkWin()) {
                this.onLevelSuccessfullyFinished();
            }
        }
    }

    private void revealAllNeighbours(Pos2i mainPos, boolean revealMarked) {
        if (!revealMarked) {
            if (this.board.isHidden(mainPos)) {
                NetworkUtils.sendMessageToAllNearby((BlockPos)this.getCentralGamePos(), (ITextComponent)MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.ms.reveal_on_hidden", new Object[0]), (TextFormatting)TextFormatting.YELLOW), (double)this.getDefaultBroadcastDistance());
                return;
            }
            int bombsAround = this.board.getType(mainPos);
            if (bombsAround < 1) {
                throw new IllegalStateException();
            }
            int marked = 0;
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    Pos2i pos = mainPos.add(x, y);
                    if (!this.board.hasFieldOn(pos) || this.board.getMark(pos) != 1) continue;
                    ++marked;
                }
            }
            if (marked != bombsAround) {
                NetworkUtils.sendMessageToAllNearby((BlockPos)this.getCentralGamePos(), (ITextComponent)MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.ms.reveal_invalid_mark_count", new Object[0]), (TextFormatting)TextFormatting.YELLOW), (double)this.getDefaultBroadcastDistance());
                return;
            }
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                Pos2i pos;
                if (x == 0 && y == 0 || !this.board.hasFieldOn(pos = mainPos.add(x, y)) || !this.board.isHidden(pos) || !revealMarked && this.board.getMark(pos) == 1) continue;
                this.revealField(pos);
            }
        }
    }

    private void onBombTriggered() {
        this.updateStage(Stage.DETONATING);
        this.board.forEach((x, y) -> {
            if (this.board.isBomb((int)x, (int)y)) {
                this.board.reveal((int)x, (int)y);
            }
        });
        NetworkUtils.sendMessageToAllNearby((BlockPos)this.getCentralGamePos(), (ITextComponent)MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.ms.bomb_touched", new Object[0]), (TextFormatting)TextFormatting.DARK_PURPLE), (double)this.getDefaultBroadcastDistance());
        this.saveDataAndSendToClient();
        ++this.attemptCount;
    }

    private void onDetonateTimePassed() {
        if (this.attemptCount < LGConfigMinesweeper.attemptCount) {
            int longestDetTime = this.detonateBoard(this.currentLevel + 3, false);
            this.updateStage(Stage.EXPLODING);
            this.ticks = longestDetTime + 40;
        } else if (this.currentLevel > 1) {
            this.winGame();
        } else {
            this.loseGame();
        }
    }

    private void onLevelSuccessfullyFinished() {
        if (this.currentLevel < 4) {
            this.sendUpdatePacket("spawn_particles_level_beat", null);
            NetworkUtils.sendMessageToAllNearby((BlockPos)this.getCentralGamePos(), (ITextComponent)MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.stage_complete", new Object[0]), (TextFormatting)TextFormatting.GREEN), (double)40.0);
            this.getWorld().func_184133_a(null, this.getCentralGamePos(), SoundEvents.field_187802_ec, SoundCategory.BLOCKS, 0.75f, 1.0f);
            this.masterTileEntity.destroyGameBlocks();
            BlockMSActivator.generateGameStructure(this.getWorld(), this.getCentralGamePos(), this.currentLevel + 1);
            LGConfigMinesweeper.Stage stageConfig = LGConfigMinesweeper.getStage(this.currentLevel + 1);
            BlockPos startPos = this.getCentralGamePos().func_177982_a(-stageConfig.boardSize / 2, 0, -stageConfig.boardSize / 2);
            this.masterTileEntity.func_145829_t();
            this.getWorld().func_175690_a(startPos, (TileEntity)this.masterTileEntity);
            this.board.resetBoard(stageConfig.boardSize, stageConfig.bombCount);
            ++this.currentLevel;
            this.saveDataAndSendToClient();
        } else {
            ++this.currentLevel;
            this.winGame();
        }
    }

    private void onGameWon() {
        List players = NetworkUtils.getPlayersNearby((BlockPos)this.getCentralGamePos(), (double)this.getDefaultBroadcastDistance());
        for (EntityPlayerMP player : players) {
            player.func_145747_a(MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.win", new Object[0]), (TextFormatting)TextFormatting.GREEN));
        }
        this.genLootChests(players);
    }

    private void genLootChests(List<EntityPlayerMP> players) {
        if (this.currentLevel < 2) {
            LootGames.logHelper.error("GenLootChests method was called in an appropriate time!");
            return;
        }
        BlockPos central = this.getCentralGamePos();
        IBlockState state = ModBlocks.DUNGEON_LAMP.func_176223_P().func_177226_a((IProperty)BlockDungeonLamp.BROKEN, (Comparable)Boolean.valueOf(false));
        this.getWorld().func_175656_a(central.func_177982_a(-1, 0, -1), state);
        this.getWorld().func_175656_a(central.func_177982_a(1, 0, -1), state);
        this.getWorld().func_175656_a(central.func_177982_a(-1, 0, 1), state);
        this.getWorld().func_175656_a(central.func_177982_a(1, 0, 1), state);
        this.spawnLootChest(DirectionTetra.NORTH, 1);
        if (this.currentLevel > 2) {
            this.spawnLootChest(DirectionTetra.EAST, 2);
        }
        if (this.currentLevel > 3) {
            this.spawnLootChest(DirectionTetra.SOUTH, 3);
        }
        if (this.currentLevel > 4) {
            for (EntityPlayerMP entityPlayerMP : players) {
                AdvancementManager.WIN_GAME.trigger(entityPlayerMP, "ms_level4");
            }
            this.spawnLootChest(DirectionTetra.WEST, 4);
        }
    }

    private void spawnLootChest(DirectionTetra direction, int gameLevel) {
        LGConfigGOL.Stage stage = LGConfigGOL.getStageByIndex(gameLevel);
        GameUtils.SpawnChestInfo chestInfo = new GameUtils.SpawnChestInfo(GameOfLight.class, stage.getLootTableRL(this.getWorld().field_73011_w.getDimension()), stage.minItems, stage.maxItems);
        GameUtils.spawnLootChest(this.getWorld(), this.getCentralGamePos(), direction, chestInfo);
    }

    private void onGameLost() {
        BlockPos expPos = this.getCentralGamePos();
        this.getWorld().func_72876_a(null, (double)expPos.func_177958_n(), (double)expPos.func_177956_o() + 1.5, (double)expPos.func_177952_p(), 9.0f, true);
        NetworkUtils.sendMessageToAllNearby((BlockPos)this.getCentralGamePos(), (ITextComponent)MessageUtils.color((ITextComponent)new TextComponentTranslation("msg.lootgames.lose", new Object[0]), (TextFormatting)TextFormatting.DARK_PURPLE), (double)this.getDefaultBroadcastDistance());
    }

    private int detonateBoard(int strength, boolean damageTerrain) {
        AtomicInteger longestDetTime = new AtomicInteger();
        this.board.forEach(pos2i -> {
            if (this.board.getType((Pos2i)pos2i) == -1) {
                int detTime = LootGames.RAND.nextInt(45);
                if (longestDetTime.get() < detTime) {
                    longestDetTime.set(detTime);
                }
                this.serverTaskPostponer.addTask(new TaskMSCreateExplosion(this.getMasterPos(), (Pos2i)pos2i, strength, damageTerrain), detTime);
            }
        });
        return longestDetTime.get();
    }

    private void updateStage(Stage stageTo) {
        this.stage = stageTo;
        this.ticks = 0;
        if (this.isServerSide()) {
            NBTTagCompound c = new NBTTagCompound();
            c.func_74768_a("stage", this.stage.ordinal());
            if (stageTo == Stage.DETONATING) {
                c.func_74768_a("detonation_time", LGConfigMinesweeper.detonationTimeInTicks);
            }
            this.sendUpdatePacket("stageUpdate", c);
            this.saveData();
        }
    }

    @Override
    public void onUpdatePacket(String key, NBTTagCompound compoundIn) {
        switch (key) {
            case "stageUpdate": {
                Stage stage = Stage.values()[compoundIn.func_74762_e("stage")];
                this.updateStage(stage);
                if (stage != Stage.DETONATING) break;
                this.detonationTimeInTicks = compoundIn.func_74762_e("detonation_time");
                break;
            }
            case "gen_board": {
                this.readNBTFromClient(compoundIn);
                break;
            }
            case "field_changed": {
                Pos2i pos = new Pos2i(compoundIn.func_74762_e("x"), compoundIn.func_74762_e("y"));
                this.board.setField(pos, compoundIn.func_74762_e("type"), compoundIn.func_74767_n("hidden"), compoundIn.func_74762_e("mark"));
                break;
            }
            case "spawn_particles_level_beat": {
                for (int x = 0; x < this.getBoardSize() + 1; ++x) {
                    for (int z = 0; z < this.getBoardSize() + 1; ++z) {
                        this.getWorld().func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)(this.getMasterPos().func_177958_n() + x), (double)((float)this.getCentralGamePos().func_177956_o() + 1.1f), (double)(this.getMasterPos().func_177952_p() + z), 0.0, 0.2, 0.0, new int[0]);
                    }
                }
                break;
            }
            case "reset_flag_counter": {
                this.board.cFlaggedFields = 0;
            }
        }
    }

    public BlockPos convertToBlockPos(int x, int y) {
        return this.masterTileEntity.func_174877_v().func_177982_a(x, 0, y);
    }

    public BlockPos convertToBlockPos(Pos2i pos) {
        return this.convertToBlockPos(pos.getX(), pos.getY());
    }

    public BlockPos getCentralGamePos() {
        return this.masterTileEntity.func_174877_v().func_177982_a(this.getBoardSize() / 2, 0, this.getBoardSize() / 2);
    }

    public MSBoard getBoard() {
        return this.board;
    }

    public int getTicks() {
        return this.ticks;
    }

    public Stage getStage() {
        return this.stage;
    }

    @Override
    public NBTTagCompound writeNBTForSaving() {
        NBTTagCompound gameCompound = super.writeNBTForSaving();
        if (this.isBoardGenerated()) {
            NBTTagCompound boardTag = this.board.writeNBTForSaving();
            gameCompound.func_74782_a("board", (NBTBase)boardTag);
        }
        gameCompound.func_74768_a("attempt_count", this.attemptCount);
        return gameCompound;
    }

    @Override
    public void readNBTFromSave(NBTTagCompound compound) {
        super.readNBTFromSave(compound);
        if (compound.func_74764_b("board")) {
            NBTTagCompound boardTag = compound.func_74775_l("board");
            MSBoard.MSField[][] boardArr = (MSBoard.MSField[][])NBTUtils.readTwoDimArrFromNBT((NBTTagCompound)boardTag, MSBoard.MSField.class, () -> new MSBoard.MSField(0, true, 0));
            this.board.setBoard(boardArr);
        }
        this.attemptCount = compound.func_74762_e("attempt_count");
    }

    @Override
    public NBTTagCompound writeNBTForClient() {
        NBTTagCompound compound = super.writeNBTForClient();
        compound.func_74757_a("is_generated", this.isBoardGenerated());
        if (this.isBoardGenerated()) {
            NBTTagCompound boardTag = this.board.writeNBTForClient();
            compound.func_74782_a("board", (NBTBase)boardTag);
        }
        return compound;
    }

    @Override
    public void readNBTFromClient(NBTTagCompound compound) {
        this.cIsGenerated = compound.func_74767_n("is_generated");
        super.readNBTFromClient(compound);
        if (compound.func_74764_b("board")) {
            NBTTagCompound boardTag = compound.func_74775_l("board");
            MSBoard.MSField[][] boardArr = NBTUtils.readTwoDimArrFromNBT(boardTag, MSBoard.MSField.class, compoundIn -> new MSBoard.MSField(compoundIn.func_74764_b("type") ? compoundIn.func_74762_e("type") : 0, compoundIn.func_74767_n("hidden"), compoundIn.func_74762_e("mark")));
            this.board.setBoard(boardArr);
            this.board.updateFlaggedFields_c();
        }
    }

    @Override
    public void writeCommonNBT(NBTTagCompound compound) {
        super.writeCommonNBT(compound);
        compound.func_74768_a("bomb_count", this.board.getBombCount());
        compound.func_74768_a("board_size", this.board.size());
        compound.func_74768_a("stage", this.stage.ordinal());
        compound.func_74768_a("ticks", this.ticks);
        compound.func_74768_a("current_level", this.currentLevel);
    }

    @Override
    public void readCommonNBT(NBTTagCompound compound) {
        super.readCommonNBT(compound);
        this.board.setBombCount(compound.func_74762_e("bomb_count"));
        this.board.setSize(compound.func_74762_e("board_size"));
        this.stage = Stage.values()[compound.func_74762_e("stage")];
        this.ticks = compound.func_74762_e("ticks");
        this.currentLevel = compound.func_74762_e("current_level");
    }

    public static class Factory
    implements ILootGameFactory {
        @Override
        public void genOnPuzzleMasterClick(World world, BlockPos puzzleMasterPos, BlockPos bottomPos, BlockPos topPos) {
            BlockPos floorCenterPos = puzzleMasterPos.func_177982_a(0, -2, 0);
            world.func_175656_a(floorCenterPos, ModBlocks.MS_ACTIVATOR.func_176223_P());
        }
    }

    public static enum Stage {
        WAITING,
        DETONATING,
        EXPLODING;

    }
}

