/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.gameoflight;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ru.timeconqueror.lootgames.api.util.DirectionOctagonal;
import ru.timeconqueror.lootgames.minigame.gameoflight.TileEntityGOLMaster;
import ru.timeconqueror.lootgames.packets.CMessageGOLFeedback;
import ru.timeconqueror.lootgames.packets.NetworkHandler;
import ru.timeconqueror.timecore.api.auxiliary.RenderHelper;

public class TESRGOLMaster
extends TileEntitySpecialRenderer<TileEntityGOLMaster> {
    private static final ResourceLocation GAME_FIELD = new ResourceLocation("lootgames", "textures/blocks/gameoflight/game_field.png");
    private static final ResourceLocation GAME_FIELD_ACTIVATED = new ResourceLocation("lootgames", "textures/blocks/gameoflight/game_field_active.png");
    private static final ResourceLocation SPECIAL_STUFF = new ResourceLocation("lootgames", "textures/blocks/gameoflight/special_stuff.png");

    public void render(TileEntityGOLMaster te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.getGameStage() == TileEntityGOLMaster.GameStage.NOT_CONSTRUCTED) {
            return;
        }
        this.drawField(te, x, y, z, te.getTicks(), partialTicks);
        if (te.getGameStage() == TileEntityGOLMaster.GameStage.SHOWING_SEQUENCE) {
            this.drawStuff(te, TileEntityGOLMaster.EnumDrawStuff.SHOWING_SEQUENCE, x, y, z, te.getTicks(), partialTicks);
            if (!te.isOnPause()) {
                if (te.isShowingSymbols()) {
                    this.drawSymbol(te, te.getCurrentSymbolPosOffset(), x, y, z, te.getTicks(), partialTicks);
                } else if (!te.isFeedbackPacketReceived()) {
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new CMessageGOLFeedback(te.func_174877_v()));
                    te.onClientThingsDone();
                }
            }
        }
        if (te.getSymbolsEnteredByPlayer() != null) {
            te.getSymbolsEnteredByPlayer().forEach(clickInfo -> this.drawSymbol(te, clickInfo.getOffset(), x, y, z, te.getTicks(), partialTicks));
        }
        if (te.getStuffToDraw() != null) {
            te.getStuffToDraw().forEach(stuff -> this.drawStuff(te, stuff.getStuff(), x, y, z, te.getTicks(), partialTicks));
        }
    }

    public void drawStuff(TileEntityGOLMaster te, TileEntityGOLMaster.EnumDrawStuff stuff, double masterX, double masterY, double masterZ, int ticks, float partialTicks) {
        this.func_147499_a(SPECIAL_STUFF);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)masterX, (double)(masterY + 1.0), (double)masterZ);
        GlStateManager.func_179140_f();
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float f = 0.020833334f;
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        float textureX = 16 * (stuff == TileEntityGOLMaster.EnumDrawStuff.SEQUENCE_ACCEPTED ? 0 : (stuff == TileEntityGOLMaster.EnumDrawStuff.SHOWING_SEQUENCE ? 1 : 2));
        float textureY = 0.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179141_d();
        GlStateManager.func_179119_h();
        RenderHelper.drawTexturedRectP((double)0.0, (double)0.0, (double)48.0, (double)48.0, (double)-0.07, (double)textureX, (double)textureY, (double)16.0, (double)16.0, (double)f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void drawSymbol(TileEntityGOLMaster te, DirectionOctagonal offset, double masterX, double masterY, double masterZ, int ticks, float partialTicks) {
        if (te.getTicks() > TileEntityGOLMaster.ticksPerShowSymbols) {
            return;
        }
        this.func_147499_a(GAME_FIELD_ACTIVATED);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(masterX + (double)offset.getOffsetX()), (double)(masterY + 1.0), (double)(masterZ + (double)offset.getOffsetZ()));
        GlStateManager.func_179140_f();
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float f = 0.020833334f;
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        float textureX = 16 + 16 * offset.getOffsetX();
        float textureY = 16 + 16 * offset.getOffsetZ();
        RenderHelper.drawTexturedRectP((double)0.0, (double)0.0, (double)48.0, (double)48.0, (double)-0.07, (double)textureX, (double)textureY, (double)16.0, (double)16.0, (double)f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void drawField(TileEntityGOLMaster te, double x, double y, double z, int ticks, float partialTicks) {
        this.func_147499_a(GAME_FIELD);
        boolean isExpanding = false;
        if (te.getGameStage() == TileEntityGOLMaster.GameStage.UNDER_EXPANDING) {
            isExpanding = true;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.0), (double)(z + 0.5));
        GlStateManager.func_179140_f();
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float f = 0.020833334f;
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        float length = !isExpanding || ticks >= 20 ? 144.0f : 48.0f + 96.0f * ((float)ticks + partialTicks) / 20.0f;
        GlStateManager.func_179109_b((float)(-length / 2.0f), (float)(-length / 2.0f), (float)0.0f);
        float textureStart = !isExpanding || ticks >= 20 ? 0.0f : 16.0f - 16.0f * ((float)ticks + partialTicks) / 20.0f;
        float textureLength = !isExpanding || ticks >= 20 ? 48.0f : 32.0f + 16.0f * ((float)ticks + partialTicks) / 20.0f - textureStart;
        RenderHelper.drawTexturedRectP((double)0.0, (double)0.0, (double)length, (double)length, (double)-0.05, (double)textureStart, (double)textureStart, (double)textureLength, (double)textureLength, (double)f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

