/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.config;

import java.util.HashMap;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.timecore.api.auxiliary.IntHelper;

@Mod.EventBusSubscriber
@Config.LangKey(value="config.lootgames.category.ms")
@Config(modid="lootgames", name="lootgames/games/minesweeper")
public class LGConfigMinesweeper {
    @Config.LangKey(value="config.lootgames.ms.detonation_time")
    @Config.Comment(value={"The time until bombs start to explode. Represented in ticks.", "Default: 60"})
    public static int detonationTimeInTicks = 60;
    @Config.LangKey(value="config.lootgames.ms.attempt_count")
    @Config.Comment(value={"It represents the number of attempts the player has to beat the game successfully.", "Default: 3"})
    public static int attemptCount = 3;
    @Config.LangKey(value="config.lootgames.common.stage.1")
    @Config.Comment(value={"Regulates characteristics of stage 1."})
    public static Stage stage1 = new Stage(13, 20, "minecraft:chests/simple_dungeon", 15, 15);
    @Config.LangKey(value="config.lootgames.common.stage.2")
    @Config.Comment(value={"Regulates characteristics of stage 2."})
    public static Stage stage2 = new Stage(15, 30, "minecraft:chests/desert_pyramid", -1, -1);
    @Config.LangKey(value="config.lootgames.common.stage.3")
    @Config.Comment(value={"Regulates characteristics of stage 3."})
    public static Stage stage3 = new Stage(17, 42, "minecraft:chests/nether_bridge", -1, -1);
    @Config.LangKey(value="config.lootgames.common.stage.4")
    @Config.Comment(value={"Regulates characteristics of stage 4."})
    public static Stage stage4 = new Stage(19, 68, "minecraft:chests/end_city_treasure", -1, -1);

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("lootgames")) {
            ConfigManager.sync((String)"lootgames", (Config.Type)Config.Type.INSTANCE);
            LGConfigMinesweeper.init();
        }
    }

    public static void init() {
        for (int i = 1; i <= 4; ++i) {
            Objects.requireNonNull(LGConfigMinesweeper.getStage(i)).init();
        }
    }

    public static Stage getStage(int index) {
        switch (index) {
            case 1: {
                return stage1;
            }
            case 2: {
                return stage2;
            }
            case 3: {
                return stage3;
            }
            case 4: {
                return stage4;
            }
        }
        throw new RuntimeException("Provided unknown stage index " + index + ", please contact with mod author.");
    }

    public static class Stage {
        @Config.LangKey(value="config.lootgames.ms.board_size")
        @Config.Comment(value={"The size of Minesweeper board. Accepts only odd numbers. If you set this to even number, then it will be increased by one.", "Default: Stage 1 -> {13}, Stage 2 -> {15}, Stage 3 -> {17}, Stage 4 -> {19}"})
        @Config.RangeInt(min=5, max=19)
        public int boardSize;
        @Config.LangKey(value="config.lootgames.ms.bomb_count")
        @Config.Comment(value={"The amount of bombs on the board.", "Default: Stage 1 -> {20}, Stage 2 -> {30}, Stage 3 -> {42}, Stage 4 -> {20}"})
        @Config.RangeInt(min=1)
        public int bombCount;
        @Config.LangKey(value="config.lootgames.common.stage.loot_table")
        @Config.Comment(value={"Name of the loottable, items from which will be generated in the chest of this stage. This can be adjusted per-Dimension in S:DimensionalConfig.", "Default: Stage 1 -> minecraft:chests/simple_dungeon, Stage 2 -> minecraft:chests/desert_pyramid, Stage 3 -> minecraft:chests/nether_bridge, Stage 4 -> minecraft:chests/end_city_treasure"})
        public String lootTable;
        @Config.LangKey(value="config.lootgames.common.stage.min_items")
        @Config.Comment(value={"Minimum amount of items to be generated in chest. Won't be applied, if count of items in bound loot table are less than it. If min and max are set to -1, the limits will be disabled.", "Default: Stage 1 -> {15}, Stage 2 -> {-1}, Stage 3 -> {-1}, Stage 4 -> {-1}"})
        @Config.RangeInt(min=-1, max=256)
        public int minItems;
        @Config.LangKey(value="config.lootgames.common.stage.max_items")
        @Config.Comment(value={"Maximum amount of items to be generated in chest. If this is set to -1, max limit will be disabled.", "Default: Stage 1 -> {15}, Stage 2 -> {-1}, Stage 3 -> {-1}, Stage 4 -> {-1}"})
        @Config.RangeInt(min=-1, max=256)
        public int maxItems;
        @Config.LangKey(value="config.lootgames.ms.stage.dimconfig")
        @Config.Comment(value={"Here you can add different loottables to each dimension. If dimension isn't in this list, then game will take default loottable for this stage.", "Syntax: <dimension_id>; <loottable_name>", "<loottable_name> - The loottable name for the chest in this stage.", "General Example: { 0; minecraft:chests/simple_dungeon }", "Default: {}"})
        public String[] perDimensionConfigs = new String[0];
        @Config.Ignore
        private ResourceLocation lootTableRL;
        private HashMap<Integer, ResourceLocation> dimensionsConfigsMap;

        public Stage(int boardSize, int bombCount, String lootTable, int minItems, int maxItems) {
            this.boardSize = boardSize;
            this.bombCount = bombCount;
            this.lootTable = lootTable;
            this.minItems = minItems;
            this.maxItems = maxItems;
        }

        public void init() {
            if (this.boardSize % 2 == 0) {
                ++this.boardSize;
            }
            if (this.bombCount > this.boardSize * this.boardSize - 1) {
                LootGames.logHelper.error("Bomb count must be strictly less than amount of game fields. Current values: bomb count = {}, field count: {} (boardSize = {})\n Bomb count will be switched to {}.", new Object[]{this.bombCount, this.boardSize * this.boardSize, this.boardSize, this.boardSize * this.boardSize - 2});
                this.bombCount = this.boardSize * this.boardSize - 2;
            }
            this.parseLootTable();
            this.parseDimConfigs();
        }

        private void parseLootTable() {
            this.lootTableRL = new ResourceLocation(this.lootTable);
        }

        private void parseDimConfigs() {
            this.dimensionsConfigsMap = new HashMap();
            for (String entry : this.perDimensionConfigs) {
                String[] config = entry.split(";");
                for (int i = 0; i < config.length; ++i) {
                    config[i] = config[i].trim();
                }
                if (config.length == 2) {
                    if (IntHelper.isInt((String)config[0])) {
                        int dim = Integer.parseInt(config[0]);
                        if (this.dimensionsConfigsMap.containsKey(dim)) {
                            LootGames.logHelper.error("Invalid dimension configs entry found: {}. Dimension ID is already defined.", new Object[]{entry});
                            continue;
                        }
                        if (config[1].isEmpty()) {
                            LootGames.logHelper.error("Invalid dimension configs entry found: {}. LootTable ResourceLocation must not be an empty string. This setting will be skipped.", new Object[]{entry});
                            continue;
                        }
                        String lootTableDim = config[1];
                        this.dimensionsConfigsMap.put(dim, new ResourceLocation(lootTableDim));
                        continue;
                    }
                    LootGames.logHelper.error("Invalid dimension configs entry found: {}. Dimension ID must be an Integer.", new Object[]{entry});
                    continue;
                }
                LootGames.logHelper.error("Invalid dimension configs entry found: {}. Syntax is <dimension_id>; <loottable_resourcelocation>", new Object[]{entry});
            }
        }

        public ResourceLocation getLootTableRL(int dimensionID) {
            ResourceLocation lootTableDim = this.dimensionsConfigsMap.get(dimensionID);
            return lootTableDim == null ? this.lootTableRL : lootTableDim;
        }
    }
}

