/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.timeconqueror.timecore.api.auxiliary.RandHelper;

public class BlockDungeonBricks
extends Block {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockDungeonBricks() {
        super(Material.field_151576_e);
        this.func_149711_c(10.0f);
        this.func_149752_b(6.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"item.lootgames.dungeon_bricks.tooltip", (Object[])new Object[0]));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return state.func_177230_c().func_176201_c(state) != EnumType.DUNGEON_FLOOR_SHIELDED.getMeta();
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = blockState.func_177230_c().func_176201_c(blockState);
        float hardness = super.func_176195_g(blockState, worldIn, pos);
        if (meta == EnumType.DUNGEON_CEILING_CRACKED.getMeta() || meta == EnumType.DUNGEON_FLOOR_CRACKED.getMeta() || meta == EnumType.DUNGEON_WALL_CRACKED.getMeta()) {
            hardness = 2.0f;
        } else if (meta == EnumType.DUNGEON_FLOOR_SHIELDED.getMeta()) {
            hardness = -1.0f;
        }
        return hardness;
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int meta = this.func_176201_c(state);
        if (meta == EnumType.DUNGEON_CEILING.ordinal() || meta == EnumType.DUNGEON_FLOOR.getMeta() || meta == EnumType.DUNGEON_WALL.getMeta()) {
            meta = (Integer)RandHelper.flipCoin((Object)meta, (Object)EnumType.byMetadata(meta).getCrackedBlockMeta());
        }
        drops.add((Object)new ItemStack((Block)this, 1, ((Integer)RandHelper.flipCoin((Object)meta, (Object)EnumType.byMetadata(meta).getCrackedBlockMeta())).intValue()));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType value : EnumType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, value.getMeta()));
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        DUNGEON_WALL(0, 3, "dungeon_wall"),
        DUNGEON_CEILING(1, 4, "dungeon_ceiling"),
        DUNGEON_FLOOR(2, 5, "dungeon_floor"),
        DUNGEON_WALL_CRACKED(3, "dungeon_wall_cracked"),
        DUNGEON_CEILING_CRACKED(4, "dungeon_ceiling_cracked"),
        DUNGEON_FLOOR_CRACKED(5, "dungeon_floor_cracked"),
        DUNGEON_FLOOR_SHIELDED(6, "dungeon_floor_shielded");

        private static final EnumType[] META_LOOKUP;
        private int meta;
        private int crackedBlockMeta;
        private String name;

        private EnumType(int meta, String name) {
            this(meta, meta, name);
        }

        private EnumType(int meta, int crackedBlockMeta, String name) {
            this.meta = meta;
            this.crackedBlockMeta = crackedBlockMeta;
            this.name = name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public int getMeta() {
            return this.meta;
        }

        public int getCrackedBlockMeta() {
            return this.crackedBlockMeta;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.META_LOOKUP[value.getMeta()] = value = enumTypeArray[i];
            }
        }
    }
}

