/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.util;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.minigame.LootGame;
import ru.timeconqueror.timecore.api.auxiliary.DirectionTetra;

public class GameUtils {
    public static void spawnLootChest(World world, BlockPos centralPos, DirectionTetra offset, SpawnChestInfo chestInfo) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState chest = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)(offset == DirectionTetra.NORTH ? EnumFacing.SOUTH : (offset == DirectionTetra.SOUTH ? EnumFacing.NORTH : (offset == DirectionTetra.EAST ? EnumFacing.WEST : EnumFacing.EAST))));
        BlockPos placePos = centralPos.func_177982_a(offset.getOffsetX(), 0, offset.getOffsetZ());
        world.func_175656_a(placePos, chest);
        TileEntityChest teChest = (TileEntityChest)Objects.requireNonNull(world.func_175625_s(placePos));
        teChest.func_189404_a(chestInfo.getLootTableRL(), 0L);
        teChest.func_184281_d(null);
        ArrayList<Integer> notEmptyIndexes = new ArrayList<Integer>();
        for (int i = 0; i < teChest.func_70302_i_(); ++i) {
            if (teChest.func_70301_a(i) == ItemStack.field_190927_a) continue;
            notEmptyIndexes.add(i);
        }
        if (notEmptyIndexes.size() == 0) {
            ItemStack stack = new ItemStack(Blocks.field_150348_b);
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)String.format("{display:{Name:\"The Sorry Stone\",Lore:[\"Modpack creator failed to configure the LootTables properly.\",\"Please report that LootList [%s] for %s stage is broken, thank you!\"]}}", chestInfo.getLootTableRL(), chestInfo.getGameName())));
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
            teChest.func_70299_a(0, stack);
            return;
        }
        int minItems = chestInfo.getMinItems();
        int maxItems = chestInfo.getMaxItems();
        if (minItems != -1 || maxItems != -1) {
            int itemCount;
            int min = minItems == -1 ? 0 : minItems;
            int extra = (maxItems == -1 ? notEmptyIndexes.size() : maxItems) - minItems;
            int n = itemCount = extra < 1 ? min : min + LootGames.RAND.nextInt(extra);
            if (itemCount < notEmptyIndexes.size()) {
                int i;
                int[] itemsRemain = new int[itemCount];
                for (i = 0; i < itemsRemain.length; ++i) {
                    int itemRemainArrIndex = LootGames.RAND.nextInt(notEmptyIndexes.size());
                    int itemRemainChestIndex = (Integer)notEmptyIndexes.get(itemRemainArrIndex);
                    notEmptyIndexes.remove(itemRemainArrIndex);
                    itemsRemain[i] = itemRemainChestIndex;
                }
                for (i = 0; i < teChest.func_70302_i_(); ++i) {
                    boolean toDelete = true;
                    for (int i1 : itemsRemain) {
                        if (i != i1) continue;
                        toDelete = false;
                        break;
                    }
                    if (!toDelete) continue;
                    teChest.func_70304_b(i);
                }
            }
        }
    }

    public static class SpawnChestInfo {
        private ResourceLocation lootTableRL;
        private Class<? extends LootGame> gameClass;
        private int minItems;
        private int maxItems;

        public SpawnChestInfo(Class<? extends LootGame> gameClass, ResourceLocation lootTableRL, int minItems, int maxItems) {
            this.lootTableRL = lootTableRL;
            this.minItems = minItems;
            this.maxItems = maxItems;
            this.gameClass = gameClass;
        }

        public String getGameName() {
            return this.gameClass.getSimpleName();
        }

        public int getMaxItems() {
            return this.maxItems;
        }

        public int getMinItems() {
            return this.minItems;
        }

        public ResourceLocation getLootTableRL() {
            return this.lootTableRL;
        }
    }
}

