/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape.select;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.shape.drag.DragShape;
import com.creativemd.littletiles.common.util.shape.select.SelectShapeConnected;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SelectShape {
    private static LinkedHashMap<String, SelectShape> shapes = new LinkedHashMap();
    public static SelectShape tileShape = new SelectShape("tile"){

        @Override
        public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        }

        @Override
        public boolean rightClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return false;
        }

        @Override
        public boolean leftClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return true;
        }

        @Override
        public LittleBoxes getHighlightBoxes(World world, BlockPos pos, EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return this.getBoxes(world, pos, player, nbt, result, context);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
            return new ArrayList<GuiControl>();
        }

        @Override
        public LittleBoxes getBoxes(World world, BlockPos pos, EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            LittleBoxes boxes;
            BlockTile.TEResult te = BlockTile.loadTeAndTile((IBlockAccess)world, pos, player);
            if (te.isComplete()) {
                boxes = new LittleBoxes(te.te.func_174877_v(), te.te.getContext());
                boxes.add(te.tile.getBox().copy());
            } else {
                boxes = new LittleBoxes(pos, context);
                boxes.add(new LittleBox(0, 0, 0, context.size, context.size, context.size));
            }
            return boxes;
        }

        @Override
        public void deselect(EntityPlayer player, NBTTagCompound nbt, LittleGridContext context) {
        }

        @Override
        public void addExtraInformation(World world, NBTTagCompound nbt, List<String> list, LittleGridContext context) {
        }
    };
    public static final SelectShape TYPE = new SelectShape("type"){

        @Override
        public boolean rightClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return false;
        }

        @Override
        public boolean leftClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return true;
        }

        @Override
        public LittleBoxes getHighlightBoxes(World world, BlockPos pos, EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return this.getBoxes(world, pos, player, nbt, result, context);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
            return new ArrayList<GuiControl>();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        }

        @Override
        public LittleBoxes getBoxes(World world, BlockPos pos, EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            LittleBoxes boxes;
            BlockTile.TEResult te = BlockTile.loadTeAndTile((IBlockAccess)world, pos, player);
            if (te.isComplete()) {
                LittleTile tile = te.tile;
                boxes = new LittleBoxes(te.te.func_174877_v(), te.te.getContext());
                if (te.parent.isStructure()) {
                    return boxes;
                }
                boxes.add(te.tile.getBox().copy());
                for (Pair<IParentTileList, LittleTile> pair : te.te.allTiles()) {
                    LittleTile toDestroy = (LittleTile)pair.value;
                    if (((IParentTileList)pair.key).isStructure() || !tile.canBeCombined(toDestroy) || !toDestroy.canBeCombined(tile)) continue;
                    boxes.addBox((IParentTileList)pair.key, toDestroy);
                }
            } else {
                boxes = new LittleBoxes(pos, context);
                boxes.add(new LittleBox(0, 0, 0, context.size, context.size, context.size));
            }
            return boxes;
        }

        @Override
        public void deselect(EntityPlayer player, NBTTagCompound nbt, LittleGridContext context) {
        }

        @Override
        public void addExtraInformation(World world, NBTTagCompound nbt, List<String> list, LittleGridContext context) {
        }
    };
    public static final SelectShape CONNECTED = new SelectShapeConnected();
    public static final BasicSelectShape CUBE = new BasicSelectShape("cube"){

        @Override
        public LittleBox getBox(LittleVec vec, int thickness, EnumFacing side, LittleGridContext context) {
            LittleVec offset = new LittleVec(side);
            offset.scale((thickness - 1) / 2);
            vec.sub(offset);
            if ((thickness & 1) == 0 && side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                vec.sub(side);
            }
            LittleBox box = new LittleBox(vec, thickness, thickness, thickness);
            return box;
        }
    };
    public static final BasicSelectShape BAR = new BasicSelectShape("bar"){

        @Override
        public LittleBox getBox(LittleVec vec, int thickness, EnumFacing side, LittleGridContext context) {
            LittleBox box = CUBE.getBox(vec, thickness, side, context);
            switch (side.func_176740_k()) {
                case X: {
                    box.minX = 0;
                    box.maxX = context.size;
                    break;
                }
                case Y: {
                    box.minY = 0;
                    box.maxY = context.size;
                    break;
                }
                case Z: {
                    box.minZ = 0;
                    box.maxZ = context.size;
                }
            }
            return box;
        }
    };
    public static final BasicSelectShape PLANE = new BasicSelectShape("plane"){

        @Override
        public LittleBox getBox(LittleVec vec, int thickness, EnumFacing side, LittleGridContext context) {
            LittleBox box = CUBE.getBox(vec, thickness, side, context);
            switch (side.func_176740_k()) {
                case X: {
                    box.minY = 0;
                    box.maxY = context.size;
                    box.minZ = 0;
                    box.maxZ = context.size;
                    break;
                }
                case Y: {
                    box.minX = 0;
                    box.maxX = context.size;
                    box.minZ = 0;
                    box.maxZ = context.size;
                    break;
                }
                case Z: {
                    box.minX = 0;
                    box.maxX = context.size;
                    box.minY = 0;
                    box.maxY = context.size;
                }
            }
            return box;
        }
    };
    public static final DragSelectShape DRAG_BOX = new DragSelectShape(DragShape.box);
    public static final SelectShape defaultShape = DRAG_BOX;
    public final String key;

    public static void registerShape(SelectShape shape) {
        shapes.put(shape.key, shape);
    }

    public static Set<String> keys() {
        return shapes.keySet();
    }

    public static SelectShape getShape(String name) {
        SelectShape shape = shapes.get(name);
        return shape == null ? defaultShape : shape;
    }

    public SelectShape(String name) {
        this.key = name;
    }

    public abstract LittleBoxes getHighlightBoxes(World var1, BlockPos var2, EntityPlayer var3, NBTTagCompound var4, RayTraceResult var5, LittleGridContext var6);

    public abstract LittleBoxes getBoxes(World var1, BlockPos var2, EntityPlayer var3, NBTTagCompound var4, RayTraceResult var5, LittleGridContext var6);

    public abstract boolean rightClick(EntityPlayer var1, NBTTagCompound var2, RayTraceResult var3, LittleGridContext var4);

    public abstract boolean leftClick(EntityPlayer var1, NBTTagCompound var2, RayTraceResult var3, LittleGridContext var4);

    public abstract void deselect(EntityPlayer var1, NBTTagCompound var2, LittleGridContext var3);

    public abstract void addExtraInformation(World var1, NBTTagCompound var2, List<String> var3, LittleGridContext var4);

    @SideOnly(value=Side.CLIENT)
    public abstract List<GuiControl> getCustomSettings(NBTTagCompound var1, LittleGridContext var2);

    @SideOnly(value=Side.CLIENT)
    public abstract void saveCustomSettings(GuiParent var1, NBTTagCompound var2, LittleGridContext var3);

    public void rotate(Rotation rotation, NBTTagCompound nbt) {
    }

    public void flip(EnumFacing.Axis axis, NBTTagCompound nbt) {
    }

    static {
        for (DragShape shape : DragShape.shapes()) {
            if (shape == DragShape.box) {
                SelectShape.registerShape(DRAG_BOX);
                continue;
            }
            SelectShape.registerShape(new DragSelectShape(shape));
        }
        SelectShape.registerShape(TYPE);
        SelectShape.registerShape(CONNECTED);
        SelectShape.registerShape(CUBE);
        SelectShape.registerShape(BAR);
        SelectShape.registerShape(PLANE);
    }

    public static class DragSelectShape
    extends SelectShape {
        private final DragShape shape;
        public PlacementPosition first;

        public DragSelectShape(DragShape shape) {
            super("drag" + shape.key);
            this.shape = shape;
        }

        public LittleBoxes getBoxes(EntityPlayer player, NBTTagCompound nbt, PlacementPosition min, PlacementPosition max, boolean preview, LittleGridContext context) {
            min.forceContext(max);
            LittleAbsoluteVec offset = new LittleAbsoluteVec(min.getPos(), min.getContext());
            LittleBox box = new LittleBox(new LittleBox(min.getRelative(offset).getVec(context)), new LittleBox(max.getRelative(offset).getVec(context)));
            return this.shape.getBoxes(new LittleBoxes(offset.getPos(), context), box.getMinVec(), box.getMaxVec(), player, nbt, preview, min, max);
        }

        @Override
        public LittleBoxes getHighlightBoxes(World world, BlockPos pos, EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            PlacementPosition vec = new PlacementPosition(result, context);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && context.isAtEdge(VectorUtils.get((EnumFacing.Axis)result.field_178784_b.func_176740_k(), (Vec3d)result.field_72307_f))) {
                vec.getVec().sub(result.field_178784_b);
            }
            if (this.first == null) {
                LittleBoxes boxes = new LittleBoxes(result.func_178782_a(), context);
                boxes.add(new LittleBox(vec.getRelative(new LittleAbsoluteVec(result.func_178782_a(), context)).getVec(context)));
                return boxes;
            }
            return this.getBoxes(player, nbt, this.first, vec, true, context);
        }

        @Override
        public boolean rightClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return false;
        }

        @Override
        public boolean leftClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            if (this.first != null) {
                return true;
            }
            this.first = new PlacementPosition(result, context);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && context.isAtEdge(VectorUtils.get((EnumFacing.Axis)result.field_178784_b.func_176740_k(), (Vec3d)result.field_72307_f))) {
                this.first.getVec().sub(result.field_178784_b);
            }
            return false;
        }

        @Override
        public void deselect(EntityPlayer player, NBTTagCompound nbt, LittleGridContext context) {
            this.first = null;
        }

        @Override
        public LittleBoxes getBoxes(World world, BlockPos pos, EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            PlacementPosition vec = new PlacementPosition(result, context);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && context.isAtEdge(VectorUtils.get((EnumFacing.Axis)result.field_178784_b.func_176740_k(), (Vec3d)result.field_72307_f))) {
                vec.getVec().sub(result.field_178784_b);
            }
            LittleBoxes boxes = this.getBoxes(player, nbt, this.first, vec, false, context);
            this.first = null;
            return boxes;
        }

        @Override
        public void addExtraInformation(World world, NBTTagCompound nbt, List<String> list, LittleGridContext context) {
            this.shape.addExtraInformation(nbt, list);
        }

        @Override
        public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
            return this.shape.getCustomSettings(nbt, context);
        }

        @Override
        public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
            this.shape.saveCustomSettings(gui, nbt, context);
        }

        @Override
        public void flip(EnumFacing.Axis axis, NBTTagCompound nbt) {
            this.shape.flip(nbt, axis);
        }

        @Override
        public void rotate(Rotation rotation, NBTTagCompound nbt) {
            this.shape.rotate(nbt, rotation);
        }
    }

    public static abstract class BasicSelectShape
    extends SelectShape {
        public BasicSelectShape(String name) {
            super(name);
        }

        @Override
        public void deselect(EntityPlayer player, NBTTagCompound nbt, LittleGridContext context) {
        }

        @Override
        public boolean rightClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return false;
        }

        @Override
        public boolean leftClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return true;
        }

        @Override
        public LittleBoxes getHighlightBoxes(World world, BlockPos pos, EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            int thickness = nbt.func_74762_e("thick");
            if (thickness > context.size) {
                thickness = context.size;
                nbt.func_74768_a("thick", thickness);
            }
            LittleBoxes boxes = new LittleBoxes(result.func_178782_a(), context);
            LittleAbsoluteVec vec = new LittleAbsoluteVec(result, context);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && context.isAtEdge(VectorUtils.get((EnumFacing.Axis)result.field_178784_b.func_176740_k(), (Vec3d)result.field_72307_f))) {
                vec.getVec().sub(result.field_178784_b);
            }
            boxes.add(this.getBox(vec.getRelative(new LittleAbsoluteVec(result.func_178782_a(), context)).getVec(context), Math.max(1, nbt.func_74762_e("thick")), result.field_178784_b, context));
            return boxes;
        }

        @Override
        public LittleBoxes getBoxes(World world, BlockPos pos, EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            int thickness = nbt.func_74762_e("thick");
            if (thickness > context.size) {
                thickness = context.size;
                nbt.func_74768_a("thick", thickness);
            }
            LittleBoxes boxes = new LittleBoxes(result.func_178782_a(), context);
            LittleAbsoluteVec vec = new LittleAbsoluteVec(result, context);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && context.isAtEdge(VectorUtils.get((EnumFacing.Axis)result.field_178784_b.func_176740_k(), (Vec3d)result.field_72307_f))) {
                vec.getVec().sub(result.field_178784_b);
            }
            boxes.add(this.getBox(vec.getRelative(new LittleAbsoluteVec(result.func_178782_a(), context)).getVec(context), Math.max(1, nbt.func_74762_e("thick")), result.field_178784_b, context));
            return boxes;
        }

        @Override
        public void addExtraInformation(World world, NBTTagCompound nbt, List<String> list, LittleGridContext context) {
            list.add("thickness: " + Math.max(1, nbt.func_74762_e("thick")));
        }

        public abstract LittleBox getBox(LittleVec var1, int var2, EnumFacing var3, LittleGridContext var4);

        @Override
        public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
            ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
            controls.add((GuiControl)new GuiLabel("Size:", 0, 6));
            controls.add((GuiControl)new GuiSteppedSlider("thickness", 35, 5, 68, 10, Math.max(1, nbt.func_74762_e("thick")), 1, context.size));
            return controls;
        }

        @Override
        public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
            GuiSteppedSlider thickness = (GuiSteppedSlider)gui.get("thickness");
            nbt.func_74768_a("thick", (int)thickness.value);
        }
    }
}

