/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.vec;

import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.security.InvalidParameterException;
import javax.vecmath.Vector3d;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class LittleVecContext
implements IGridBased {
    protected LittleVec vec;
    protected LittleGridContext context;

    public LittleVecContext() {
        this(new LittleVec(0, 0, 0), LittleGridContext.getMin());
    }

    public LittleVecContext(String name, NBTTagCompound nbt) {
        int[] array = nbt.func_74759_k(name);
        if (array.length == 3) {
            LittleVec vec = new LittleVec(name, nbt);
            this.context = LittleGridContext.get();
            this.vec = new LittleVec(vec.x, vec.y, vec.z);
        } else if (array.length == 4) {
            this.vec = new LittleVec(array[0], array[1], array[2]);
            this.context = LittleGridContext.get(array[3]);
        } else {
            throw new InvalidParameterException("No valid coords given " + nbt);
        }
    }

    public LittleVecContext(LittleVec vec, LittleGridContext context) {
        this.vec = vec;
        this.context = context;
    }

    @Override
    public LittleGridContext getContext() {
        return this.context;
    }

    @Override
    public void convertTo(LittleGridContext to) {
        this.vec.convertTo(this.context, to);
        this.context = to;
    }

    public int getSmallestContext() {
        return this.vec.getSmallestContext(this.context);
    }

    @Override
    public void convertToSmallest() {
        int size = this.vec.getSmallestContext(this.context);
        if (size < this.context.size) {
            this.convertTo(LittleGridContext.get(size));
        }
    }

    public void add(LittleVecContext vec) {
        this.ensureContext(vec, () -> this.vec.add(vec.vec));
    }

    public void add(BlockPos pos) {
        this.vec.add(pos, this.context);
    }

    public void sub(LittleVecContext vec) {
        this.ensureContext(vec, () -> this.vec.sub(vec.vec));
    }

    public void sub(BlockPos pos) {
        this.vec.sub(pos, this.context);
    }

    public LittleVecContext copy() {
        return new LittleVecContext(this.vec.copy(), this.context);
    }

    public BlockPos getBlockPos() {
        return this.vec.getBlockPos(this.context);
    }

    public double getPosX() {
        return this.vec.getPosX(this.context);
    }

    public double getPosY() {
        return this.vec.getPosY(this.context);
    }

    public double getPosZ() {
        return this.vec.getPosZ(this.context);
    }

    public LittleVec getVec() {
        return this.vec;
    }

    public Vec3d getVec3d() {
        return this.vec.getVec(this.context);
    }

    public Vector3d getVector() {
        return this.vec.getVector(this.context);
    }

    public LittleVec getVec(LittleGridContext context) {
        if (context == this.context) {
            return this.vec.copy();
        }
        LittleVec newVec = this.vec.copy();
        newVec.convertTo(this.context, context);
        return newVec;
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74783_a(name, new int[]{this.vec.x, this.vec.y, this.vec.z, this.context.size});
    }

    public int hashCode() {
        return this.vec.hashCode();
    }

    @Deprecated
    public void overwriteContext(LittleGridContext context) {
        this.context = context;
    }

    public boolean equals(Object paramObject) {
        if (paramObject instanceof LittleVecContext) {
            LittleVecContext otherVec = (LittleVecContext)paramObject;
            LittleGridContext oldContext = this.context;
            LittleGridContext oldContextPos = otherVec.context;
            if (this.getContext() != otherVec.getContext()) {
                if (this.getContext().size > otherVec.getContext().size) {
                    otherVec.convertTo(this.getContext());
                } else {
                    this.convertTo(otherVec.getContext());
                }
            }
            boolean equal = this.context == otherVec.context && this.vec.equals(otherVec.vec);
            otherVec.convertTo(oldContextPos);
            this.convertTo(oldContext);
            return equal;
        }
        return super.equals(paramObject);
    }

    public String toString() {
        return "[" + this.vec.x + "," + this.vec.y + "," + this.vec.z + ",grid:" + this.context.size + "]";
    }
}

