/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.recipe;

import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.creativecore.common.utils.sorting.BlockSelector;
import com.creativemd.creativecore.common.utils.stack.InfoItem;
import com.creativemd.creativecore.common.utils.stack.InfoItemStack;
import com.creativemd.creativecore.common.utils.stack.InfoOre;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.block.BlockLittleDyeable;
import com.creativemd.littletiles.common.block.BlockLittleDyeable2;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class WhitenRecipeRegistry {
    public static int whitenerTotalVolume = 1000;
    private static List<WhitenRecipe> recipes = new ArrayList<WhitenRecipe>();
    private static List<WhitenVolume> whitener = new ArrayList<WhitenVolume>();

    public static void registerWhitenRecipe(WhitenRecipe recipe) {
        recipes.add(recipe);
    }

    public static void registerWhitener(InfoStack stack, int volume) {
        whitener.add(new WhitenVolume(stack, volume));
    }

    public static List<WhitenRecipe> getRecipe(ItemStack stack) {
        IBlockState state = BlockUtils.getState((ItemStack)stack);
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        ArrayList<WhitenRecipe> results = new ArrayList<WhitenRecipe>();
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).is(block, meta)) continue;
            results.add(recipes.get(i));
        }
        return results;
    }

    public static int getVolume(ItemStack stack) {
        for (int i = 0; i < whitener.size(); ++i) {
            if (!WhitenRecipeRegistry.whitener.get((int)i).stack.isInstanceIgnoreSize(stack)) continue;
            return WhitenRecipeRegistry.whitener.get((int)i).volume;
        }
        return 0;
    }

    static {
        WhitenRecipeRegistry.registerWhitener((InfoStack)new InfoOre("dyeWhite"), 4);
        WhitenRecipeRegistry.registerWhitener((InfoStack)new InfoOre("dyeLightGray"), 2);
        WhitenRecipeRegistry.registerWhitener((InfoStack)new InfoOre("dyeGray"), 1);
        WhitenRecipeRegistry.registerWhitener((InfoStack)new InfoOre("woolWhite"), 8);
        WhitenRecipeRegistry.registerWhitener((InfoStack)new InfoOre("woolLightGray"), 4);
        WhitenRecipeRegistry.registerWhitener((InfoStack)new InfoOre("woolGray"), 2);
        WhitenRecipeRegistry.registerWhitener((InfoStack)new InfoItemStack(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.HOUSTONIA.func_176968_b())), 4);
        WhitenRecipeRegistry.registerWhitener((InfoStack)new InfoItemStack(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b())), 4);
        WhitenRecipeRegistry.registerWhitener((InfoStack)new InfoItemStack(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.WHITE_TULIP.func_176968_b())), 4);
        WhitenRecipeRegistry.registerWhitener((InfoStack)new InfoItem(Items.field_151102_aT), 1);
        WhitenRecipeRegistry.registerWhitenRecipe(new WhitenRecipe((BlockSelector)new BlockSelector.BlockSelectorBlock(Blocks.field_150347_e), 1, LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.GRAINY), LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.GRAINY_BIG)));
        WhitenRecipeRegistry.registerWhitenRecipe(new WhitenRecipe((BlockSelector)new BlockSelector.BlockSelectorBlock(Blocks.field_150347_e), 2, LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.GRAINY_LOW)));
        WhitenRecipeRegistry.registerWhitenRecipe(new WhitenRecipe((BlockSelector)new BlockSelector.BlockSelectorBlock(Blocks.field_150348_b), 1, LittleTiles.dyeableBlock2.get(BlockLittleDyeable2.LittleDyeableType2.GRAVEL), LittleTiles.dyeableBlock2.get(BlockLittleDyeable2.LittleDyeableType2.SAND), LittleTiles.dyeableBlock2.get(BlockLittleDyeable2.LittleDyeableType2.STONE), LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.CLAY)));
        WhitenRecipeRegistry.registerWhitenRecipe(new WhitenRecipe((BlockSelector)new BlockSelector.BlockSelectorBlock(Blocks.field_150348_b), 2, LittleTiles.dyeableBlock2.get(BlockLittleDyeable2.LittleDyeableType2.CORK)));
        BlockSelector.BlockSelectorBlocks selector = new BlockSelector.BlockSelectorBlocks(new Block[]{Blocks.field_150417_aV, Blocks.field_150336_V});
        WhitenRecipeRegistry.registerWhitenRecipe(new WhitenRecipe((BlockSelector)selector, 1, LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.BRICK), LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.BRICK_BIG), LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.BROKEN_BRICK_BIG), LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.CHISELED), LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.STRIPS)));
        WhitenRecipeRegistry.registerWhitenRecipe(new WhitenRecipe((BlockSelector)selector, 2, LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.BORDERED), LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.FLOOR)));
        WhitenRecipeRegistry.registerWhitenRecipe(new WhitenRecipe((BlockSelector)new BlockSelector.BlockSelectorMaterial(Material.field_151576_e), 4, LittleTiles.dyeableBlock.get(BlockLittleDyeable.LittleDyeableType.CLEAN)));
    }

    public static class WhitenRecipe {
        public final BlockSelector selector;
        public final IBlockState[] results;
        public final int needed;

        public WhitenRecipe(BlockSelector selector, int needed, IBlockState ... results) {
            this.selector = selector;
            this.needed = needed;
            this.results = results;
        }

        public boolean is(Block block, int meta) {
            if (this.selector.is(block, meta)) {
                return true;
            }
            for (int i = 0; i < this.results.length; ++i) {
                IBlockState state = this.results[i];
                if (state.func_177230_c() != block || state.func_177230_c().func_176201_c(state) != meta) continue;
                return true;
            }
            return false;
        }

        public boolean isResult(ItemStack stack) {
            IBlockState otherState = BlockUtils.getState((ItemStack)stack);
            for (int i = 0; i < this.results.length; ++i) {
                IBlockState state = this.results[i];
                if (state.func_177230_c() != otherState.func_177230_c() || state.func_177230_c().func_176201_c(state) != otherState.func_177230_c().func_176201_c(otherState)) continue;
                return true;
            }
            return false;
        }
    }

    public static class WhitenVolume {
        public InfoStack stack;
        public int volume;

        public WhitenVolume(InfoStack stack, int volume) {
            this.stack = stack;
            this.volume = volume;
        }
    }
}

