/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.IAnimatedStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationController;
import com.creativemd.littletiles.common.util.vec.LittleTransformation;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public abstract class EntityAnimationController
extends AnimationController {
    private static HashMap<String, Class<? extends EntityAnimationController>> controllerTypes = new HashMap();
    private static HashMap<Class<? extends EntityAnimationController>, String> controllerTypesInv = new HashMap();
    public EntityAnimation parent;

    public static void registerControllerType(String id, Class<? extends EntityAnimationController> controllerType) {
        controllerTypes.put(id, controllerType);
        controllerTypesInv.put(controllerType, id);
    }

    public void setParent(EntityAnimation parent) {
        this.parent = parent;
        if (parent.structure != null && parent.structure instanceof IAnimatedStructure) {
            ((IAnimatedStructure)((Object)parent.structure)).setAnimation(parent);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("id", controllerTypesInv.get(this.getClass()));
        this.writeToNBTExtra(nbt);
        return nbt;
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);

    protected abstract void readFromNBT(NBTTagCompound var1);

    public EntityPlayer activator() {
        return null;
    }

    public boolean noClip() {
        return false;
    }

    public abstract void transform(LittleTransformation var1);

    public static EntityAnimationController parseController(EntityAnimation animation, NBTTagCompound nbt) {
        Class<? extends EntityAnimationController> controllerType = controllerTypes.get(nbt.func_74779_i("id"));
        if (controllerType == null) {
            throw new RuntimeException("Unkown controller type '" + nbt.func_74779_i("id") + "'");
        }
        try {
            EntityAnimationController controller = controllerType.getConstructor(new Class[0]).newInstance(new Object[0]);
            controller.setParent(animation);
            controller.readFromNBT(nbt);
            return controller;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        EntityAnimationController.registerControllerType("door", DoorController.class);
    }
}

