/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media.callback.seekable;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import uk.co.caprica.vlcj.media.callback.seekable.SeekableCallbackMedia;

public class RandomAccessFileMedia
extends SeekableCallbackMedia {
    private final File file;
    private RandomAccessFile randomAccessFile;

    public RandomAccessFileMedia(File file) {
        this.file = file;
    }

    public RandomAccessFileMedia(File file, int ioBufferSize) {
        super(ioBufferSize, new String[0]);
        this.file = file;
    }

    @Override
    protected long onGetSize() {
        return this.file.length();
    }

    @Override
    protected boolean onOpen() {
        try {
            this.randomAccessFile = new RandomAccessFile(this.file, "r");
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    protected int onRead(byte[] buffer, int bufferSize) throws IOException {
        return this.randomAccessFile.read(buffer, 0, bufferSize);
    }

    @Override
    protected boolean onSeek(long offset) {
        try {
            this.randomAccessFile.seek(offset);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected void onClose() {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

