/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.NativeString;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_slave_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.media.MediaSlave;
import uk.co.caprica.vlcj.media.MediaSlaveType;

final class MediaSlaves {
    private MediaSlaves() {
    }

    static List<MediaSlave> getMediaSlaves(libvlc_media_t media) {
        PointerByReference slavesPointer = new PointerByReference();
        int numberOfSlaves = LibVlc.libvlc_media_slaves_get(media, slavesPointer);
        ArrayList<MediaSlave> result = new ArrayList<MediaSlave>(numberOfSlaves);
        if (numberOfSlaves > 0) {
            Pointer[] pointers;
            for (Pointer pointer : pointers = slavesPointer.getValue().getPointerArray(0L, numberOfSlaves)) {
                libvlc_media_slave_t slave = new libvlc_media_slave_t(pointer);
                result.add(new MediaSlave(NativeString.copyNativeString(slave.psz_uri), MediaSlaveType.mediaSlaveType(slave.i_type), slave.i_priority));
            }
        }
        LibVlc.libvlc_media_slaves_release(slavesPointer.getValue(), numberOfSlaves);
        return result;
    }
}

