/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.gui;

import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCounterDecimal;
import com.creativemd.creativecore.common.gui.controls.gui.GuiIconButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.gui.GuiUrlTextfield;
import team.creative.littleframes.client.texture.TextureCache;
import team.creative.littleframes.client.texture.TextureSeeker;
import team.creative.littleframes.common.block.TileEntityCreativeFrame;

@SideOnly(value=Side.CLIENT)
public class SubGuiCreativeFrame
extends SubGui {
    public TileEntityCreativeFrame frame;
    public float scaleMultiplier;
    public GuiTextfield url;
    public GuiButton save;

    public SubGuiCreativeFrame(TileEntityCreativeFrame frame) {
        this(frame, false, 16);
    }

    public SubGuiCreativeFrame(TileEntityCreativeFrame frame, boolean editFacing, int scaleSize) {
        super(200, editFacing ? 220 : 200);
        this.frame = frame;
        this.scaleMultiplier = 1.0f / (float)scaleSize;
    }

    public void createControls() {
        this.save = new GuiButton(SubGuiCreativeFrame.translate((String)"gui.creative_frame.save"), 144, 180, 50){

            public void onClicked(int x, int y, int button) {
                NBTTagCompound nbt = new NBTTagCompound();
                GuiTextfield url = (GuiTextfield)SubGuiCreativeFrame.this.get("url");
                GuiCounterDecimal sizeX = (GuiCounterDecimal)SubGuiCreativeFrame.this.get("sizeX");
                GuiCounterDecimal sizeY = (GuiCounterDecimal)SubGuiCreativeFrame.this.get("sizeY");
                GuiStateButton buttonPosX = (GuiStateButton)SubGuiCreativeFrame.this.get("posX");
                GuiStateButton buttonPosY = (GuiStateButton)SubGuiCreativeFrame.this.get("posY");
                GuiAnalogeSlider rotation = (GuiAnalogeSlider)SubGuiCreativeFrame.this.get("rotation");
                GuiCheckBox flipX = (GuiCheckBox)SubGuiCreativeFrame.this.get("flipX");
                GuiCheckBox flipY = (GuiCheckBox)SubGuiCreativeFrame.this.get("flipY");
                GuiCheckBox visibleFrame = (GuiCheckBox)SubGuiCreativeFrame.this.get("visibleFrame");
                GuiCheckBox bothSides = (GuiCheckBox)SubGuiCreativeFrame.this.get("bothSides");
                GuiSteppedSlider renderDistance = (GuiSteppedSlider)SubGuiCreativeFrame.this.get("renderDistance");
                GuiAnalogeSlider transparency = (GuiAnalogeSlider)SubGuiCreativeFrame.this.get("transparency");
                GuiAnalogeSlider brightness = (GuiAnalogeSlider)SubGuiCreativeFrame.this.get("brightness");
                GuiCheckBox loop = (GuiCheckBox)SubGuiCreativeFrame.this.get("loop");
                GuiAnalogeSlider volume = (GuiAnalogeSlider)SubGuiCreativeFrame.this.get("volume");
                nbt.func_74774_a("posX", (byte)buttonPosX.getState());
                nbt.func_74774_a("posY", (byte)buttonPosY.getState());
                nbt.func_74776_a("rotation", (float)rotation.value);
                nbt.func_74757_a("flipX", flipX.value);
                nbt.func_74757_a("flipY", flipY.value);
                nbt.func_74757_a("visibleFrame", visibleFrame.value);
                nbt.func_74757_a("bothSides", bothSides.value);
                nbt.func_74768_a("render", (int)renderDistance.value);
                nbt.func_74776_a("transparency", (float)transparency.value);
                nbt.func_74776_a("brightness", (float)brightness.value);
                nbt.func_74757_a("loop", loop.value);
                nbt.func_74776_a("volume", (float)volume.value);
                nbt.func_74778_a("url", url.text);
                nbt.func_74776_a("x", Math.max(0.1f, sizeX.getValue()));
                nbt.func_74776_a("y", Math.max(0.1f, sizeY.getValue()));
                SubGuiCreativeFrame.this.sendPacketToServer(nbt);
            }
        };
        this.url = new GuiUrlTextfield(this.save, "url", this.frame.getRealURL(), 0, 0, 194, 16);
        this.url.maxLength = 512;
        this.controls.add(this.url);
        this.controls.add(new GuiLabel(SubGuiCreativeFrame.translate((String)(this.frame.cache != null && this.frame.cache.getError() != null ? this.frame.cache.getError() : "")), 0, 20, -65536));
        this.save.setEnabled(LittleFrames.CONFIG.canUse((EntityPlayer)SubGuiCreativeFrame.mc.field_71439_g, this.url.text));
        this.controls.add(this.save);
        this.controls.add(new GuiCounterDecimal("sizeX", 0, 33, 50, this.frame.getSizeX(), 0.0f, Float.MAX_VALUE){

            public float stepUp(float value) {
                int scaled = (int)(value / SubGuiCreativeFrame.this.scaleMultiplier);
                return Math.min(this.max, (float)(++scaled) * SubGuiCreativeFrame.this.scaleMultiplier);
            }

            public float stepDown(float value) {
                int scaled = (int)(value / SubGuiCreativeFrame.this.scaleMultiplier);
                return Math.max(this.min, (float)(--scaled) * SubGuiCreativeFrame.this.scaleMultiplier);
            }
        });
        this.controls.add(new GuiCounterDecimal("sizeY", 96, 33, 50, this.frame.getSizeY(), 0.0f, Float.MAX_VALUE){

            public float stepUp(float value) {
                int scaled = (int)(value / SubGuiCreativeFrame.this.scaleMultiplier);
                return Math.min(this.max, (float)(++scaled) * SubGuiCreativeFrame.this.scaleMultiplier);
            }

            public float stepDown(float value) {
                int scaled = (int)(value / SubGuiCreativeFrame.this.scaleMultiplier);
                return Math.max(this.min, (float)(--scaled) * SubGuiCreativeFrame.this.scaleMultiplier);
            }
        });
        this.controls.add(new GuiButton("reX", "x->y", 62, 33, 25, 15){

            public void onClicked(int x, int y, int button) {
            }
        });
        this.controls.add(new GuiButton("reY", "y->x", 158, 33, 25, 15){

            public void onClicked(int x, int y, int button) {
            }
        });
        this.controls.add(new GuiCheckBox("flipX", SubGuiCreativeFrame.translate((String)"gui.creative_frame.flipx"), 0, 54, this.frame.flipX));
        this.controls.add(new GuiCheckBox("flipY", SubGuiCreativeFrame.translate((String)"gui.creative_frame.flipy"), 75, 54, this.frame.flipY));
        this.controls.add(new GuiStateButton("posX", this.frame.min.x == 0.0f ? 0 : (this.frame.max.x == 1.0f ? 2 : 1), 0, 68, 70, new String[]{SubGuiCreativeFrame.translate((String)"gui.creative_frame.posX.left"), SubGuiCreativeFrame.translate((String)"gui.creative_frame.posX.center"), SubGuiCreativeFrame.translate((String)"gui.creative_frame.posX.right")}));
        this.controls.add(new GuiStateButton("posY", this.frame.min.y == 0.0f ? 0 : (this.frame.max.y == 1.0f ? 2 : 1), 80, 68, 70, new String[]{SubGuiCreativeFrame.translate((String)"gui.creative_frame.posY.top"), SubGuiCreativeFrame.translate((String)"gui.creative_frame.posY.center"), SubGuiCreativeFrame.translate((String)"gui.creative_frame.posY.bottom")}));
        this.controls.add(new GuiAnalogeSlider("rotation", 0, 93, 80, 10, (double)this.frame.rotation, 0.0, 360.0));
        this.controls.add(new GuiCheckBox("visibleFrame", SubGuiCreativeFrame.translate((String)"gui.creative_frame.visibleFrame"), 90, 88, this.frame.visibleFrame));
        this.controls.add(new GuiCheckBox("bothSides", SubGuiCreativeFrame.translate((String)"gui.creative_frame.bothSides"), 90, 99, this.frame.bothSides));
        this.controls.add(new GuiLabel(SubGuiCreativeFrame.translate((String)"gui.creative_frame.transparency"), 0, 110));
        this.controls.add(new GuiAnalogeSlider("transparency", 80, 112, 109, 5, (double)this.frame.alpha, 0.0, 1.0));
        this.controls.add(new GuiLabel(SubGuiCreativeFrame.translate((String)"gui.creative_frame.brightness"), 0, 122));
        this.controls.add(new GuiAnalogeSlider("brightness", 80, 124, 109, 5, (double)this.frame.brightness, 0.0, 1.0));
        this.controls.add(new GuiLabel(SubGuiCreativeFrame.translate((String)"gui.creative_frame.distance"), 0, 134));
        this.controls.add(new GuiSteppedSlider("renderDistance", 80, 136, 109, 5, this.frame.renderDistance, 5, 1024));
        this.controls.add(new GuiCheckBox("loop", SubGuiCreativeFrame.translate((String)"gui.creative_frame.loop"), 60, 168, this.frame.loop));
        this.controls.add(new GuiLabel(SubGuiCreativeFrame.translate((String)"gui.creative_frame.volume"), 0, 186));
        this.controls.add(new GuiAnalogeSlider("volume", 50, 188, 30, 5, (double)this.frame.volume, 0.0, 1.0));
        this.controls.add(new GuiButton(SubGuiCreativeFrame.translate((String)"gui.creative_frame.reload"), 102, 180){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClicked(int x, int y, int button) {
                Object object = TextureSeeker.LOCK;
                synchronized (object) {
                    if (GuiScreen.func_146272_n()) {
                        TextureCache.reloadAll();
                    } else if (SubGuiCreativeFrame.this.frame.cache != null) {
                        SubGuiCreativeFrame.this.frame.cache.reload();
                    }
                }
            }
        }.setCustomTooltip(new String[]{SubGuiCreativeFrame.translate((String)"gui.creative_frame.reloadtooltip")}));
        this.controls.add(new GuiIconButton("play", 0, 168, 10){

            public void onClicked(int x, int y, int button) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("play", true);
                SubGuiCreativeFrame.this.sendPacketToServer(nbt);
            }
        });
        this.controls.add(new GuiIconButton("pause", 20, 168, 9){

            public void onClicked(int x, int y, int button) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("pause", true);
                SubGuiCreativeFrame.this.sendPacketToServer(nbt);
            }
        });
        this.controls.add(new GuiIconButton("stop", 40, 168, 11){

            public void onClicked(int x, int y, int button) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("stop", true);
                SubGuiCreativeFrame.this.sendPacketToServer(nbt);
            }
        });
    }

    @CustomEventSubscribe
    public void onClicked(GuiControlClickEvent event) {
        if (event.source.is(new String[]{"reX"}) || event.source.is(new String[]{"reY"})) {
            GuiCounterDecimal sizeXField = (GuiCounterDecimal)this.get("sizeX");
            GuiCounterDecimal sizeYField = (GuiCounterDecimal)this.get("sizeY");
            float x = sizeXField.getValue();
            float y = sizeYField.getValue();
            if (this.frame.display != null) {
                if (event.source.is(new String[]{"reX"})) {
                    sizeYField.setValue((float)this.frame.display.getHeight() / ((float)this.frame.display.getWidth() / x));
                } else {
                    sizeXField.setValue((float)this.frame.display.getWidth() / ((float)this.frame.display.getHeight() / y));
                }
            }
        }
    }
}

