/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.display;

import com.creativemd.creativecore.common.utils.mc.TickUtils;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.texture.TextureCache;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.component.CallbackMediaPlayerComponent;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;

public class FrameVideoDisplay
extends FrameDisplay {
    private static HashSet<Runnable> toBeRun = new HashSet();
    private static final String VLC_DOWNLOAD_32 = "https://i.imgur.com/qDIb9iV.png";
    private static final String VLC_DOWNLOAD_64 = "https://i.imgur.com/3EKo7Jx.png";
    private static final int ACCEPTABLE_SYNC_TIME = 1000;
    private static boolean isVLCInstalled = true;
    public int width = 1;
    public int height = 1;
    public CallbackMediaPlayerComponent player;
    public ByteBuffer buffer;
    public int texture;
    private boolean stream = false;
    private float lastSetVolume;
    private AtomicBoolean needsUpdate = new AtomicBoolean(false);
    private boolean first = true;

    public static FrameDisplay createVideoDisplay(String url, float volume, boolean loop) {
        try {
            if (isVLCInstalled) {
                return new FrameVideoDisplay(url, volume, loop);
            }
        }
        catch (Exception | UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
        isVLCInstalled = false;
        String failURL = System.getProperty("sun.arch.data.model").equals("32") ? VLC_DOWNLOAD_32 : VLC_DOWNLOAD_64;
        TextureCache cache = TextureCache.get(failURL);
        if (cache.ready()) {
            return cache.createDisplay(failURL, volume, loop, true);
        }
        return null;
    }

    public FrameVideoDisplay(String url, float volume, boolean loop) {
        this.texture = GlStateManager.func_179146_y();
        this.player = new CallbackMediaPlayerComponent(new MediaPlayerFactory("--quiet"), null, null, false, new RenderCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void display(MediaPlayer mediaPlayer, ByteBuffer[] nativeBuffers, BufferFormat bufferFormat) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    FrameVideoDisplay.this.buffer = nativeBuffers[0];
                    FrameVideoDisplay.this.needsUpdate.set(true);
                }
            }
        }, new BufferFormatCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
                2 var3_3 = this;
                synchronized (var3_3) {
                    FrameVideoDisplay.this.width = sourceWidth;
                    FrameVideoDisplay.this.height = sourceHeight;
                    FrameVideoDisplay.this.first = true;
                }
                return new BufferFormat("RGBA", sourceWidth, sourceHeight, new int[]{sourceWidth * 4}, new int[]{sourceHeight});
            }

            @Override
            public void allocatedBuffers(ByteBuffer[] buffers) {
            }
        }, null);
        this.player.mediaPlayer().submit(() -> {
            this.player.mediaPlayer().audio().setVolume((int)(volume * 100.0f));
            this.lastSetVolume = volume;
            this.player.mediaPlayer().controls().setRepeat(loop);
            this.player.mediaPlayer().media().start(url, new String[0]);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String url, float volume, boolean playing, boolean loop, int tick) {
        FrameVideoDisplay frameVideoDisplay = this;
        synchronized (frameVideoDisplay) {
            if (this.needsUpdate.getAndSet(false)) {
                if (this.buffer != null && this.first) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179144_i((int)this.texture);
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.buffer);
                    GlStateManager.func_179121_F();
                    this.first = false;
                } else {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179144_i((int)this.texture);
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.width, (int)this.height, (int)6408, (int)5121, (ByteBuffer)this.buffer);
                    GlStateManager.func_179121_F();
                }
            }
        }
        if (this.player.mediaPlayer().media().isValid()) {
            boolean realPlaying;
            boolean bl = realPlaying = playing && !Minecraft.func_71410_x().func_147113_T();
            if (volume != this.lastSetVolume) {
                this.player.mediaPlayer().submit(() -> this.player.mediaPlayer().audio().setVolume((int)(volume * 100.0f)));
                this.lastSetVolume = volume;
            }
            if (this.player.mediaPlayer().controls().getRepeat() != loop) {
                this.player.mediaPlayer().submit(() -> this.player.mediaPlayer().controls().setRepeat(loop));
            }
            long tickTime = 50L;
            long newDuration = this.player.mediaPlayer().status().length();
            if (!this.stream && newDuration != -1L && newDuration != 0L && this.player.mediaPlayer().media().info().duration() == 0L) {
                this.stream = true;
            }
            if (this.stream) {
                if (this.player.mediaPlayer().status().isPlaying() != realPlaying) {
                    this.player.mediaPlayer().submit(() -> this.player.mediaPlayer().controls().setPause(!realPlaying));
                }
            } else if (this.player.mediaPlayer().status().length() > 0L) {
                long time = (long)tick * tickTime + (realPlaying ? (long)(TickUtils.getPartialTickTime() * (float)tickTime) : 0L);
                if (this.player.mediaPlayer().status().isSeekable() && time > this.player.mediaPlayer().status().time() && loop) {
                    time %= this.player.mediaPlayer().status().length();
                }
                if (Math.abs(time - this.player.mediaPlayer().status().time()) > 1000L) {
                    this.player.mediaPlayer().submit(() -> {
                        long newTime = (long)tick * tickTime + (realPlaying ? (long)(TickUtils.getPartialTickTime() * (float)tickTime) : 0L);
                        if (this.player.mediaPlayer().status().isSeekable() && newTime > this.player.mediaPlayer().status().length() && loop) {
                            newTime %= this.player.mediaPlayer().status().length();
                        }
                        this.player.mediaPlayer().controls().setTime(newTime);
                        if (this.player.mediaPlayer().status().isPlaying() != realPlaying) {
                            this.player.mediaPlayer().controls().setPause(!realPlaying);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FrameVideoDisplay.this.player.release();
                HashSet hashSet = toBeRun;
                synchronized (hashSet) {
                    toBeRun.remove(this);
                }
            }
        };
        HashSet<Runnable> hashSet = toBeRun;
        synchronized (hashSet) {
            toBeRun.add(run);
        }
        this.player.mediaPlayer().submit(run);
    }

    @Override
    public int texture() {
        return this.texture;
    }

    @Override
    public void pause(String url, float volume, boolean playing, boolean loop, int tick) {
        this.player.mediaPlayer().submit(() -> {
            this.player.mediaPlayer().controls().setTime(tick * 50);
            this.player.mediaPlayer().controls().pause();
        });
    }

    @Override
    public void resume(String url, float volume, boolean playing, boolean loop, int tick) {
        this.player.mediaPlayer().submit(() -> {
            this.player.mediaPlayer().controls().setTime(tick * 50);
            this.player.mediaPlayer().controls().play();
        });
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

