/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes;

import com.creativemd.creativecore.common.config.api.CreativeConfig;
import com.creativemd.creativecore.common.config.sync.ConfigSynchronization;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.GameType;
import net.minecraft.world.World;

public class LittleFramesConfig {
    @CreativeConfig
    public double sizeLimitation = 1000.0;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public int maxRenderDistance = 10000;
    @CreativeConfig
    public boolean onlyOps = false;
    @CreativeConfig
    public boolean disableAdventure = true;
    @CreativeConfig
    public boolean onlyCreative = false;
    @CreativeConfig
    public boolean whitelistEnabled = false;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean useVLC = true;
    @CreativeConfig
    public List<String> whitelist = Arrays.asList("imgur.com", "gyazo.com", "prntscr.com", "tinypic.com", "puu.sh", "pinimg.com", "photobucket.com", "staticflickr.com", "flic.kr", "tenor.co", "gfycat.com", "giphy.com", "gph.is", "gifbin.com", "i.redd.it", "media.tumblr.com", "twimg.com", "discordapp.com", "images.discordapp.net", "githubusercontent.com", "googleusercontent.com", "googleapis.com", "wikimedia.org", "ytimg.com");

    public boolean canUse(EntityPlayer player, String url) {
        return this.canUse(player, url, false);
    }

    public boolean canUse(EntityPlayer player, String url, boolean ignoreToggle) {
        World world = player.field_70170_p;
        if (!world.field_72995_K && (world.func_73046_m().func_71264_H() || player.func_70003_b(world.func_73046_m().func_110455_j(), ""))) {
            return true;
        }
        if (this.whitelistEnabled || ignoreToggle) {
            try {
                return this.isDomainWhitelisted(new URI(url.toLowerCase(Locale.ROOT)).getHost());
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return true;
    }

    public boolean isDomainWhitelisted(String domain) {
        if (domain != null) {
            for (String url : this.whitelist) {
                String formattedUrl = url.trim().toLowerCase(Locale.ROOT);
                if (!domain.endsWith("." + formattedUrl) && !domain.equals(formattedUrl)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canInteract(EntityPlayer player, World world) {
        boolean isOperator;
        if (this.disableAdventure && ((EntityPlayerMP)player).field_71134_c.func_73081_b() == GameType.ADVENTURE) {
            return false;
        }
        if (this.onlyCreative && !player.func_184812_l_()) {
            return false;
        }
        boolean bl = isOperator = world.func_73046_m().func_71264_H() || player.func_70003_b(world.func_73046_m().func_110455_j(), "");
        if (this.onlyOps) {
            return isOperator;
        }
        return isOperator || !this.disableAdventure || player.field_71075_bZ.field_75099_e;
    }
}

