/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.restrictions;

import jeresources.api.restrictions.Type;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class DimensionRestriction {
    public static final DimensionRestriction OVERWORLD = new DimensionRestriction(0);
    public static final DimensionRestriction NETHER = new DimensionRestriction(-1);
    public static final DimensionRestriction END = new DimensionRestriction(1);
    public static final DimensionRestriction NONE = new DimensionRestriction();
    private Type type;
    private String name;

    private DimensionRestriction() {
        this.type = Type.NONE;
    }

    public DimensionRestriction(DimensionType type) {
        this(Type.WHITELIST, type.func_186065_b());
    }

    public DimensionRestriction(Type type, DimensionType dimensionType) {
        this(type, dimensionType.func_186065_b());
    }

    public DimensionRestriction(int dim) {
        this(DimensionManager.getProviderType((int)dim));
    }

    public DimensionRestriction(Type type, int dim) {
        this(type, DimensionManager.getProviderType((int)dim));
    }

    public DimensionRestriction(String name) {
        this(Type.WHITELIST, name);
    }

    public DimensionRestriction(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimensionRestriction) {
            DimensionRestriction other = (DimensionRestriction)obj;
            return this.type == other.type && this.name.equals(other.name);
        }
        return false;
    }

    public String toString() {
        return "Dimension: " + (this.type == Type.NONE ? "None" : this.type.name() + " " + this.name);
    }

    public int hashCode() {
        return this.type == Type.NONE ? super.hashCode() : this.type.hashCode() ^ this.name.hashCode();
    }

    public String getDimensionName() {
        return this.type == Type.NONE ? "all" : this.name;
    }
}

