/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.WTooltip;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class WIcon
extends WTooltip {
    public int xPos;
    public int yPos;
    public int xSize;
    public int ySize;
    public Resource normal;
    public Resource focused;

    public WIcon(int xPos, int yPos, int xSize, int ySize, Resource.ResourceGroup res) {
        this(xPos, yPos, xSize, ySize, res.normal, res.focused, null);
    }

    public WIcon(int xPos, int yPos, int xSize, int ySize, Resource.ResourceGroup res, String name) {
        this(xPos, yPos, xSize, ySize, res.normal, res.focused, name);
    }

    private WIcon(int xPos, int yPos, int xSize, int ySize, Resource normal, Resource focused, @Nullable String name) {
        super(name);
        this.xPos = xPos;
        this.yPos = yPos;
        this.xSize = xSize;
        this.ySize = ySize;
        this.normal = normal;
        this.focused = focused;
    }

    @Override
    public void onDraw(JecaGui gui, int xMouse, int yMouse) {
        super.onDraw(gui, xMouse, yMouse);
        gui.drawRectangle(this.xPos, this.yPos, this.xSize, this.ySize, -6184543);
        Resource r = this.mouseIn(xMouse, yMouse) ? this.focused : this.normal;
        gui.drawResource(r, (this.xSize - r.getXSize()) / 2 + this.xPos, (this.ySize - r.getYSize()) / 2 + this.yPos);
    }

    @Override
    public boolean mouseIn(int xMouse, int yMouse) {
        return JecaGui.mouseIn(this.xPos + (this.xSize - this.normal.getXSize()) / 2, this.yPos + (this.ySize - this.normal.getYSize()) / 2, this.normal.getXSize(), this.normal.getYSize(), xMouse, yMouse);
    }
}

