/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.JAOPCA;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.IItemRequest;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.ItemEntryGroup;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.block.BlockProperties;
import thelm.jaopca.api.block.IBlockFluidWithProperty;
import thelm.jaopca.api.block.IBlockWithProperty;
import thelm.jaopca.api.fluid.FluidProperties;
import thelm.jaopca.api.fluid.IFluidWithProperty;
import thelm.jaopca.api.item.IItemBlockFluidWithProperty;
import thelm.jaopca.api.item.IItemBlockWithProperty;
import thelm.jaopca.api.item.IItemWithProperty;
import thelm.jaopca.api.item.ItemProperties;
import thelm.jaopca.api.utils.Utils;
import thelm.jaopca.ore.OreFinder;
import thelm.jaopca.utils.JAOPCAConfig;

public class RegistryCore {
    public static final ArrayList<IItemRequest> ITEM_REQUEST_LIST = Lists.newArrayList();
    private static boolean initRemaps = true;
    private static final List<Pair<String, String>> REMAPS = Lists.newArrayList();

    public static void preInit(FMLPreInitializationEvent event) {
        JAOPCAConfig.init(new File(event.getModConfigurationDirectory(), "JAOPCA.cfg"));
    }

    public static void preInit1() {
        RegistryCore.initPrefixBlacklist();
        OreFinder.findOres();
        JAOPCAConfig.preInitModulewiseConfigs();
        RegistryCore.initItemEntries();
        RegistryCore.initBlacklists();
        RegistryCore.initToOreMaps();
        JAOPCAConfig.initModulewiseConfigs();
        RegistryCore.registerEntries();
        RegistryCore.registerPreInit();
    }

    public static void init() {
        RegistryCore.registerInit();
    }

    public static void postInit() {
        RegistryCore.registerPostInit();
    }

    public static void registerBuiltInModules() {
        try {
            Class<?> moduleClass = Class.forName("thelm.jaopca.modules.RegistryModules");
            Method initMethod = moduleClass.getMethod("preInit", new Class[0]);
            initMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            JAOPCAApi.LOGGER.warn("Module registry not found! Will continue loading.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initPrefixBlacklist() {
        for (ModuleBase module : JAOPCAApi.MODULE_LIST) {
            OreFinder.PREFIX_BLACKLIST.addAll(module.addToPrefixBlacklist());
        }
    }

    private static void initItemEntries() {
        for (ModuleBase module : JAOPCAApi.MODULE_LIST) {
            List<? extends IItemRequest> requests = module.getItemRequests();
            for (IItemRequest iItemRequest : requests) {
                if (iItemRequest instanceof ItemEntry) {
                    ItemEntry entry = (ItemEntry)iItemRequest;
                    if (JAOPCAApi.NAME_TO_ITEM_ENTRY_MAP.containsKey(entry.name)) {
                        JAOPCAApi.NAME_TO_ITEM_ENTRY_MAP.get((Object)entry.name).blacklist.addAll(entry.blacklist);
                        continue;
                    }
                    JAOPCAApi.NAME_TO_ITEM_ENTRY_MAP.put(entry.name, entry);
                    JAOPCAApi.TYPE_TO_ITEM_ENTRY_MAP.put((Object)entry.type, (Object)entry);
                    JAOPCAApi.ITEM_ENTRY_LIST.add(entry);
                    JAOPCAApi.NAME_TO_ITEM_ENTRY_MAP.get((Object)entry.name).moduleList.add(module);
                } else if (iItemRequest instanceof ItemEntryGroup) {
                    for (ItemEntry entry : ((ItemEntryGroup)iItemRequest).entryList) {
                        if (JAOPCAApi.NAME_TO_ITEM_ENTRY_MAP.containsKey(entry.name)) {
                            JAOPCAApi.NAME_TO_ITEM_ENTRY_MAP.get((Object)entry.name).blacklist.addAll(entry.blacklist);
                            continue;
                        }
                        JAOPCAApi.NAME_TO_ITEM_ENTRY_MAP.put(entry.name, entry);
                        JAOPCAApi.TYPE_TO_ITEM_ENTRY_MAP.put((Object)entry.type, (Object)entry);
                        JAOPCAApi.ITEM_ENTRY_LIST.add(entry);
                        JAOPCAApi.NAME_TO_ITEM_ENTRY_MAP.get((Object)entry.name).moduleList.add(module);
                    }
                }
                ITEM_REQUEST_LIST.add(iItemRequest);
            }
        }
    }

    private static void initBlacklists() {
        for (IOreEntry ore : JAOPCAApi.ORE_ENTRY_LIST) {
            for (ModuleBase module : JAOPCAApi.MODULE_LIST) {
                if (!ore.getModuleBlacklist().stream().anyMatch(name -> module.getDependencies().contains(name))) continue;
                ore.getModuleBlacklist().add(module.getName());
            }
            for (IItemRequest request : ITEM_REQUEST_LIST) {
                if (request instanceof ItemEntry) {
                    ItemEntry entry = (ItemEntry)request;
                    if (!entry.oreTypes.contains((Object)ore.getOreType())) continue;
                    if (entry.type.checker.test(entry, ore)) {
                        entry.blacklist.add(ore.getOreName());
                    }
                    for (String moduleName : ore.getModuleBlacklist()) {
                        for (ModuleBase module : entry.moduleList) {
                            if (!module.getDependencies().contains(moduleName)) continue;
                            entry.blacklist.add(ore.getOreName());
                        }
                        if (!entry.moduleList.contains(JAOPCAApi.NAME_TO_MODULE_MAP.get(moduleName))) continue;
                        entry.blacklist.add(ore.getOreName());
                    }
                    continue;
                }
                if (!(request instanceof ItemEntryGroup)) continue;
                ItemEntryGroup entryGroup = (ItemEntryGroup)request;
                boolean flag = true;
                for (ItemEntry entry : entryGroup.entryList) {
                    if (!entry.oreTypes.contains((Object)ore.getOreType())) continue;
                    flag &= entry.type.checker.test(entry, ore);
                    for (String moduleName : ore.getModuleBlacklist()) {
                        for (ModuleBase module : entry.moduleList) {
                            if (!module.getDependencies().contains(moduleName)) continue;
                            entry.blacklist.add(ore.getOreName());
                        }
                        if (!entry.moduleList.contains(JAOPCAApi.NAME_TO_MODULE_MAP.get(moduleName))) continue;
                        entry.blacklist.add(ore.getOreName());
                    }
                }
                if (!flag) continue;
                for (ItemEntry entry : entryGroup.entryList) {
                    entry.blacklist.add(ore.getOreName());
                }
            }
        }
    }

    public static boolean checkEntry(ItemEntry entry, IOreEntry ore) {
        if (entry.type == EnumEntryType.BLOCK || entry.type == EnumEntryType.ITEM) {
            return Utils.doesOreNameExist(entry.prefix + ore.getOreName());
        }
        if (entry.type == EnumEntryType.FLUID) {
            return entry.prefix.isEmpty() && FluidRegistry.isFluidRegistered((String)Utils.to_under_score(ore.getOreName())) || FluidRegistry.isFluidRegistered((String)(entry.prefix + '_' + ore.getOreName()));
        }
        if (entry.type == EnumEntryType.CUSTOM) {
            boolean flag = true;
            for (ModuleBase module : entry.moduleList) {
                flag &= module.blacklistCustom(entry, ore);
            }
            return flag;
        }
        throw new IllegalArgumentException("Unsupported entry type: " + (Object)((Object)entry.type));
    }

    private static void initToOreMaps() {
        LinkedHashSet oreSet;
        for (ItemEntry entry : JAOPCAApi.ITEM_ENTRY_LIST) {
            oreSet = Sets.newLinkedHashSet();
            JAOPCAApi.ORE_ENTRY_LIST.stream().filter(oreEntry -> entry.oreTypes.contains((Object)oreEntry.getOreType()) && !entry.blacklist.contains(oreEntry.getOreName())).forEach(oreEntry -> oreSet.add(oreEntry));
            JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.putAll((Object)entry.name, (Iterable)oreSet);
        }
        for (ModuleBase module : JAOPCAApi.MODULE_LIST) {
            oreSet = Sets.newLinkedHashSet();
            JAOPCAApi.ORE_ENTRY_LIST.stream().filter(oreEntry -> module.getOreTypes().contains((Object)oreEntry.getOreType()) && !module.getOreBlacklist().contains(oreEntry.getOreName()) && !oreEntry.getModuleBlacklist().contains(module.getName())).forEach(oreEntry -> oreSet.add(oreEntry));
            JAOPCAApi.MODULE_TO_ORES_MAP.putAll((Object)module, (Iterable)oreSet);
        }
    }

    private static void registerEntries() {
        for (EnumEntryType type : EnumEntryType.values()) {
            for (ItemEntry entry : JAOPCAApi.TYPE_TO_ITEM_ENTRY_MAP.get((Object)type)) {
                type.registerer.accept(entry);
            }
        }
    }

    private static void registerBlocks(ItemEntry entry) {
        BlockProperties ppt = (BlockProperties)entry.properties;
        for (IOreEntry ore : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)entry.name)) {
            try {
                IBlockWithProperty block = ppt.blockClass.getConstructor(Material.class, MapColor.class, ItemEntry.class, IOreEntry.class).newInstance(ppt.material, ppt.mapColor, entry, ore);
                block.setHardness(ppt.hardnessFunc.applyAsFloat(ore)).setResistance(ppt.resisFunc.applyAsFloat(ore)).setLightOpacity(ppt.lgtOpacFunc.applyAsInt(ore)).setLightLevel(ppt.lgtValFunc.applyAsFloat(ore)).setSlipperiness(ppt.slippyFunc.applyAsFloat(ore)).setSoundType(ppt.soundType).setBeaconBase(ppt.beaconBase).setBoundingBox(ppt.boundingBox).setHarvestTool(ppt.harvestTool).setHarvestLevel(ppt.harvestLevel).setFull(ppt.full).setOpaque(ppt.opaque).setBlockLayer(ppt.layer).setFlammability(ppt.flammabFunc.applyAsInt(ore)).setFireSpreadSpeed(ppt.fireSpdFunc.applyAsInt(ore)).setFireSource(ppt.fireSource).setFallable(ppt.fallable);
                ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)((Block)block));
                IItemBlockWithProperty itemblock = ppt.itemBlockClass.getConstructor(IBlockWithProperty.class).newInstance(block);
                itemblock.setMaxStackSize(ppt.maxStkSize).setRarity(ppt.rarity);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)((ItemBlock)itemblock));
                JAOPCA.proxy.handleBlockRegister((Block)block, (ItemBlock)itemblock);
                for (int i = 0; i <= block.getMaxMeta(); ++i) {
                    if (!block.hasMeta(i)) continue;
                    OreDictionary.registerOre((String)(block.getPrefix(i) + ore.getOreName()), (ItemStack)new ItemStack((Block)block, 1, i));
                    for (String synonym : ore.getOreNameSynonyms()) {
                        OreDictionary.registerOre((String)(block.getPrefix(i) + synonym), (ItemStack)new ItemStack((Block)block, 1, i));
                    }
                }
                JAOPCAApi.BLOCKS_TABLE.put((Object)entry.name, (Object)ore.getOreName(), (Object)((Block)block));
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("maximum id range exceeded")) {
                    throw e;
                }
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void registerItems(ItemEntry entry) {
        ItemProperties ppt = (ItemProperties)entry.properties;
        for (IOreEntry ore : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)entry.name)) {
            try {
                IItemWithProperty item = ppt.itemClass.getConstructor(ItemEntry.class, IOreEntry.class).newInstance(entry, ore);
                item.setMaxStackSize(ppt.maxStkSize).setFull3D(ppt.full3D).setRarity(ppt.rarity).setHasEffect(ppt.hasEffect.test(ore));
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)((Item)item));
                JAOPCA.proxy.handleItemRegister((Item)item);
                for (int i = 0; i <= item.getMaxMeta(); ++i) {
                    if (!item.hasMeta(i)) continue;
                    OreDictionary.registerOre((String)(item.getPrefix(i) + ore.getOreName()), (ItemStack)new ItemStack((Item)item, 1, i));
                    for (String synonym : ore.getOreNameSynonyms()) {
                        OreDictionary.registerOre((String)(item.getPrefix(i) + synonym), (ItemStack)new ItemStack((Item)item, 1, i));
                    }
                }
                JAOPCAApi.ITEMS_TABLE.put((Object)entry.name, (Object)ore.getOreName(), (Object)((Item)item));
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("maximum id range exceeded")) {
                    throw e;
                }
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void registerFluids(ItemEntry entry) {
        FluidProperties ppt = (FluidProperties)entry.properties;
        if (!ppt.hasBlock) {
            JAOPCAApi.TEXTURES.add(new ResourceLocation("jaopca:fluids/" + entry.name + "_still"));
            JAOPCAApi.TEXTURES.add(new ResourceLocation("jaopca:fluids/" + entry.name + "_flowing"));
        }
        for (IOreEntry ore : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)entry.name)) {
            try {
                IFluidWithProperty fluid = ppt.fluidClass.getConstructor(ItemEntry.class, IOreEntry.class).newInstance(entry, ore);
                fluid.setLuminosity(ppt.luminosFunc.applyAsInt(ore)).setTemperature(ppt.tempFunc.applyAsInt(ore)).setDensity(ppt.densityFunc.applyAsInt(ore)).setViscosity(ppt.viscosFunc.applyAsInt(ore)).setGaseous(ppt.gaseous.test(ore)).setRarity(ppt.rarity).setFillSound(ppt.fillSound).setEmptySound(ppt.emptySound).setOpacity(ppt.opacityFunc.applyAsInt(ore));
                FluidRegistry.registerFluid((Fluid)((Fluid)fluid));
                FluidRegistry.addBucketForFluid((Fluid)((Fluid)fluid));
                if (ppt.hasBlock) {
                    IBlockFluidWithProperty blockfluid = ppt.blockFluidClass.getConstructor(IFluidWithProperty.class, Material.class).newInstance(fluid, ppt.material);
                    blockfluid.setQuantaPerBlock(ppt.quantaFunc.applyAsInt(ore));
                    ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)((Block)blockfluid));
                    IItemBlockFluidWithProperty itemblockfluid = ppt.itemBlockFluidClass.getConstructor(IBlockFluidWithProperty.class).newInstance(blockfluid);
                    ForgeRegistries.ITEMS.register((IForgeRegistryEntry)((ItemBlock)itemblockfluid));
                    JAOPCA.proxy.handleBlockRegister((Block)blockfluid, (ItemBlock)itemblockfluid);
                }
                JAOPCAApi.FLUIDS_TABLE.put((Object)entry.name, (Object)ore.getOreName(), (Object)((Fluid)fluid));
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("maximum id range exceeded")) {
                    throw e;
                }
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void registerCustoms(ItemEntry entry) {
        ArrayList oreList = Lists.newArrayList((Iterable)JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)entry.name));
        for (ModuleBase module : entry.moduleList) {
            module.registerCustom(entry, oreList);
        }
    }

    private static void registerPreInit() {
        for (ModuleBase module : JAOPCAApi.MODULE_LIST) {
            JAOPCAApi.LOGGER.debug("PreInit-ing module " + module.getName());
            module.preInit();
        }
    }

    private static void registerInit() {
        for (ModuleBase module : JAOPCAApi.MODULE_LIST) {
            JAOPCAApi.LOGGER.debug("Init-ing module " + module.getName());
            module.init();
        }
    }

    private static void registerPostInit() {
        for (ModuleBase module : JAOPCAApi.MODULE_LIST) {
            JAOPCAApi.LOGGER.debug("PostInit-ing module " + module.getName());
            module.postInit();
        }
    }

    public static <T extends IForgeRegistryEntry<T>> void onMissingMappings(List<RegistryEvent.MissingMappings.Mapping<T>> missingMappings) {
        if (initRemaps) {
            for (ModuleBase moduleBase : JAOPCAApi.MODULE_LIST) {
                REMAPS.addAll(moduleBase.remaps());
            }
            initRemaps = false;
        }
        block1: for (RegistryEvent.MissingMappings.Mapping mapping : missingMappings) {
            String[] names = mapping.key.func_110623_a().split("_");
            if (names.length != 2) continue;
            for (Pair<String, String> pair : REMAPS) {
                if (!names[1].startsWith((String)pair.getLeft())) continue;
                String oreName = names[1].substring(((String)pair.getLeft()).length());
                if (!JAOPCAApi.ORE_ENTRY_LIST.stream().anyMatch(entry -> entry.getOreName().equalsIgnoreCase(oreName))) continue;
                ResourceLocation remap = new ResourceLocation(mapping.key.func_110624_b(), names[0] + '_' + (String)pair.getRight() + oreName);
                IForgeRegistry reg = GameRegistry.findRegistry((Class)mapping.registry.getRegistrySuperType());
                if (!reg.containsKey(remap)) continue block1;
                mapping.remap(reg.getValue(remap));
                continue block1;
            }
        }
    }
}

