/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.math;

import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.util.IvStreams;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class Transforms {
    public static Stream<AxisAlignedTransform2D> transformStream(IntPredicate rotate, IntPredicate mirror) {
        return IvStreams.flatMapToObj(Transforms.rotationStream(rotate), r -> Transforms.mirrorStream(mirror).mapToObj(m -> AxisAlignedTransform2D.from(r, m != 0)));
    }

    public static Stream<AxisAlignedTransform2D> transformStream(boolean rotate, boolean mirror) {
        return IvStreams.flatMapToObj(Transforms.rotationStream(rotate), r -> Transforms.mirrorStream(mirror).mapToObj(m -> AxisAlignedTransform2D.from(r, m != 0)));
    }

    @Nonnull
    protected static IntStream mirrorStream(boolean mirror) {
        int[] nArray;
        if (mirror) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            nArray = new int[1];
        }
        return IntStream.of(nArray);
    }

    @Nonnull
    protected static IntStream rotationStream(boolean rotate) {
        return IntStream.of(Transforms.rotations(rotate));
    }

    @Nonnull
    protected static IntStream mirrorStream(IntPredicate predicate) {
        return IntStream.of(0, 1).filter(predicate);
    }

    @Nonnull
    protected static IntStream rotationStream(IntPredicate predicate) {
        return IntStream.of(Transforms.rotations()).filter(predicate);
    }

    protected static int[] rotations(boolean rotate) {
        return rotate ? Transforms.rotations() : new int[1];
    }

    public static int[] rotations() {
        return new int[]{0, 1, 2, 3};
    }

    public static boolean[] mirrors(boolean mirror) {
        return mirror ? Transforms.mirrors() : new boolean[1];
    }

    public static boolean[] mirrors() {
        return new boolean[]{true, false};
    }

    public static AxisAlignedTransform2D apply(AxisAlignedTransform2D first, AxisAlignedTransform2D second) {
        return AxisAlignedTransform2D.from(first.getRotation() * (second.isMirrorX() ? -1 : 1) + second.getRotation(), first.isMirrorX() != second.isMirrorX());
    }
}

