/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.enums;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import twistedgate.immersiveposts.IPOStuff;
import twistedgate.immersiveposts.common.blocks.BlockPost;
import twistedgate.immersiveposts.enums.EnumPostType;

public enum EnumPostMaterial implements IStringSerializable
{
    WOOD("woodpost", (Block)IEContent.blockWoodenDecoration, BlockTypes_WoodenDecoration.FENCE.getMeta(), true, true),
    ALUMINIUM("aluminiumpost", (Block)IEContent.blockMetalDecoration1, BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta(), true, true),
    STEEL("steelpost", (Block)IEContent.blockMetalDecoration1, BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta(), true, true),
    NETHERBRICK("netherpost", Blocks.field_150386_bk, true, false),
    IRON("ironpost", (Block)IPOStuff.ironFence, true, true),
    GOLD("goldpost", (Block)IPOStuff.goldFence, true, true),
    COPPER("copperpost", (Block)IPOStuff.copperFence, true, true),
    LEAD("leadpost", (Block)IPOStuff.leadFence, true, true),
    SILVER("silverpost", (Block)IPOStuff.silverFence, true, true),
    NICKEL("nickelpost", (Block)IPOStuff.nickelFence, true, true),
    CONSTANTAN("constantanpost", (Block)IPOStuff.constantanFence, true, true),
    ELECTRUM("electrumpost", (Block)IPOStuff.electrumFence, true, true),
    URANIUM("uraniumpost", (Block)IPOStuff.uraniumFence, true, true),
    CONCRETE("concretepost", (Block)IEContent.blockStoneDecorationSlabs, BlockTypes_StoneDecoration.CONCRETE.getMeta(), false, false),
    CONCRETE_LEADED("leadedconcretepost", (Block)IEContent.blockStoneDecorationSlabs, BlockTypes_StoneDecoration.CONCRETE_LEADED.getMeta(), false, false);

    private final String name;
    private final Block block;
    private final int meta;
    private final boolean isFence;
    private final boolean needsMetalPress;

    private EnumPostMaterial(String name, Block block, boolean isFence, boolean needsMetalPress) {
        this(name, block, 0, isFence, needsMetalPress);
    }

    private EnumPostMaterial(String name, Block block, int metadata, boolean isFence, boolean needsMetalPress) {
        this.name = name;
        this.block = block;
        this.meta = metadata;
        this.isFence = isFence;
        this.needsMetalPress = needsMetalPress;
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.block, 1, this.meta);
    }

    public Block getBlock() {
        return this.block;
    }

    public int getBlockMeta() {
        return this.meta;
    }

    public boolean isFence() {
        return this.isFence;
    }

    public boolean needsMetalPress() {
        return this.needsMetalPress;
    }

    public String func_176610_l() {
        return this.name;
    }

    public static IBlockState getPostStateFrom(ItemStack stack) {
        IBlockState state = null;
        switch (EnumPostMaterial.getFrom(stack)) {
            case ALUMINIUM: {
                state = IPOStuff.aluminiumPost.func_176223_P();
                break;
            }
            case CONSTANTAN: {
                state = IPOStuff.constantanPost.func_176223_P();
                break;
            }
            case COPPER: {
                state = IPOStuff.copperPost.func_176223_P();
                break;
            }
            case ELECTRUM: {
                state = IPOStuff.electrumPost.func_176223_P();
                break;
            }
            case GOLD: {
                state = IPOStuff.goldPost.func_176223_P();
                break;
            }
            case IRON: {
                state = IPOStuff.ironPost.func_176223_P();
                break;
            }
            case LEAD: {
                state = IPOStuff.leadPost.func_176223_P();
                break;
            }
            case NETHERBRICK: {
                state = IPOStuff.netherPost.func_176223_P();
                break;
            }
            case NICKEL: {
                state = IPOStuff.nickelPost.func_176223_P();
                break;
            }
            case SILVER: {
                state = IPOStuff.silverPost.func_176223_P();
                break;
            }
            case STEEL: {
                state = IPOStuff.steelPost.func_176223_P();
                break;
            }
            case URANIUM: {
                state = IPOStuff.uraniumPost.func_176223_P();
                break;
            }
            case WOOD: {
                state = IPOStuff.woodPost.func_176223_P();
                break;
            }
            case CONCRETE: {
                state = IPOStuff.concretePost.func_176223_P();
                break;
            }
            case CONCRETE_LEADED: {
                state = IPOStuff.leadedConcretePost.func_176223_P();
            }
        }
        return state != null ? state.func_177226_a(BlockPost.TYPE, (Comparable)((Object)EnumPostType.POST_TOP)) : null;
    }

    public static EnumPostMaterial getFrom(ItemStack stack) {
        for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            if (!stack.func_77969_a(mat.getItemStack())) continue;
            return mat;
        }
        return null;
    }

    public static boolean isFenceItem(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            if (!stack.func_77969_a(mat.getItemStack())) continue;
            return true;
        }
        return false;
    }
}

