/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;

public class DieselHandler {
    static final HashMap<String, Integer> dieselGenBurnTime = new HashMap();
    static final Set<Fluid> drillFuel = new HashSet<Fluid>();

    public static void registerFuel(Fluid fuel, int time) {
        if (fuel != null) {
            dieselGenBurnTime.put(fuel.getName(), time);
        }
    }

    public static int getBurnTime(Fluid fuel) {
        String s;
        if (fuel != null && dieselGenBurnTime.containsKey(s = fuel.getName())) {
            return dieselGenBurnTime.get(s);
        }
        return 0;
    }

    public static boolean isValidFuel(Fluid fuel) {
        if (fuel != null) {
            return dieselGenBurnTime.containsKey(fuel.getName());
        }
        return false;
    }

    public static HashMap<String, Integer> getFuelValues() {
        return dieselGenBurnTime;
    }

    public static Map<String, Integer> getFuelValuesSorted(boolean inverse) {
        return ApiUtils.sortMap(dieselGenBurnTime, inverse);
    }

    public static void registerDrillFuel(Fluid fuel) {
        if (fuel != null) {
            drillFuel.add(fuel);
        }
    }

    public static boolean isValidDrillFuel(Fluid fuel) {
        return fuel != null && drillFuel.contains(fuel);
    }

    public static void removeFuel(Fluid fuel) {
        if (fuel != null) {
            dieselGenBurnTime.remove(fuel.getName());
        }
    }

    public static void removeDrillFuel(Fluid fuel) {
        drillFuel.remove(fuel);
    }
}

