/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.immersivecables.tileentity.rs;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import de.sanandrew.mods.immersivecables.item.ICoilConnectable;
import de.sanandrew.mods.immersivecables.util.ImmersiveCables;
import de.sanandrew.mods.immersivecables.wire.Wires;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileRefinedConnectable
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.IAdvancedSelectionBounds,
ICoilConnectable,
INetworkNodeProxy<NetworkNodeRefinedConnectable> {
    List<AxisAlignedBB> cachedSelectionBounds;
    private NetworkNodeRefinedConnectable node;

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer entityPlayer, RayTraceResult ray, ArrayList<AxisAlignedBB> arrayList) {
        return box.func_72314_b(0.002, 0.002, 0.002).func_72318_a(ray.field_72307_f);
    }

    public float[] getBlockBounds() {
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getNode().getNetwork() != null) {
            this.getNode().getNetwork().getNodeGraph().rebuild();
        }
    }

    protected EnumFacing getFacing() {
        return !this.field_145850_b.func_175623_d(this.field_174879_c) ? (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockDirectional.field_176387_N) : EnumFacing.UP;
    }

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        super.connectCable(cableType, target, other);
        if (other instanceof TileRefinedConnectable) {
            TileRefinedConnectable refinedTile = (TileRefinedConnectable)other;
            if (this.getNode().getNetwork() != null && refinedTile.getNode().getNetwork() == null) {
                this.getNode().getNetwork().getNodeGraph().rebuild();
            }
        }
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        super.removeCable(connection);
        if (this.getNode().getNetwork() != null) {
            this.getNode().getNetwork().getNodeGraph().rebuild();
        }
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    @Override
    public boolean canConnectCable(TileEntity targetEntity, WireType type) {
        if (targetEntity instanceof INetworkNodeProxy) {
            INetwork tgtController = ((INetworkNodeProxy)targetEntity).getNode().getNetwork();
            return tgtController == null || this.getNode().getNetwork() == null || tgtController == this.getNode().getNetwork();
        }
        return false;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        String category = cableType.getCategory();
        return Wires.REFINED.category.equals(category) && (this.limitType == null || this.isRelay() && WireApi.canMix((WireType)this.limitType, (WireType)cableType));
    }

    @Nonnull
    public NetworkNodeRefinedConnectable getNode() {
        if (this.field_145850_b.field_72995_K) {
            if (this.node == null) {
                this.node = new NetworkNodeRefinedConnectable();
            }
            return this.node;
        }
        INetworkNodeManager mgr = API.instance().getNetworkNodeManager(this.field_145850_b);
        Object node = mgr.getNode(this.field_174879_c);
        if (node == null || !node.getId().equals("ic_refined_connectable")) {
            node = new NetworkNodeRefinedConnectable();
            mgr.setNode(this.field_174879_c, node);
            mgr.markForSaving();
        }
        return (NetworkNodeRefinedConnectable)((Object)node);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY) {
            return (T)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public abstract int getEnergyUsage();

    public abstract ItemStack getItemStack();

    public abstract void onConnectionChanged(INetwork var1);

    public abstract void visitNodes(INetworkNodeVisitor.Operator var1);

    public abstract boolean canConduct(@Nullable EnumFacing var1);

    public final class NetworkNodeRefinedConnectable
    extends NetworkNode {
        public static final String ID = "ic_refined_connectable";

        NetworkNodeRefinedConnectable() {
            super(TileRefinedConnectable.this.field_145850_b, TileRefinedConnectable.this.field_174879_c);
        }

        public void visit(INetworkNodeVisitor.Operator operator) {
            super.visit(operator);
            TileRefinedConnectable.this.visitNodes(operator);
            Set connections = ImmersiveNetHandler.INSTANCE.getConnections(TileRefinedConnectable.this.field_145850_b, Utils.toCC((Object)TileRefinedConnectable.this));
            if (connections != null) {
                for (ImmersiveNetHandler.Connection connection : connections) {
                    TileEntity connTile;
                    BlockPos opposite = connection.end;
                    if (opposite.equals((Object)Utils.toCC((Object)TileRefinedConnectable.this)) || !ImmersiveCables.isChunkLoaded(TileRefinedConnectable.this.field_145850_b.func_72863_F(), opposite.func_177958_n() >> 4, opposite.func_177952_p() >> 4) || !((connTile = TileRefinedConnectable.this.field_145850_b.func_175625_s(opposite)) instanceof TileRefinedConnectable)) continue;
                    TileRefinedConnectable connectable = (TileRefinedConnectable)connTile;
                    operator.apply(TileRefinedConnectable.this.field_145850_b, opposite, connectable.getFacing().func_176734_d());
                }
            }
        }

        public int getEnergyUsage() {
            return TileRefinedConnectable.this.getEnergyUsage();
        }

        @Nonnull
        public ItemStack getItemStack() {
            return TileRefinedConnectable.this.getItemStack();
        }

        public boolean canConduct(@Nullable EnumFacing direction) {
            return TileRefinedConnectable.this.canConduct(direction);
        }

        public void onConnected(INetwork iNetworkMaster) {
            super.onConnected(iNetworkMaster);
            TileRefinedConnectable.this.onConnectionChanged(iNetworkMaster);
        }

        public void onDisconnected(INetwork iNetworkMaster) {
            super.onDisconnected(iNetworkMaster);
            TileRefinedConnectable.this.onConnectionChanged(iNetworkMaster);
        }

        public String getId() {
            return ID;
        }
    }
}

