/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.utils;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IllagersPlusConfig {
    public static Configuration config;
    public static final String CATEGORY_GENERAL = "config.category.general.name";
    public static int illager_tower_freq;
    public static int illager_archer_tower_freq;
    public static int illager_centre_freq;

    public static void initConfig(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            IllagersPlusConfig.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        try {
            illager_tower_freq = config.getInt("config.illager_tower_freq.name", CATEGORY_GENERAL, 100, 10, 9001, "The frequency at which the illager tower spawns. The higher the number, the less likely it spawns. (1 in x chances)");
            illager_archer_tower_freq = config.getInt("config.illager_archer_tower_freq.name", CATEGORY_GENERAL, 100, 10, 9001, "The frequency at which the illager archer tower spawns. The higher the number, the less likely it spawns. (1 in x chances)");
            illager_centre_freq = config.getInt("config.illager_centre_freq.name", CATEGORY_GENERAL, 100, 10, 9001, "The frequency at which the illager centre spawns. The higher the number, the less likely it spawns. (1 in x chances)");
        }
        catch (Exception e) {
            System.err.println("Error loading config! " + e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("illagers_plus")) {
            IllagersPlusConfig.loadConfiguration();
        }
    }
}

