/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.commands;

import com.google.common.collect.Maps;
import com.litewolf101.utils.StructureHandler;
import com.litewolf101.world.WorldGenCustomStructures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class IllagersPlusCommands
extends CommandBase {
    private final String name = "illagersplus";
    private final List<String> commands = new ArrayList<String>();
    private final List<String> bool = new ArrayList<String>();
    public static final List<String> structureNames = new ArrayList<String>();
    private final Map<String, StructureHandler> returnStructure = Maps.newHashMap();

    public IllagersPlusCommands() {
        this.commands.add("spawnStructure");
        this.commands.add("data");
        this.commands.add("help");
        this.commands.add("constructFullMultiStructure");
        this.bool.add("true");
        this.bool.add("false");
        structureNames.add(WorldGenCustomStructures.ILLAGER_TOWER_F1.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_TOWER_F1);
        structureNames.add(WorldGenCustomStructures.ILLAGER_TOWER_F2_A.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_TOWER_F2_A);
        structureNames.add(WorldGenCustomStructures.ILLAGER_TOWER_F2_B.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_TOWER_F2_B);
        structureNames.add(WorldGenCustomStructures.ILLAGER_TOWER_F3_A.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_TOWER_F3_A);
        structureNames.add(WorldGenCustomStructures.ILLAGER_TOWER_F3_B.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_TOWER_F3_B);
        structureNames.add(WorldGenCustomStructures.ILLAGER_TOWER_F3_C.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_TOWER_F3_C);
        structureNames.add(WorldGenCustomStructures.ILLAGER_TOWER_F4_A.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_TOWER_F4_A);
        structureNames.add(WorldGenCustomStructures.ILLAGER_TOWER_F4_B.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_TOWER_F4_B);
        structureNames.add(WorldGenCustomStructures.ILLAGER_TOWER_F5.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_TOWER_F5);
        structureNames.add(WorldGenCustomStructures.ILLAGER_TOWER_F6.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_TOWER_F6);
        structureNames.add(WorldGenCustomStructures.ILLAGER_ARCHER_TOWER.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_ARCHER_TOWER);
        structureNames.add(WorldGenCustomStructures.ILLAGER_CENTRE.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_CENTRE);
        structureNames.add(WorldGenCustomStructures.ILLAGER_FARM.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_FARM);
        structureNames.add(WorldGenCustomStructures.ILLAGER_WELL.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_WELL);
        structureNames.add(WorldGenCustomStructures.ILLAGER_DUMMY_1.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_DUMMY_1);
        structureNames.add(WorldGenCustomStructures.ILLAGER_DUMMY_2.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_DUMMY_2);
        structureNames.add(WorldGenCustomStructures.ANIMAL_PEN.structureName);
        this.addToMap(WorldGenCustomStructures.ANIMAL_PEN);
        structureNames.add(WorldGenCustomStructures.UNDYING_TOTEM.structureName);
        this.addToMap(WorldGenCustomStructures.UNDYING_TOTEM);
        structureNames.add(WorldGenCustomStructures.FIREWORKS_DISPLAY.structureName);
        this.addToMap(WorldGenCustomStructures.FIREWORKS_DISPLAY);
        structureNames.add(WorldGenCustomStructures.FLOWER_BED.structureName);
        this.addToMap(WorldGenCustomStructures.FLOWER_BED);
        structureNames.add(WorldGenCustomStructures.ILLAGER_STORAGE.structureName);
        this.addToMap(WorldGenCustomStructures.ILLAGER_STORAGE);
        structureNames.add(WorldGenCustomStructures.LOG_PILE.structureName);
        this.addToMap(WorldGenCustomStructures.LOG_PILE);
    }

    public void addToMap(StructureHandler handler) {
        if (handler != null) {
            this.returnStructure.put(handler.structureName, handler);
        }
    }

    public StructureHandler getStructureFromName(String name) {
        for (Map.Entry<String, StructureHandler> entry : this.returnStructure.entrySet()) {
            if (!name.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public String func_71517_b() {
        return "illagersplus";
    }

    public String func_71518_a(ICommandSender iCommandSender) {
        return "Incorrect, incomplete or unknown command. Use " + TextFormatting.GREEN + "/illagersplus help " + TextFormatting.RED + "for additional info.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer minecraftServer, ICommandSender sender, String[] strings) throws CommandException {
        if (!(sender instanceof EntityPlayerMP)) {
            throw new WrongUsageException("message.command.onlyInGame", new Object[0]);
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        WorldServer world = player.func_71121_q();
        if (strings.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (strings[0].equals("help")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + "-----Illagers+ Info Page(1)-----\n" + TextFormatting.RED + "/illagersplus help" + TextFormatting.RESET + "\n" + TextFormatting.GRAY + "Displays this screen." + TextFormatting.RESET + "\n\n" + TextFormatting.RED + "/illagersplus spawnStructure <x> <y> <z> <illagersplus_structure_name> <rotateNone|rotate90|rotate180|rotate270> <true|false>" + TextFormatting.RESET + "\n" + TextFormatting.GRAY + "Spawns an Illagers+ structure at the given location." + TextFormatting.RESET + "\n\n" + TextFormatting.RED + "/illagersplus data" + TextFormatting.RESET + "\n" + TextFormatting.GRAY + "Displays the mod name, current version of mod and current version of minecraft." + TextFormatting.RESET + "\n\n" + TextFormatting.RED + "/illagersplus constructFullMultiStructure <x> <y> <z> <rotateNone|rotate90|rotate180|rotate270>" + TextFormatting.RESET + "\n" + TextFormatting.GRAY + "Fully constructs an Illagers+ Multipart Structure." + TextFormatting.ITALIC + "(e.g. The Illager Tower)"));
            return;
        } else if (strings[0].equals("data")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "\u2605MOD: " + TextFormatting.RESET + "Illigers+" + "\n" + TextFormatting.GRAY + "\u2605VERSION: " + TextFormatting.RESET + "1.1" + "\n" + TextFormatting.GRAY + "\u2605MINECRAFT VERSION: " + TextFormatting.RESET + "[1.12.2]"));
            return;
        } else if (strings[0].equals("spawnStructure")) {
            if (strings.length < 6) {
                throw new WrongUsageException("/illagersplus spawnStructure <x> <y> <z> <illagersplus_structure_name> <rotateNone|rotate90|rotate180|rotate270>", new Object[0]);
            }
            BlockPos blockpos = IllagersPlusCommands.func_175757_a((ICommandSender)sender, (String[])strings, (int)1, (boolean)false);
            if (!structureNames.contains(strings[4])) throw new WrongUsageException("\"" + strings[4] + "\" is not a structure of Illagers+", new Object[0]);
            if ("rotateNone".equals(strings[5])) {
                this.getStructureFromName(strings[4]).generateStructureRotNone((World)world, blockpos);
                if ("true".equals(strings[6])) {
                    WorldGenCustomStructures.genCommandStructureFeatures(sender, strings[4], strings[5], (World)world, blockpos, ((EntityPlayerMP)sender).func_70681_au());
                }
            } else if ("rotate90".equals(strings[5])) {
                this.getStructureFromName(strings[4]).generateStructureRot90((World)world, blockpos);
                if ("true".equals(strings[6])) {
                    WorldGenCustomStructures.genCommandStructureFeatures(sender, strings[4], strings[5], (World)world, blockpos, ((EntityPlayerMP)sender).func_70681_au());
                }
            } else if ("rotate180".equals(strings[5])) {
                this.getStructureFromName(strings[4]).generateStructureRot180((World)world, blockpos);
                if ("true".equals(strings[6])) {
                    WorldGenCustomStructures.genCommandStructureFeatures(sender, strings[4], strings[5], (World)world, blockpos, ((EntityPlayerMP)sender).func_70681_au());
                }
            } else if ("rotate270".equals(strings[5])) {
                this.getStructureFromName(strings[4]).generateStructureRot270((World)world, blockpos);
                if ("true".equals(strings[6])) {
                    WorldGenCustomStructures.genCommandStructureFeatures(sender, strings[4], strings[5], (World)world, blockpos, ((EntityPlayerMP)sender).func_70681_au());
                }
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Structure spawned!"));
            return;
        } else {
            if (!strings[0].equals("constructFullMultiStructure")) return;
            if (strings.length < 4) {
                throw new WrongUsageException("/illagersplus constructFullMultiStructure <x> <y> <z> <rotateNone|rotate90|rotate180|rotate270>", new Object[0]);
            }
            if (sender.func_180425_c().func_177956_o() > sender.func_130014_f_().func_72800_K() - 90) {
                throw new WrongUsageException("Structure cannot exceed world height limit!", new Object[0]);
            }
            BlockPos blockpos = IllagersPlusCommands.func_175757_a((ICommandSender)sender, (String[])strings, (int)1, (boolean)false);
            WorldGenCustomStructures.genCommandIllagerTower(((EntityPlayerMP)sender).field_70170_p, ((EntityPlayerMP)sender).func_70681_au(), blockpos, strings[4]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Structure spawned!"));
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args[0].equals("spawnStructure")) {
            if (args.length > 1 && args.length <= 4) {
                return IllagersPlusCommands.func_175771_a((String[])args, (int)0, (BlockPos)targetPos);
            }
            if (args.length == 5) {
                return IllagersPlusCommands.func_175762_a((String[])args, structureNames);
            }
            if (args.length == 6) {
                return IllagersPlusCommands.func_71530_a((String[])args, (String[])new String[]{"rotateNone", "rotate90", "rotate180", "rotate270"});
            }
            return args.length == 7 ? this.bool : Collections.emptyList();
        }
        if (args[0].equals("constructFullMultiStructure")) {
            if (args.length > 1 && args.length <= 4) {
                return IllagersPlusCommands.func_175771_a((String[])args, (int)0, (BlockPos)targetPos);
            }
            return args.length == 5 ? IllagersPlusCommands.func_71530_a((String[])args, (String[])new String[]{"rotateNone", "rotate90", "rotate180", "rotate270"}) : Collections.emptyList();
        }
        return args.length == 1 ? this.commands : Collections.emptyList();
    }
}

