/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.reg;

import icbm.classic.api.EnumTier;
import icbm.classic.api.ExplosiveRefs;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.explosion.IBlastFactory;
import icbm.classic.api.items.IWorldPosItem;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.config.ConfigBlast;
import icbm.classic.content.blast.BlastAntiGravitational;
import icbm.classic.content.blast.BlastBreach;
import icbm.classic.content.blast.BlastEMP;
import icbm.classic.content.blast.BlastEnderman;
import icbm.classic.content.blast.BlastEndothermic;
import icbm.classic.content.blast.BlastExothermic;
import icbm.classic.content.blast.BlastFire;
import icbm.classic.content.blast.BlastGasBase;
import icbm.classic.content.blast.BlastMutation;
import icbm.classic.content.blast.BlastRedmatter;
import icbm.classic.content.blast.BlastRot;
import icbm.classic.content.blast.BlastShrapnel;
import icbm.classic.content.blast.BlastSonic;
import icbm.classic.content.blast.BlastTNT;
import icbm.classic.content.blast.threaded.BlastAntimatter;
import icbm.classic.content.blast.threaded.BlastNuclear;
import icbm.classic.lib.explosive.reg.ExplosiveRegistry;
import icbm.classic.lib.transform.vector.Location;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ExplosiveInit {
    public static void init() {
        ExplosiveRefs.CONDENSED = ExplosiveInit.newEx(0, "condensed", EnumTier.ONE, () -> new BlastTNT().setBlastSize(6.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.CONDENSED.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.CONDENSED);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ExplosiveRefs.CONDENSED.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.CONVENTIONAL);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.CONDENSED.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.CONDENSED);
        ExplosiveRefs.SHRAPNEL = ExplosiveInit.newEx(1, "shrapnel", EnumTier.ONE, () -> new BlastShrapnel().setFlaming().setBlastSize(30.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.SHRAPNEL.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.SHRAPNEL);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ExplosiveRefs.SHRAPNEL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.SHRAPNEL);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.SHRAPNEL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.SHRAPNEL);
        ExplosiveRefs.INCENDIARY = ExplosiveInit.newEx(2, "incendiary", EnumTier.ONE, () -> new BlastFire().setBlastSize(14.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseTickListener(ExplosiveRefs.INCENDIARY.getRegistryName(), (world, x, y, z, tick) -> world.func_175688_a(EnumParticleTypes.LAVA, x, y + 0.5, z, 0.0, 0.0, 0.0, new int[0]));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.INCENDIARY.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.INCENDIARY);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ExplosiveRefs.INCENDIARY.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.INCENDIARY);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.INCENDIARY.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.INCENDIARY);
        ExplosiveRefs.DEBILITATION = ExplosiveInit.newEx(3, "debilitation", EnumTier.ONE, () -> new BlastGasBase(600, false).setConfuse().setBlastSize(20.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.DEBILITATION.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.DEBILITATION);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ExplosiveRefs.DEBILITATION.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.DEBILITATION);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.DEBILITATION.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.DEBILITATION);
        ExplosiveRefs.CHEMICAL = ExplosiveInit.newEx(4, "chemical", EnumTier.ONE, () -> new BlastGasBase(600, false).setPoison().setRGB(0.8f, 0.8f, 0.0f).setBlastSize(20.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.CHEMICAL.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.CHEMICAL);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ExplosiveRefs.CHEMICAL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.CHEMICAL);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.CHEMICAL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.CHEMICAL);
        ExplosiveRefs.ANVIL = ExplosiveInit.newEx(5, "anvil", EnumTier.ONE, () -> new BlastShrapnel().setAnvil().setBlastSize(25.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.ANVIL.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ANVIL);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ExplosiveRefs.ANVIL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.ANVIL);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.ANVIL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ANVIL);
        ExplosiveRefs.REPULSIVE = ExplosiveInit.newEx(6, "repulsive", EnumTier.ONE, () -> new BlastTNT().setDestroyItems().setPushType(BlastTNT.PushType.REPEL).setBlastSize(2.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.REPULSIVE.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.REPULSIVE);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ExplosiveRefs.REPULSIVE.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.REPULSIVE);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.REPULSIVE.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.REPULSIVE);
        ExplosiveRefs.ATTRACTIVE = ExplosiveInit.newEx(7, "attractive", EnumTier.ONE, () -> new BlastTNT().setDestroyItems().setPushType(BlastTNT.PushType.ATTRACT).setBlastSize(2.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.ATTRACTIVE.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ATTRACTIVE);
        ICBMClassicAPI.EX_GRENADE_REGISTRY.setFuseSupplier(ExplosiveRefs.ATTRACTIVE.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.GRENADES.ATTRACTIVE);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.ATTRACTIVE.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ATTRACTIVE);
        ExplosiveRefs.FRAGMENTATION = ExplosiveInit.newEx(8, "fragmentation", EnumTier.TWO, () -> new BlastShrapnel().setFlaming().setExplosive().setBlastSize(15.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.FRAGMENTATION.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.FRAGMENTATION);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.FRAGMENTATION.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.FRAGMENTATION);
        ExplosiveRefs.CONTAGIOUS = ExplosiveInit.newEx(9, "contagious", EnumTier.TWO, () -> new BlastGasBase(600, false).setContagious().setRGB(0.3f, 0.8f, 0.0f).setBlastSize(20.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.CONTAGIOUS.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.CONTAGIOUS);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.CONTAGIOUS.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.CONTAGIOUS);
        ExplosiveRefs.SONIC = ExplosiveInit.newEx(10, "sonic", EnumTier.TWO, () -> new BlastSonic().setBlastSize(15.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.SONIC.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.SONIC);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.SONIC.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.SONIC);
        ExplosiveRefs.BREACHING = ExplosiveInit.newEx(11, "breaching", EnumTier.TWO, () -> new BlastBreach(7).setBlastSize(2.5));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.BREACHING.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.BREACHING);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.BREACHING.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.BREACHING);
        ExplosiveRefs.THERMOBARIC = ExplosiveInit.newEx(13, "thermobaric", EnumTier.TWO, () -> new BlastNuclear().setEnergy(45.0f).setBlastSize(30.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.THERMOBARIC.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.THERMOBARIC);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.THERMOBARIC.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.THERMOBARIC);
        ExplosiveRefs.NUCLEAR = ExplosiveInit.newEx(15, "nuclear", EnumTier.THREE, () -> new BlastNuclear().setNuclear().setEnergy(80.0f).setBlastSize(50.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.NUCLEAR.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.NUCLEAR);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.NUCLEAR.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.NUCLEAR);
        ExplosiveRefs.EMP = ExplosiveInit.newEx(16, "emp", EnumTier.THREE, () -> new BlastEMP().setEffectBlocks().setEffectEntities().setBlastSize(50.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.EMP.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.EMP);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.EMP.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.EMP);
        ExplosiveRefs.EXOTHERMIC = ExplosiveInit.newEx(17, "exothermic", EnumTier.THREE, () -> new BlastExothermic().setBlastSize(30.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseTickListener(ExplosiveRefs.EXOTHERMIC.getRegistryName(), (world, x, y, z, tick) -> world.func_175688_a(EnumParticleTypes.LAVA, x, y + 0.5, z, 0.0, 0.0, 0.0, new int[0]));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.EXOTHERMIC.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.EXOTHERMIC);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.EXOTHERMIC.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.EXOTHERMIC);
        ExplosiveRefs.ENDOTHERMIC = ExplosiveInit.newEx(18, "endothermic", EnumTier.THREE, () -> new BlastEndothermic().setBlastSize(30.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.ENDOTHERMIC.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ENDOTHERMIC);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.ENDOTHERMIC.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ENDOTHERMIC);
        ExplosiveRefs.ANTI_GRAVITATIONAL = ExplosiveInit.newEx(19, "antigravitational", EnumTier.THREE, () -> new BlastAntiGravitational().setBlastSize(30.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.ANTI_GRAVITATIONAL.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ANTI_GRAVITATIONAL);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.ANTI_GRAVITATIONAL.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ANTI_GRAVITATIONAL);
        ExplosiveRefs.ENDER = ExplosiveInit.newEx(20, "ender", EnumTier.THREE, () -> new BlastEnderman().setBlastSize(30.0));
        ICBMClassicAPI.EX_MISSILE_REGISTRY.setInteractionListener(ExplosiveRefs.ENDER.getRegistryName(), ExplosiveInit::enderMissileCoordSet);
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setActivationListener(ExplosiveRefs.ENDER.getRegistryName(), ExplosiveInit::enderBlockCoordSet);
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.ENDER.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ENDER);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.ENDER.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ENDER);
        ExplosiveRefs.HYPERSONIC = ExplosiveInit.newEx(21, "hypersonic", EnumTier.THREE, () -> new BlastSonic().setShockWave().setBlastSize(20.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.HYPERSONIC.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.HYPERSONIC);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.HYPERSONIC.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.HYPERSONIC);
        ExplosiveRefs.ANTIMATTER = ExplosiveInit.newEx(22, "antimatter", EnumTier.FOUR, () -> new BlastAntimatter().setBlastSize(ConfigBlast.ANTIMATTER_SIZE));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.ANTIMATTER.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.ANTIMATTER);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.ANTIMATTER.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.ANTIMATTER);
        ExplosiveRefs.REDMATTER = ExplosiveInit.newEx(23, "redMatter", EnumTier.FOUR, () -> new BlastRedmatter().setBlastSize(70.0));
        ICBMClassicAPI.EX_BLOCK_REGISTRY.setFuseSupplier(ExplosiveRefs.REDMATTER.getRegistryName(), (world, x, y, z) -> ConfigBlast.FUSE_TIMES.EXPLOSIVES.REDMATTER);
        ICBMClassicAPI.EX_MINECART_REGISTRY.setFuseSupplier(ExplosiveRefs.REDMATTER.getRegistryName(), entity -> ConfigBlast.FUSE_TIMES.BOMB_CARTS.REDMATTER);
        ExplosiveRefs.MUTATION = ExplosiveInit.newEx(24, "mutation", EnumTier.NONE, () -> new BlastMutation());
        ExplosiveRefs.ROT = ExplosiveInit.newEx(25, "rot", EnumTier.NONE, () -> new BlastRot());
        ((ExplosiveRegistry)ICBMClassicAPI.EXPLOSIVE_REGISTRY).lockForce();
    }

    private static IExplosiveData newEx(int id, String name, EnumTier tier, IBlastFactory factory) {
        if (id != -1) {
            ((ExplosiveRegistry)ICBMClassicAPI.EXPLOSIVE_REGISTRY).forceID(new ResourceLocation("icbmclassic", name), id);
        }
        return ICBMClassicAPI.EXPLOSIVE_REGISTRY.register(new ResourceLocation("icbmclassic", name), tier, factory);
    }

    private static boolean enderMissileCoordSet(Entity entity, EntityPlayer player, EnumHand hand) {
        IWorldPosItem posItem;
        Location link;
        ItemStack heldItem;
        IExplosive provider;
        NBTTagCompound tag;
        if (entity.hasCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null) && (tag = (provider = (IExplosive)entity.getCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null)).getCustomBlastData()) != null && (heldItem = player.func_184586_b(hand)).func_77973_b() instanceof IWorldPosItem && (link = (posItem = (IWorldPosItem)heldItem.func_77973_b()).getLocation(heldItem)) instanceof Location) {
            link.writeIntNBT(tag);
            if (!entity.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Coordinates encoded into entity"));
            }
            return true;
        }
        return false;
    }

    private static boolean enderBlockCoordSet(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IExplosive explosive;
        TileEntity tileEntity;
        IWorldPosItem posItem;
        Location link;
        ItemStack heldItem = entityPlayer.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof IWorldPosItem && (link = (posItem = (IWorldPosItem)heldItem.func_77973_b()).getLocation(heldItem)) instanceof Location && (tileEntity = world.func_175625_s(pos)).hasCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, facing) && (explosive = (IExplosive)tileEntity.getCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, facing)) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            link.writeIntNBT(tag);
            explosive.getCustomBlastData().func_74782_a("", (NBTBase)tag);
            if (!world.field_72995_K) {
                // empty if block
            }
            return true;
        }
        return false;
    }
}

