/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.web;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class MultipartBuilder {
    public final String bound;
    public final List<MultipartEntity> parts = new ArrayList<MultipartEntity>();

    public MultipartBuilder() {
        char[] available = "0123456789abcdefghijABCDEFGHIJ".toCharArray();
        String bound = "----HammerCoreFormBoundary-";
        for (int i = 0; i < available.length; ++i) {
            bound = bound + available[ThreadLocalRandom.current().nextInt(available.length)];
        }
        this.bound = bound;
    }

    public MultipartBuilder addPart(MultipartEntity entity) {
        this.parts.add(entity);
        return this;
    }

    public MultipartBuilder addPart(String name, String text) {
        return this.addPart(new MultipartEntity(name, null, "text/txt", text.getBytes(StandardCharsets.UTF_8)));
    }

    public void writeMultipart(OutputStream target) throws IOException {
        for (MultipartEntity entity : this.parts) {
            entity.write(this, target);
        }
        target.write(("\r\n--" + this.bound + "--").getBytes());
    }

    public static class MultipartEntity {
        public final String name;
        public final String filename;
        public final String contentType;
        public final byte[] data;

        public MultipartEntity(String name, String filename, String contentType, byte[] data) {
            this.name = name;
            this.filename = filename;
            this.contentType = contentType == null || contentType.isEmpty() ? "*/*" : contentType;
            this.data = data;
        }

        public void write(MultipartBuilder builder, OutputStream output) throws IOException {
            String info = "--" + builder.bound + "\r\nContent-Disposition: form-data; name=\"" + this.name + "\";" + (this.filename != null ? " filename=\"" + this.filename + "\"" : "") + "\r\nContent-Type: " + this.contentType + "\r\n\r\n";
            output.write(info.getBytes());
            output.write(this.data);
        }
    }
}

