/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.math;

import com.zeitheron.hammercore.utils.AABBUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.math.AxisAlignedBB;

public class VoxelShape
implements AABBUtils.ILinable {
    private final List<AABBUtils.Line> lines = new ArrayList<AABBUtils.Line>();

    public static VoxelShape start() {
        return new VoxelShape();
    }

    private VoxelShape(List<AABBUtils.Line> lns) {
        this.lines.addAll(lns);
    }

    private VoxelShape(Stream<AABBUtils.Line> lns) {
        lns.forEach(this.lines::add);
    }

    private VoxelShape() {
    }

    public VoxelShape add(AABBUtils.Line line) {
        this.lines.add(line);
        return this;
    }

    public VoxelShape addAll(AABBUtils.Line ... lines) {
        for (AABBUtils.Line ln : lines) {
            this.add(ln);
        }
        return this;
    }

    public VoxelShape add(AxisAlignedBB aabb) {
        AABBUtils.Line.of(aabb).forEach(this.lines::add);
        return this;
    }

    public VoxelShape addAll(AxisAlignedBB ... aabbs) {
        for (AxisAlignedBB aabb : aabbs) {
            this.add(aabb);
        }
        return this;
    }

    public VoxelShape add(AABBUtils.ILinable linable) {
        this.lines.addAll(linable.asLines());
        return this;
    }

    public VoxelShape addAll(AABBUtils.ILinable ... linables) {
        for (AABBUtils.ILinable lnb : linables) {
            this.add(lnb);
        }
        return this;
    }

    public VoxelShape grow(double expand) {
        List<AABBUtils.Line> nl = AABBUtils.Line.grow(this.lines, expand);
        this.lines.clear();
        this.lines.addAll(nl);
        return this;
    }

    @Override
    public List<AABBUtils.Line> asLines() {
        return AABBUtils.Line.dedupe(this.lines);
    }

    public VoxelShape offset(double x, double y, double z) {
        return new VoxelShape(this.lines.stream().map(ln -> ln.offset(x, y, z)));
    }
}

