/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.loot;

import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.loot.ILootTableMaster;
import com.someguyssoftware.gottschcore.loot.LootTableShell;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.version.BuildVersion;
import com.someguyssoftware.gottschcore.version.VersionChecker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableMaster2
implements ILootTableMaster {
    public static Logger LOGGER = LogManager.getLogger((String)GottschCore.logger.getName());
    public static final String LOOT_TABLES_FOLDER = "loot_tables";
    protected static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).create();
    private final IMod mod;
    private File worldDataBaseFolder;
    private LootContext context;

    public LootTableMaster2(IMod mod) {
        this.mod = mod;
    }

    public LootTableMaster2(IMod mod, File folder) {
        this.mod = mod;
        this.worldDataBaseFolder = folder;
    }

    @Override
    public void init(WorldServer world) {
        Path path = Paths.get(world.func_72860_G().func_75765_b().getPath(), "data", LOOT_TABLES_FOLDER);
        this.setWorldDataBaseFolder(path.toFile());
        this.context = new LootContext.Builder(world).func_186471_a();
    }

    @Override
    public void clear() {
    }

    @Override
    public void buildAndExpose(String resourceRootPath, String modID, List<String> locations) {
        GottschCore.logger.debug("loot table folder locations -> {}", locations);
        for (String location : locations) {
            GottschCore.logger.debug("buildAndExpose location -> {}", (Object)location);
            this.createLootTableFolder(modID, location);
            this.exposeLootTable(resourceRootPath, modID, location);
        }
    }

    @Override
    public void register(WorldServer world, String modID, List<String> locations) {
    }

    protected void createLootTableFolder(String modID, String location) {
        if (modID == null || modID.isEmpty()) {
            modID = this.getMod().getId();
        }
        Path configPath = Paths.get(this.getMod().getConfig().getConfigFolder(), new String[0]);
        Path folder = Paths.get(configPath.toString(), modID, LOOT_TABLES_FOLDER, location != null && !location.isEmpty() ? location : "").toAbsolutePath();
        if (Files.notExists(folder, new LinkOption[0])) {
            GottschCore.logger.debug("loot tables folder \"{}\" will be created.", (Object)folder.toString());
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                GottschCore.logger.warn("Unable to create loot tables folder \"{}\"", (Object)folder.toString());
            }
        }
    }

    protected void createWorldDataLootTableFolder(String modID, String location) {
        Path worldDataFilePath;
        if (modID == null || modID.isEmpty()) {
            modID = this.getMod().getId();
        }
        if (Files.notExists(worldDataFilePath = Paths.get(this.getWorldDataBaseFolder().toString(), modID, location).toAbsolutePath(), new LinkOption[0])) {
            GottschCore.logger.debug("loot tables folder \"{}\" will be created.", (Object)worldDataFilePath.toString());
            try {
                Files.createDirectories(worldDataFilePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                GottschCore.logger.warn("Unable to create world data loot tables folder \"{}\"", (Object)worldDataFilePath.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exposeLootTable(String resourceRootPath, String modID, String location) {
        if (modID == null || modID.isEmpty()) {
            modID = this.getMod().getId();
        }
        location = location != null && !location.equals("") ? location + "/" : "";
        Stream<Path> walk = null;
        FileSystem fs = this.getResourceAsFileSystem(resourceRootPath, modID, location);
        if (fs == null) {
            return;
        }
        try {
            Path resourceBasePath = fs.getPath(resourceRootPath, modID, location);
            Path folder = Paths.get(this.getMod().getConfig().getConfigFolder(), modID, LOOT_TABLES_FOLDER, location).toAbsolutePath();
            boolean isFirst = true;
            walk = Files.walk(resourceBasePath, 1, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path resourceFilePath = (Path)it.next();
                GottschCore.logger.debug("mod loot_table -> {}", (Object)resourceFilePath.toString());
                if (isFirst) {
                    if (Files.notExists(folder, new LinkOption[0])) {
                        this.createLootTableFolder(modID, location);
                    }
                } else {
                    if (Files.isDirectory(resourceFilePath, new LinkOption[0])) {
                        GottschCore.logger.debug("resource is a folder -> {}", (Object)resourceFilePath.toString());
                        continue;
                    }
                    Path fileSystemFilePath = Paths.get(folder.toString(), resourceFilePath.getFileName().toString()).toAbsolutePath();
                    GottschCore.logger.debug("config loot table path -> {}", (Object)fileSystemFilePath.toString());
                    if (Files.notExists(fileSystemFilePath, new LinkOption[0])) {
                        this.copyResourceToFileSystem(resourceFilePath, fileSystemFilePath);
                    } else {
                        boolean isCurrent = false;
                        try {
                            isCurrent = this.isFileSystemVersionCurrent(resourceFilePath, fileSystemFilePath);
                        }
                        catch (Exception e) {
                            GottschCore.logger.warn(e.getMessage(), (Throwable)e);
                            continue;
                        }
                        GottschCore.logger.error("is file system (config) loot table current -> {}", (Object)isCurrent);
                        if (!isCurrent) {
                            Files.move(fileSystemFilePath, Paths.get(folder.toString(), resourceFilePath.getFileName().toString() + ".bak").toAbsolutePath(), StandardCopyOption.REPLACE_EXISTING);
                            this.copyResourceToFileSystem(resourceFilePath, fileSystemFilePath);
                        }
                    }
                }
                isFirst = false;
            }
        }
        catch (Exception e) {
            GottschCore.logger.error("error:", (Throwable)e);
        }
        finally {
            if (walk != null) {
                walk.close();
            }
        }
        if (fs != null && fs.isOpen()) {
            try {
                fs.close();
            }
            catch (IOException e) {
                GottschCore.logger.debug("An error occurred attempting to close the FileSystem:", (Throwable)e);
            }
        }
    }

    private void copyResourceToFileSystem(Path resourceFilePath, Path fileSystemFilePath) {
        InputStream is = LootTableMaster2.class.getResourceAsStream(resourceFilePath.toString());
        try (FileOutputStream fos = new FileOutputStream(fileSystemFilePath.toFile());){
            int r;
            byte[] buf = new byte[2048];
            while ((r = is.read(buf)) != -1) {
                fos.write(buf, 0, r);
            }
        }
        catch (IOException e) {
            GottschCore.logger.error("Error exposing resource to file system.", (Throwable)e);
        }
    }

    protected boolean isWorldDataVersionCurrent(Path configFilePath, Path worldDataFilePath) {
        String worldDataJson;
        String configJson;
        boolean result = true;
        GottschCore.logger.debug("Verifying the most current version for the world data loot table -> {} ...", (Object)worldDataFilePath.getFileName());
        try {
            configJson = com.google.common.io.Files.toString((File)configFilePath.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't load config loot table from {}", (Object)configFilePath.toString(), (Object)e);
            return false;
        }
        try {
            worldDataJson = com.google.common.io.Files.toString((File)worldDataFilePath.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't load world data loot table from {}", (Object)worldDataFilePath.toString(), (Object)e);
            return false;
        }
        LootTableShell configLootTable = this.loadLootTable(configJson);
        LootTableShell worldDataLootTable = this.loadLootTable(worldDataJson);
        GottschCore.logger.debug("\n\t...config loot table -> {}\n\t...version -> {}\n\t...world data loot table -> {}\n\t...version -> {}", (Object)configFilePath.toString(), (Object)configLootTable.getVersion(), (Object)worldDataFilePath.toString(), (Object)worldDataLootTable.getVersion());
        if (configLootTable != null && worldDataLootTable != null) {
            BuildVersion configVersion = new BuildVersion(configLootTable.getVersion());
            BuildVersion worldDataVersion = new BuildVersion(worldDataLootTable.getVersion());
            result = VersionChecker.checkVersion(configVersion, worldDataVersion);
        }
        if (result && configFilePath.toFile().lastModified() > worldDataFilePath.toFile().lastModified()) {
            result = false;
        }
        return result;
    }

    protected boolean isFileSystemVersionCurrent(Path resourceFilePath, Path fileSystemFilePath) throws Exception {
        String resourceJson;
        String configJson;
        boolean result = true;
        GottschCore.logger.debug("Verifying the most current version for the loot table -> {} ...", (Object)fileSystemFilePath.getFileName());
        try {
            configJson = com.google.common.io.Files.toString((File)fileSystemFilePath.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't load config loot table from {}", (Object)fileSystemFilePath.toString(), (Object)e);
            return false;
        }
        LootTableShell fsLootTable = this.loadLootTable(configJson);
        ResourceLocation loc = new ResourceLocation(this.getMod().getId(), resourceFilePath.toString().replace(".json", ""));
        URL url = LootTableManager.class.getResource(resourceFilePath.toString());
        if (url == null) {
            GottschCore.logger.debug("Unable to get resource -> {}", (Object)resourceFilePath.toString());
            return false;
        }
        try {
            resourceJson = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new Exception(String.format("Couldn't load loot table %s from %s", resourceFilePath, url), e);
        }
        LootTableShell resourceLootTable = null;
        try {
            resourceLootTable = this.loadLootTable(resourceJson);
        }
        catch (JsonParseException | IllegalArgumentException e) {
            throw new Exception(String.format("Couldn't load loot table %s from %s", resourceFilePath, url), e);
        }
        GottschCore.logger.debug("\n\t...file system loot table -> {}\n\t...version -> {}\n\t...resource loot table -> {}\n\t...version -> {}", (Object)fileSystemFilePath.toString(), (Object)fsLootTable.getVersion(), (Object)loc.toString(), (Object)resourceLootTable.getVersion());
        if (resourceLootTable != null && fsLootTable != null) {
            BuildVersion resourceVersion = new BuildVersion(resourceLootTable.getVersion());
            BuildVersion fsVersion = new BuildVersion(fsLootTable.getVersion());
            result = VersionChecker.checkVersion(resourceVersion, fsVersion);
        }
        return result;
    }

    protected FileSystem getResourceAsFileSystem(String resourceRootPath, String modID, String location) {
        FileSystem fs = null;
        HashMap env = new HashMap();
        URI uri = null;
        resourceRootPath = "/" + resourceRootPath.replaceAll("^/|/$", "") + "/";
        URL url = GottschCore.class.getResource(resourceRootPath + modID + "/" + location);
        if (url == null) {
            GottschCore.logger.error("Unable to locate resource {}", (Object)(resourceRootPath + modID + "/" + location));
            return null;
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            GottschCore.logger.error("An error occurred during loot table processing:", (Throwable)e);
            return null;
        }
        String[] array = uri.toString().split("!");
        try {
            fs = FileSystems.newFileSystem(URI.create(array[0]), env);
        }
        catch (IOException e) {
            GottschCore.logger.error("An error occurred during loot table processing:", (Throwable)e);
            return null;
        }
        return fs;
    }

    public List<ResourceLocation> getLootTablesResourceLocations(String modIDIn, String locationIn) {
        String modID = modIDIn == null || modIDIn.isEmpty() ? this.getMod().getId() : modIDIn;
        String location = locationIn != null && !locationIn.equals("") ? locationIn + "/" : "";
        ArrayList<ResourceLocation> locs = new ArrayList<ResourceLocation>();
        Path path = Paths.get(this.getWorldDataBaseFolder().getPath(), modID, location).toAbsolutePath();
        GottschCore.logger.debug("Path to world data loot table -> {}", (Object)path.toString());
        if (Files.notExists(path, new LinkOption[0])) {
            GottschCore.logger.debug("Unable to locate -> {}", (Object)path.toString());
            return locs;
        }
        try {
            Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> {
                GottschCore.logger.debug("World data loot table file -> {}", (Object)f.toAbsolutePath().toString());
                if (FilenameUtils.getExtension((String)f.getFileName().toString()).equals("json")) {
                    ResourceLocation loc = new ResourceLocation(modID + ":" + location + f.getFileName().toString().replace(".json", ""));
                    GottschCore.logger.debug("Resource location -> {}", (Object)loc);
                    locs.add(loc);
                }
            });
        }
        catch (IOException e) {
            GottschCore.logger.error("Error processing custom loot table:", (Throwable)e);
        }
        return locs;
    }

    public LootTableShell loadLootTable(String json) throws IllegalArgumentException, JsonParseException {
        return (LootTableShell)GSON_INSTANCE.fromJson(json, LootTableShell.class);
    }

    public Optional<LootTableShell> loadLootTable(File folder, ResourceLocation resource) {
        if (this.getWorldDataBaseFolder() == null) {
            return Optional.empty();
        }
        File lootTableFile = Paths.get(folder.getPath(), resource.func_110624_b(), resource.func_110623_a() + ".json").toFile();
        LOGGER.debug("Attempting to load loot table {} from {}", (Object)resource, (Object)lootTableFile);
        if (lootTableFile.exists()) {
            if (lootTableFile.isFile()) {
                String json;
                try {
                    json = com.google.common.io.Files.toString((File)lootTableFile, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    LOGGER.warn("Couldn't load loot table {} from {}", (Object)resource, (Object)lootTableFile, (Object)e);
                    return Optional.empty();
                }
                try {
                    return Optional.of(this.loadLootTable(json));
                }
                catch (JsonParseException | IllegalArgumentException e) {
                    LOGGER.error("Couldn't load loot table {} from {}", (Object)resource, (Object)lootTableFile, (Object)e);
                    return Optional.empty();
                }
            }
            LOGGER.warn("Expected to find loot table {} at {} but it was a folder.", (Object)resource, (Object)lootTableFile);
            return Optional.empty();
        }
        LOGGER.warn("Expected to find loot table {} at {} but it doesn't exist.", (Object)resource, (Object)lootTableFile);
        return Optional.empty();
    }

    public List<ItemStack> getInjectedLootItems(World world, Random random, List<LootTableShell> list, LootContext lootContext) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (LootTableShell injectLootTableShell : list) {
            GottschCore.logger.debug("injectable resource -> {}", (Object)injectLootTableShell.getResourceLocation());
            LootTable injectLootTable = world.func_184146_ak().func_186521_a(injectLootTableShell.getResourceLocation());
            if (injectLootTable == null) continue;
            itemStacks.addAll(injectLootTable.func_186462_a(random, lootContext));
            GottschCore.logger.debug("size of item stacks after inject -> {}", (Object)itemStacks.size());
        }
        return itemStacks;
    }

    public File getWorldDataBaseFolder() {
        return this.worldDataBaseFolder;
    }

    public void setWorldDataBaseFolder(File baseFolder) {
        this.worldDataBaseFolder = baseFolder;
    }

    @Override
    public IMod getMod() {
        return this.mod;
    }

    public Gson getGsonInstance() {
        return GSON_INSTANCE;
    }

    public LootContext getContext() {
        return this.context;
    }

    public void setContext(LootContext context) {
        this.context = context;
    }
}

