/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.loot.LootContext;
import com.someguyssoftware.gottschcore.loot.LootPool;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;

@Deprecated
public class LootTable {
    public static final LootTable EMPTY_LOOT_TABLE = new LootTable(new LootPool[0]);
    private final List<LootPool> pools;
    private String version;
    private boolean isFrozen = false;

    public LootTable(LootPool[] poolsIn) {
        this.pools = Lists.newArrayList((Object[])poolsIn);
    }

    public List<ItemStack> generateLootFromPools(Random rand, LootContext context) {
        ArrayList list = Lists.newArrayList();
        if (context.addLootTable(this)) {
            for (LootPool lootpool : this.pools) {
                lootpool.generateLoot(list, rand, context);
            }
            context.removeLootTable(this);
        } else {
            GottschCore.logger.warn("Detected infinite loop in loot tables");
        }
        return list;
    }

    public void fillInventory(IInventory inventory, Random rand, LootContext context) {
        List<ItemStack> list = this.generateLootFromPools(rand, context);
        List<Integer> list1 = this.getEmptySlotsRandomized(inventory, rand);
        this.shuffleItems(list, list1.size(), rand);
        for (ItemStack itemstack : list) {
            if (list1.isEmpty()) {
                GottschCore.logger.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.func_190926_b()) {
                inventory.func_70299_a(list1.remove(list1.size() - 1).intValue(), ItemStack.field_190927_a);
                continue;
            }
            inventory.func_70299_a(list1.remove(list1.size() - 1).intValue(), itemstack);
        }
    }

    private void shuffleItems(List<ItemStack> stacks, int emptySlotsSize, Random rand) {
        Collections.shuffle(stacks, rand);
    }

    private List<Integer> getEmptySlotsRandomized(IInventory inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public void freeze() {
        this.isFrozen = true;
        for (LootPool pool : this.pools) {
            pool.freeze();
        }
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify TreasureLootTable after being finalized!");
        }
    }

    public LootPool getPool(String name) {
        for (LootPool pool : this.pools) {
            if (!name.equals(pool.getName())) continue;
            return pool;
        }
        return null;
    }

    public LootPool removePool(String name) {
        this.checkFrozen();
        for (LootPool pool : this.pools) {
            if (!name.equals(pool.getName())) continue;
            this.pools.remove(pool);
            return pool;
        }
        return null;
    }

    public void addPool(LootPool pool) {
        this.checkFrozen();
        for (LootPool p : this.pools) {
            if (p != pool && !p.getName().equals(pool.getName())) continue;
            throw new RuntimeException("Attempted to add a duplicate pool to loot table: " + pool.getName());
        }
        this.pools.add(pool);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static class Serializer
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)element, (String)"loot table");
            String version = "";
            try {
                version = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"version");
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            LootPool[] alootpool = (LootPool[])JsonUtils.func_188177_a((JsonObject)jsonobject, (String)"pools", (Object)new LootPool[0], (JsonDeserializationContext)context, LootPool[].class);
            LootTable lootTable = new LootTable(alootpool);
            lootTable.setVersion(version);
            return lootTable;
        }

        public JsonElement serialize(LootTable p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("pools", p_serialize_3_.serialize((Object)p_serialize_1_.pools));
            return jsonobject;
        }
    }
}

