/*
 * Decompiled with CFR 0.152.
 */
package ghostgaming.explosivesmod.objects.explosions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.BlockGlazedTerracotta;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosionPaintingTNT {
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<EntityPlayer, Vec3d> playerKnockbackMap = Maps.newHashMap();
    private final Random random = new Random();
    private Explosion explosion;
    private final Entity exploder;
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final Vec3d position;
    private final float size;
    private final int smoothness;
    private final boolean damagesTerrain;
    private final boolean dropsBlocks;
    private final boolean hurtsEntities;
    private final boolean hurtsPlayers;

    public ExplosionPaintingTNT(World world, Entity entity, double x, double y, double z, float size, int smoothness, boolean damagesTerrain, boolean dropsBlocks, boolean hurtsEntities, boolean hurtsPlayers) {
        this.exploder = entity;
        this.explosion = new Explosion(world, entity, x, y, z, size, false, damagesTerrain);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.position = new Vec3d(this.x, this.y, this.z);
        this.size = size;
        this.smoothness = smoothness;
        this.damagesTerrain = damagesTerrain;
        this.dropsBlocks = dropsBlocks;
        this.hurtsEntities = hurtsEntities;
        this.hurtsPlayers = hurtsPlayers;
    }

    public void doExplosionA() {
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < this.smoothness; ++j) {
            for (int k = 0; k < this.smoothness; ++k) {
                for (int l = 0; l < this.smoothness; ++l) {
                    if (j != 0 && j != this.smoothness - 1 && k != 0 && k != this.smoothness - 1 && l != 0 && l != this.smoothness - 1) continue;
                    double d0 = (float)j / (float)(this.smoothness - 1) * 2.0f - 1.0f;
                    double d1 = (float)k / (float)(this.smoothness - 1) * 2.0f - 1.0f;
                    double d2 = (float)l / (float)(this.smoothness - 1) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double posX = this.x;
                    double posY = this.y;
                    double posZ = this.z;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockPos = new BlockPos(posX, posY, posZ);
                        IBlockState state = this.world.func_180495_p(blockPos);
                        if (state.func_185904_a() != Material.field_151579_a) {
                            float explosionResistance = this.exploder != null ? this.exploder.func_180428_a(this.explosion, this.world, blockPos, state) : state.func_177230_c().getExplosionResistance(this.world, blockPos, (Entity)null, this.explosion);
                            f -= (explosionResistance + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a(this.explosion, this.world, blockPos, state, f))) {
                            set.add(blockPos);
                        }
                        posX += d0 * (double)0.3f;
                        posY += d1 * (double)0.3f;
                        posZ += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float damageRadius = this.size * 2.0f;
        int fromX = MathHelper.func_76128_c((double)(this.x - (double)damageRadius - 1.0));
        int toX = MathHelper.func_76128_c((double)(this.x + (double)damageRadius + 1.0));
        int fromY = MathHelper.func_76128_c((double)(this.y - (double)damageRadius - 1.0));
        int toY = MathHelper.func_76128_c((double)(this.y + (double)damageRadius + 1.0));
        int fromZ = MathHelper.func_76128_c((double)(this.z - (double)damageRadius - 1.0));
        int toZ = MathHelper.func_76128_c((double)(this.z + (double)damageRadius + 1.0));
        List entitiesInExplosionRadius = this.world.func_72839_b(this.exploder, new AxisAlignedBB((double)fromX, (double)fromY, (double)fromZ, (double)toX, (double)toY, (double)toZ));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this.explosion, (List)entitiesInExplosionRadius, (double)damageRadius);
        for (int i = 0; i < entitiesInExplosionRadius.size(); ++i) {
            EntityPlayer entityplayer;
            double distanceZ;
            double distanceY;
            double distanceX;
            double distanceFromCenter;
            double distanceFromCenterRelativeToRadius;
            Entity entity = (Entity)entitiesInExplosionRadius.get(i);
            if (entity.func_180427_aV() || !((distanceFromCenterRelativeToRadius = entity.func_70011_f(this.x, this.y, this.z) / (double)damageRadius) <= 1.0) || (distanceFromCenter = (double)MathHelper.func_76133_a((double)((distanceX = entity.field_70165_t - this.x) * distanceX + (distanceY = entity.field_70163_u + (double)entity.func_70047_e() - this.y) * distanceY + (distanceZ = entity.field_70161_v - this.z) * distanceZ))) == 0.0) continue;
            distanceX /= distanceFromCenter;
            distanceY /= distanceFromCenter;
            distanceZ /= distanceFromCenter;
            double blockDensityAtPosition = this.world.func_72842_a(this.position, entity.func_174813_aQ());
            double damage = (1.0 - distanceFromCenterRelativeToRadius) * blockDensityAtPosition;
            if (!(entity instanceof EntityPlayer) && this.hurtsEntities || entity instanceof EntityPlayer && this.hurtsPlayers) {
                entity.func_70097_a(DamageSource.func_94539_a((Explosion)this.explosion), (float)((int)((damage * damage + damage) / 2.0 * ((double)this.size * 2.0 - 1.0) * (double)damageRadius + 1.0)));
            }
            double blastDamageReduction = damage;
            if (entity instanceof EntityLivingBase) {
                blastDamageReduction = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)damage);
            }
            entity.field_70159_w += distanceX * blastDamageReduction;
            entity.field_70181_x += distanceY * blastDamageReduction;
            entity.field_70179_y += distanceZ * blastDamageReduction;
            if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
            this.playerKnockbackMap.put(entityplayer, new Vec3d(distanceX * damage, distanceY * damage, distanceZ * damage));
        }
    }

    public void doExplosionB(boolean spawnParticles) {
        this.world.func_184148_a((EntityPlayer)null, this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.size >= 2.0f && this.damagesTerrain) {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
        }
        if (this.damagesTerrain) {
            for (BlockPos blockPos : this.affectedBlockPositions) {
                TileEntityShulkerBox tileEntity;
                IBlockState state = this.world.func_180495_p(blockPos);
                Block block = state.func_177230_c();
                if (spawnParticles) {
                    double d0 = (float)blockPos.func_177958_n() + this.world.field_73012_v.nextFloat();
                    double d1 = (float)blockPos.func_177956_o() + this.world.field_73012_v.nextFloat();
                    double d2 = (float)blockPos.func_177952_p() + this.world.field_73012_v.nextFloat();
                    double d3 = d0 - this.x;
                    double d4 = d1 - this.y;
                    double d5 = d2 - this.z;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.size + 0.1);
                    this.world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.x) / 2.0, (d1 + this.y) / 2.0, (d2 + this.z) / 2.0, d3 *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                    this.world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
                }
                if (block instanceof BlockColored || block instanceof BlockStainedGlass || block instanceof BlockStainedGlassPane || block instanceof BlockConcretePowder || block instanceof BlockCarpet) {
                    this.world.func_175656_a(blockPos, state.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.func_176764_b((int)this.random.nextInt(16))));
                    continue;
                }
                if (block instanceof BlockBed) {
                    TileEntity tileEntity2 = this.world.func_175625_s(blockPos);
                    EnumDyeColor color = EnumDyeColor.func_176764_b((int)this.random.nextInt(16));
                    if (tileEntity2 instanceof TileEntityBed) {
                        ((TileEntityBed)tileEntity2).func_193052_a(color);
                        this.world.func_184138_a(blockPos, state, state, 3);
                    }
                    if (this.world.func_180495_p(blockPos = state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT ? blockPos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D)) : blockPos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D)).func_176734_d())).func_177230_c() != Blocks.field_150324_C || !((tileEntity2 = this.world.func_175625_s(blockPos)) instanceof TileEntityBed)) continue;
                    ((TileEntityBed)tileEntity2).func_193052_a(color);
                    this.world.func_184138_a(blockPos, state, state, 3);
                    continue;
                }
                if (block instanceof BlockGlazedTerracotta) {
                    this.world.func_175656_a(blockPos, this.getRandomGlazedTerracotta());
                    continue;
                }
                if (!(block instanceof BlockShulkerBox) || (tileEntity = (TileEntityShulkerBox)this.world.func_175625_s(blockPos)) == null) continue;
                ItemStack[] inventory = new ItemStack[tileEntity.func_70302_i_()];
                for (int i = 0; i < tileEntity.func_70302_i_(); ++i) {
                    inventory[i] = tileEntity.func_70301_a(i);
                }
                tileEntity.func_174888_l();
                this.world.func_175656_a(blockPos, this.getRandomShulkerBox());
                TileEntityShulkerBox tileEntityNew = (TileEntityShulkerBox)this.world.func_175625_s(blockPos);
                if (tileEntityNew == null) continue;
                for (int i = 0; i < tileEntityNew.func_70302_i_(); ++i) {
                    tileEntityNew.func_70299_a(i, inventory[i]);
                }
            }
        }
    }

    public Map<EntityPlayer, Vec3d> getPlayerKnockbackMap() {
        return this.playerKnockbackMap;
    }

    @Nullable
    public EntityLivingBase getExplosivePlacedBy() {
        if (this.exploder == null) {
            return null;
        }
        if (this.exploder instanceof EntityTNTPrimed) {
            return ((EntityTNTPrimed)this.exploder).func_94083_c();
        }
        return this.exploder instanceof EntityLivingBase ? (EntityLivingBase)this.exploder : null;
    }

    public void clearAffectedBlockPositions() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> getAffectedBlockPositions() {
        return this.affectedBlockPositions;
    }

    public Vec3d getPosition() {
        return this.position;
    }

    private IBlockState getRandomGlazedTerracotta() {
        ArrayList terracotta = Lists.newArrayList();
        terracotta.add(Blocks.field_192442_dQ);
        terracotta.add(Blocks.field_192438_dM);
        terracotta.add(Blocks.field_192439_dN);
        terracotta.add(Blocks.field_192436_dK);
        terracotta.add(Blocks.field_192434_dI);
        terracotta.add(Blocks.field_192440_dO);
        terracotta.add(Blocks.field_192430_dE);
        terracotta.add(Blocks.field_192432_dG);
        terracotta.add(Blocks.field_192429_dD);
        terracotta.add(Blocks.field_192428_dC);
        terracotta.add(Blocks.field_192433_dH);
        terracotta.add(Blocks.field_192437_dL);
        terracotta.add(Blocks.field_192441_dP);
        terracotta.add(Blocks.field_192435_dJ);
        terracotta.add(Blocks.field_192427_dB);
        terracotta.add(Blocks.field_192431_dF);
        return ((Block)terracotta.get(this.random.nextInt(terracotta.size()))).func_176223_P();
    }

    private IBlockState getRandomShulkerBox() {
        ArrayList shulkerBoxes = Lists.newArrayList();
        shulkerBoxes.add(Blocks.field_190975_dA);
        shulkerBoxes.add(Blocks.field_190988_dw);
        shulkerBoxes.add(Blocks.field_190989_dx);
        shulkerBoxes.add(Blocks.field_190986_du);
        shulkerBoxes.add(Blocks.field_190984_ds);
        shulkerBoxes.add(Blocks.field_190990_dy);
        shulkerBoxes.add(Blocks.field_190980_do);
        shulkerBoxes.add(Blocks.field_190982_dq);
        shulkerBoxes.add(Blocks.field_190979_dn);
        shulkerBoxes.add(Blocks.field_190978_dm);
        shulkerBoxes.add(Blocks.field_190983_dr);
        shulkerBoxes.add(Blocks.field_190987_dv);
        shulkerBoxes.add(Blocks.field_190991_dz);
        shulkerBoxes.add(Blocks.field_190985_dt);
        shulkerBoxes.add(Blocks.field_190977_dl);
        shulkerBoxes.add(Blocks.field_190981_dp);
        return ((Block)shulkerBoxes.get(this.random.nextInt(shulkerBoxes.size()))).func_176223_P();
    }
}

