/*
 * Decompiled with CFR 0.152.
 */
package ghostgaming.explosivesmod.objects.entities;

import ghostgaming.explosivesmod.objects.blocks.BlockTNTGhostsExplosives;
import ghostgaming.explosivesmod.objects.explosions.ExplosionGhostsExplosives;
import ghostgaming.explosivesmod.util.config.ConfigBlockTNT;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public abstract class EntityTNTGhostsExplosives
extends Entity {
    public static DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(EntityTNTGhostsExplosives.class, (DataSerializer)DataSerializers.field_187192_b);
    @Nullable
    public EntityLivingBase tntPlacedBy;
    public int fuse;
    public static int fuseLength;
    public BlockTNTGhostsExplosives tntBlock;

    public EntityTNTGhostsExplosives(World world) {
        super(world);
        this.fuse = this.getConfig().FUSE;
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.func_70105_a(0.98f, 0.98f);
    }

    public EntityTNTGhostsExplosives(World world, double x, double y, double z, EntityLivingBase igniter, BlockTNTGhostsExplosives block) {
        this(world);
        this.func_70107_b(x, y, z);
        float f = (float)(Math.random() * (Math.PI * 2));
        this.field_70159_w = -((float)Math.sin(f)) * 0.02f;
        this.field_70181_x = 0.2f;
        this.field_70179_y = -((float)Math.cos(f)) * 0.02f;
        fuseLength = block.getConfig().FUSE;
        this.setFuse(fuseLength);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.tntPlacedBy = igniter;
        this.tntBlock = block;
    }

    public abstract DataParameter<Integer> getFuseDataParameter();

    public float func_70047_e() {
        return 0.0f;
    }

    public boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        this.setMotion();
        --this.fuse;
        if (this.fuse <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.explode();
            }
        } else {
            this.func_70072_I();
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected void setMotion() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
            this.field_70181_x *= -0.5;
        }
    }

    @Nullable
    public EntityLivingBase getTntPlacedBy() {
        return this.tntPlacedBy;
    }

    public BlockTNTGhostsExplosives getDefusedBlock() {
        return this.tntBlock;
    }

    public boolean canDestroyBlock(Block block, World world, BlockPos pos, Explosion explosion) {
        return block.func_176195_g(world.func_180495_p(pos), world, pos) >= 0.0f && block.getExplosionResistance(world, pos, (Entity)explosion.func_94613_c(), explosion) < 10000.0f && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI && block != Blocks.field_185776_dc && block != Blocks.field_185777_dd && block != Blocks.field_180401_cv && block != Blocks.field_185779_df && block != Blocks.field_189881_dj && block != Blocks.field_180384_M && block != Blocks.field_185775_db;
    }

    public float func_180428_a(Explosion explosion, World world, BlockPos pos, IBlockState blockState) {
        float explosionResistance = super.func_180428_a(explosion, world, pos, blockState);
        Block block = blockState.func_177230_c();
        if (this.canDestroyBlock(block, world, pos, explosion)) {
            explosionResistance = Math.min(this.getConfig().EXPLOSION_RESISTANCE, explosionResistance);
        }
        return explosionResistance + this.field_70146_Z.nextFloat();
    }

    public void explode() {
        ConfigBlockTNT config = this.getConfig();
        ExplosionGhostsExplosives explosion = new ExplosionGhostsExplosives(this.field_70170_p, this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, config.EXPLOSION_STRENGTH, config.EXPLOSION_SMOOTHNESS, false, config.DAMAGES_TERRAIN, config.DROP_BLOCKS, config.HURT_ENTITIES, config.HURT_PLAYERS);
        explosion.doExplosionA();
        explosion.doExplosionB(true);
    }

    public void setFuse(int fuse) {
        this.field_70180_af.func_187227_b(this.getFuseDataParameter(), (Object)fuse);
        this.fuse = fuse;
    }

    public int getFuse() {
        return this.fuse;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Fuse", (short)this.getFuse());
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setFuse(compound.func_74765_d("Fuse"));
    }

    public void func_184206_a(DataParameter<?> key) {
        if (this.getFuseDataParameter().equals(key)) {
            this.fuse = this.getFuseDataManager();
        }
    }

    public int getFuseDataManager() {
        return (Integer)this.field_70180_af.func_187225_a(this.getFuseDataParameter());
    }

    public abstract ConfigBlockTNT getConfig();

    public static Class[] getTNTConstructor() {
        Class[] constructor = new Class[]{World.class, Double.TYPE, Double.TYPE, Double.TYPE, EntityLivingBase.class, BlockTNTGhostsExplosives.class};
        return constructor;
    }
}

