/*
 * Decompiled with CFR 0.152.
 */
package ghostgaming.explosivesmod.objects.blocks.tileentities;

import ghostgaming.explosivesmod.GhostsExplosives;
import ghostgaming.explosivesmod.init.BlockInit;
import ghostgaming.explosivesmod.network.PacketRequestUpdateLandmine;
import ghostgaming.explosivesmod.objects.explosions.ExplosionGhostsExplosives;
import ghostgaming.explosivesmod.util.config.ConfigBlockLandmine;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityLandmine
extends TileEntity
implements ITickable {
    private final Block defaultCamoBlock = BlockInit.EXPLOSIVE_LANDMINE;
    private final int defaultCamoBlockData = 0;
    private Block camoBlock = this.defaultCamoBlock;
    private int camoBlockData = 0;
    private boolean active = false;
    public ConfigBlockLandmine config;

    public TileEntityLandmine() {
        this.camoBlock = this.defaultCamoBlock;
        this.camoBlockData = 0;
        this.config = BlockInit.EXPLOSIVE_LANDMINE.getConfig();
    }

    public TileEntityLandmine(Block block, int blockData, ConfigBlockLandmine config) {
        this.camoBlock = block;
        this.camoBlockData = blockData;
        this.config = config;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.camoBlock);
        compound.func_74778_a("Block", resourcelocation == null ? "" : resourcelocation.toString());
        compound.func_74768_a("Data", this.camoBlockData);
        compound.func_74757_a("Active", this.active);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.camoBlock = compound.func_150297_b("Block", 8) ? Block.func_149684_b((String)compound.func_74779_i("Block")) : Block.func_149729_e((int)compound.func_74762_e("Block"));
        this.camoBlockData = compound.func_74762_e("Data");
        this.active = compound.func_74767_n("Active");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 5, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            GhostsExplosives.network.sendToServer((IMessage)new PacketRequestUpdateLandmine(this));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isActive() && this.field_145850_b.func_72855_b(new AxisAlignedBB(this.field_174879_c.func_177984_a()))) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
            this.explode(this.field_145850_b);
        }
    }

    public void setDefaultBlock() {
        this.camoBlock = this.defaultCamoBlock;
        this.camoBlockData = 0;
        this.func_70296_d();
    }

    public void setBlockFromItemStack(ItemStack itemStack) {
        if (Block.func_149634_a((Item)itemStack.func_77973_b()) == Blocks.field_150350_a) {
            this.camoBlock = this.defaultCamoBlock;
            this.camoBlockData = 0;
        } else {
            this.camoBlock = Block.func_149634_a((Item)itemStack.func_77973_b());
            this.camoBlockData = itemStack.func_77960_j();
        }
        this.func_70296_d();
    }

    @Nullable
    public Block getBlock() {
        return this.camoBlock;
    }

    public int getBlockData() {
        return this.camoBlockData;
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.camoBlock, 1, this.camoBlockData);
    }

    public void setActive(boolean active) {
        this.active = active;
        this.func_70296_d();
    }

    public boolean isActive() {
        return this.active;
    }

    public void explode(World world) {
        if (!world.field_72995_K) {
            ExplosionGhostsExplosives explosion = new ExplosionGhostsExplosives(this.field_145850_b, null, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.config.EXPLOSION_STRENGTH, 16, false, this.config.DAMAGES_TERRAIN, this.config.DROP_BLOCKS, this.config.HURT_ENTITIES, this.config.HURT_PLAYERS);
            explosion.doExplosionA();
            explosion.doExplosionB(true);
        }
    }

    public static TileEntityLandmine getLandmineAt(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        return tileEntity instanceof TileEntityLandmine ? (TileEntityLandmine)tileEntity : null;
    }

    public final ConfigBlockLandmine getConfig() {
        return this.config;
    }

    public final void updateConfig(ConfigBlockLandmine config) {
        this.config = config;
    }
}

