/*
 * Decompiled with CFR 0.152.
 */
package ghostgaming.explosivesmod.objects.blocks;

import ghostgaming.explosivesmod.GhostsExplosives;
import ghostgaming.explosivesmod.init.EntityInit;
import ghostgaming.explosivesmod.init.ItemInit;
import ghostgaming.explosivesmod.objects.blocks.BlockGhostsExplosives;
import ghostgaming.explosivesmod.objects.entities.EntityTNTGhostsExplosives;
import ghostgaming.explosivesmod.util.config.ConfigBlockTNT;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockTNTGhostsExplosives<TNTEntity extends EntityTNTGhostsExplosives>
extends BlockGhostsExplosives {
    public static final PropertyBool EXPLODE = PropertyBool.func_177716_a((String)"explode");
    protected Class<? extends EntityTNTGhostsExplosives> entityTNTClass;
    protected ConfigBlockTNT config;

    public BlockTNTGhostsExplosives(String name, Class<? extends EntityTNTGhostsExplosives> entityTNTClass, ConfigBlockTNT config) {
        super(name, Material.field_151590_u);
        this.func_149647_a(GhostsExplosives.explosivesModTab_TNT);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.valueOf(false)));
        EntityInit.registerTNTEntity(name, entityTNTClass);
        this.entityTNTClass = entityTNTClass;
        this.config = config;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (this.isActivatedByRedstone() && world.func_175640_z(pos)) {
            this.func_176206_d(world, pos, state.func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.valueOf(true)));
            world.func_175698_g(pos);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this.isActivatedByRedstone() && world.func_175640_z(pos)) {
            this.func_176206_d(world, pos, state.func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.valueOf(true)));
            world.func_175698_g(pos);
        }
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K && this.isActivatedByExplosions()) {
            this.explode(world, pos, this.func_176223_P().func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.valueOf(true)), explosion.func_94613_c(), world.field_73012_v.nextInt(this.config.FUSE / 4) + this.config.FUSE / 8);
        }
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        this.explode(world, pos, state, null, -1);
    }

    public void explode(World world, BlockPos pos, IBlockState state, EntityLivingBase igniter) {
        this.explode(world, pos, state, igniter, -1);
    }

    public void explode(World world, BlockPos pos, IBlockState state, EntityLivingBase igniter, int fuse) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)EXPLODE)).booleanValue()) {
            EntityTNTGhostsExplosives entitytntprimed = this.getTNTEntity(world, (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, igniter, this);
            if (entitytntprimed == null) {
                return;
            }
            if (fuse >= 0) {
                entitytntprimed.setFuse((short)fuse);
            }
            world.func_72838_d((Entity)entitytntprimed);
            world.func_184148_a((EntityPlayer)null, entitytntprimed.field_70165_t, entitytntprimed.field_70163_u, entitytntprimed.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.isActivatedByFlintAndSteel() && !itemStack.func_190926_b() && (itemStack.func_77973_b() == Items.field_151033_d || itemStack.func_77973_b() == Items.field_151059_bz || itemStack.func_77973_b() == ItemInit.INSTANT_FLINT_AND_STEEL)) {
            this.explode(world, pos, state.func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.valueOf(true)), (EntityLivingBase)player, itemStack.func_77973_b() == ItemInit.INSTANT_FLINT_AND_STEEL ? 0 : -1);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            if (itemStack.func_77973_b() == Items.field_151033_d || itemStack.func_77973_b() == ItemInit.INSTANT_FLINT_AND_STEEL) {
                itemStack.func_77972_a(1, (EntityLivingBase)player);
            } else if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        EntityArrow entityarrow;
        if (!world.field_72995_K && this.isActivatedByBurningArrows() && entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).func_70027_ad()) {
            this.explode(world, pos, world.func_180495_p(pos).func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.valueOf(true)), entityarrow.field_70250_c instanceof EntityLivingBase ? (EntityLivingBase)entityarrow.field_70250_c : null);
            world.func_175698_g(pos);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.valueOf((meta & 1) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)EXPLODE) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EXPLODE});
    }

    public final EntityTNTGhostsExplosives getTNTEntity(World world, double x, double y, double z, EntityLivingBase igniter, BlockTNTGhostsExplosives block) {
        try {
            return this.entityTNTClass.getDeclaredConstructor(EntityTNTGhostsExplosives.getTNTConstructor()).newInstance(world, x, y, z, igniter, this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.out.println("Couldn't instantiate TNT Entity: " + e);
            e.printStackTrace();
            return null;
        }
    }

    protected final boolean isActivatedByFlintAndSteel() {
        return this.config.FLINT_AND_STEEL;
    }

    protected final boolean isActivatedByRedstone() {
        return this.config.REDSTONE;
    }

    protected final boolean isActivatedByExplosions() {
        return this.config.EXPLOSIONS;
    }

    protected final boolean isActivatedByBurningArrows() {
        return this.config.ARROWS;
    }

    public final ConfigBlockTNT getConfig() {
        return this.config;
    }

    public final void updateConfig(ConfigBlockTNT config) {
        this.config = config;
    }
}

