/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.iceologer.entity.Entity;

import com.unoriginal.iceologer.config.ModConfig;
import com.unoriginal.iceologer.init.ModSounds;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityIceCube
extends Entity {
    private int floatTicks = ModConfig.iceCubeFloatTicks;
    public int fallTime = 0;
    private float fallHurtAmount = ModConfig.iceCubeDamage;
    private EntityLivingBase caster;
    private UUID casterUuid;
    private EntityLivingBase target;
    private UUID targetUUID;
    private double heightAboveTarget = 3.0;
    private double heightAdjustment = (1.0f - this.field_70131_O) / 2.0f;

    public EntityIceCube(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.0f, 1.5f);
    }

    public EntityIceCube(World worldIn, EntityLivingBase casterIn, EntityLivingBase targetIn) {
        this(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(2.0f, 1.5f);
        this.setCaster(casterIn);
        this.setTarget(targetIn);
        this.func_70107_b(targetIn.field_70165_t, targetIn.field_70163_u + 1.0 + this.heightAboveTarget + this.heightAdjustment, targetIn.field_70161_v);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = targetIn.field_70165_t;
        this.field_70167_r = targetIn.field_70163_u + 1.0 + this.heightAboveTarget + this.heightAdjustment;
        this.field_70166_s = targetIn.field_70161_v;
    }

    protected void func_70088_a() {
    }

    private void tryToFloatAboveTarget(EntityLivingBase targetIn) {
        List nearbyIceClouds = this.field_70170_p.func_175647_a(EntityIceCube.class, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2), nearbyEntity -> nearbyEntity != this);
        if (nearbyIceClouds.isEmpty()) {
            this.func_70107_b(targetIn.field_70165_t, targetIn.field_70163_u + 1.0 + this.heightAboveTarget + this.heightAdjustment, targetIn.field_70161_v);
        }
    }

    public void setCaster(@Nullable EntityLivingBase caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.func_110124_au();
    }

    @Nullable
    public EntityLivingBase getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.casterUuid)) instanceof EntityLivingBase) {
            this.caster = (EntityLivingBase)entity;
        }
        return this.caster;
    }

    public void setTarget(@Nullable EntityLivingBase target) {
        this.target = target;
        this.targetUUID = target == null ? null : target.func_110124_au();
    }

    @Nullable
    public EntityLivingBase getTarget() {
        Entity entity;
        if (this.target == null && this.targetUUID != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.targetUUID)) instanceof EntityLiving) {
            this.target = (EntityLiving)entity;
        }
        return this.caster;
    }

    public void func_70071_h_() {
        if (this.floatTicks == 20) {
            this.func_184185_a(ModSounds.ICE_CUBE_AMBIENT, 1.0f, 1.0f);
        }
        if (this.floatTicks > 0) {
            --this.floatTicks;
            if (this.target != null && !this.field_70170_p.field_72995_K) {
                this.tryToFloatAboveTarget(this.target);
            }
        } else {
            if (this.fallTime < 0 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
            ++this.fallTime;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= 0.32;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (!this.field_70170_p.field_72995_K) {
                BlockPos iceCloudPosition = this.func_180425_c();
                if (!this.field_70122_E) {
                    if (!(this.field_70170_p.field_72995_K || (this.fallTime <= 100 || iceCloudPosition.func_177956_o() >= 1 && iceCloudPosition.func_177956_o() <= 256) && this.fallTime <= 600)) {
                        this.func_70106_y();
                    }
                } else {
                    IBlockState blockstate = this.field_70170_p.func_180495_p(iceCloudPosition);
                    this.field_70159_w *= 0.7;
                    this.field_70179_y *= 0.7;
                    this.field_70181_x *= -0.5;
                    if (blockstate.func_177230_c() != Blocks.field_180384_M) {
                        this.spawnIceExplosionCloud();
                        this.func_70106_y();
                    }
                }
            }
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int distanceFallen = MathHelper.func_76123_f((float)(distance - 1.0f));
        if (distanceFallen > 0) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
            for (Entity entity : list) {
                if (!(entity instanceof EntityLivingBase)) continue;
                EntityLivingBase livingEntity = (EntityLivingBase)entity;
                this.damage(livingEntity, distanceFallen);
            }
        }
    }

    public void spawnIceExplosionCloud() {
        EntityAreaEffectCloud areaeffectcloudentity = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        areaeffectcloudentity.func_184491_a(EnumParticleTypes.EXPLOSION_HUGE);
        areaeffectcloudentity.func_184483_a(3.0f);
        areaeffectcloudentity.func_184486_b(0);
        this.func_184185_a(ModSounds.ICE_CUBE_HIT, 1.0f, 1.0f);
        this.field_70170_p.func_72838_d((Entity)areaeffectcloudentity);
    }

    private void damage(EntityLivingBase targetEntity, int distanceFallen) {
        EntityLivingBase caster = this.getCaster();
        float damageAmount = MathHelper.func_76141_d((float)((float)distanceFallen * this.fallHurtAmount));
        if (targetEntity.func_70089_S() && !targetEntity.func_190530_aW() && targetEntity != caster) {
            if (caster == null) {
                targetEntity.func_70097_a(DamageSource.field_76376_m, damageAmount);
                targetEntity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100, 4));
                targetEntity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 4));
            } else {
                if (caster.func_184191_r((Entity)targetEntity)) {
                    return;
                }
                targetEntity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.caster), damageAmount);
                targetEntity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100, 4));
                targetEntity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 4));
            }
        }
    }

    public boolean func_70075_an() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.fallTime = compound.func_74762_e("time");
        this.fallHurtAmount = compound.func_74760_g("fallDamageAmount");
        this.setFloatTicks(compound.func_74762_e("floatTicks"));
        if (compound.func_186855_b("owner")) {
            this.casterUuid = compound.func_186857_a("owner");
        }
        if (compound.func_186855_b("target")) {
            this.targetUUID = compound.func_186857_a("target");
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("time", this.fallTime);
        compound.func_74776_a("fallDamageAmount", this.fallHurtAmount);
        compound.func_74768_a("floatTicks", this.getFloatTicks());
        if (this.casterUuid != null) {
            compound.func_186854_a("owner", this.casterUuid);
        }
        if (this.targetUUID != null) {
            compound.func_186854_a("target", this.targetUUID);
        }
    }

    public int getFloatTicks() {
        return this.floatTicks;
    }

    public void setFloatTicks(int floatTicksIn) {
        this.floatTicks = floatTicksIn;
    }

    public boolean func_90999_ad() {
        return false;
    }
}

