/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonCollect;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Dimensions
extends Enum<Dimensions> {
    public static final /* enum */ Dimensions nether = new Dimensions(-1, "netherrack");
    public static final /* enum */ Dimensions overworld = new Dimensions(0, "stone:*");
    public static final /* enum */ Dimensions end = new Dimensions(1, "end_stone");
    public final int ID;
    public final UnitId replaceableBlockId;
    public static final String DIM_LIST_SYNTAX = "Dimension is specified by its ID [-1 - Nether, 0 - Overworld, 1 - The End, etc.]\nEach ID must be on a separate line without any delimiters.\nIf the whitelist is set, the blacklist will be ignored.";
    private static final /* synthetic */ Dimensions[] $VALUES;

    public static Dimensions[] values() {
        return (Dimensions[])$VALUES.clone();
    }

    public static Dimensions valueOf(String name) {
        return Enum.valueOf(Dimensions.class, name);
    }

    private Dimensions(int dimensionId, String replaceableBlockId) {
        this.ID = dimensionId;
        this.replaceableBlockId = UnitId.from(replaceableBlockId);
        assert (replaceableBlockId != null);
    }

    public static CommonCollect.BlackWhiteList<Integer> from(ForgeConfig config, String category, String comment) {
        category = IHaveConfig.expandClassCategory(Dimensions.class, category);
        if (config != null) {
            config.setCategoryComment(category, comment + "\n" + DIM_LIST_SYNTAX);
        }
        List<Integer> black = Dimensions.readFrom(config, category, "blackList", "");
        List<Integer> white = Dimensions.readFrom(config, category, "whiteList", "");
        return new CommonCollect.BlackWhiteList<Integer>(black, white);
    }

    public static List<Integer> readFrom(ForgeConfig config, String category, String key, String comment) {
        if (config == null) {
            return Collections.emptyList();
        }
        String[] strArray = config.getStrArray(category, key, new String[0], comment);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String str : strArray) {
            if ((str = str.trim()).isEmpty()) continue;
            try {
                Integer dim = Integer.valueOf(str);
                list.add(dim);
            }
            catch (Exception e) {
                ForgeMain.instance.getLogger().error("Parsing dimension list from " + (Object)((Object)config), (Throwable)e);
            }
        }
        return list;
    }

    static {
        $VALUES = new Dimensions[]{nether, overworld, end};
    }
}

