/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.Names;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public class ForgeEnergyStorage
extends EnergyStorage
implements INBTSerializable<NBTTagCompound> {
    protected static final String TAG_NAME = "ForgeEnergy";

    public ForgeEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public static ForgeEnergyStorage of(int capacity, int energy) {
        return new ForgeEnergyStorage(capacity, capacity, capacity, energy);
    }

    public static ForgeEnergyStorage of(int capacity) {
        return ForgeEnergyStorage.of(capacity, 0);
    }

    public boolean hasEnoughEnergy(int use) {
        return this.extractEnergy(use, true) == use;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("capacity", this.getMaxEnergyStored());
        compound.func_74768_a("energy", this.getEnergyStored());
        return compound;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.maxExtract = this.capacity = tag.func_74762_e("capacity");
        this.maxReceive = this.capacity;
        this.energy = IntBounds.from(0, this.capacity).enclose(tag.func_74762_e("energy"));
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b(TAG_NAME)) {
            this.deserializeNBT(compound.func_74775_l(TAG_NAME));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a(TAG_NAME, (NBTBase)this.serializeNBT());
        return compound;
    }

    public static class Properties {
        public static final Properties EMPTY = new Properties(null, "", false, 0, 0);
        public final boolean enabled;
        public final int capacity;
        public final int consumption;

        public Properties(UnitConfig config, String headCategory, boolean enabled, int capacity, int consumption) {
            String category = Names.dotted().join(headCategory, ForgeEnergyStorage.TAG_NAME);
            this.enabled = UnitConfig.getBool(config, category, "enabled", enabled, "Whether Forge Energy is required or not");
            this.capacity = UnitConfig.getInt(config, category, "capacity", capacity, IntBounds.from(0, 100000), "Maximum amount of energy that can be held");
            this.consumption = UnitConfig.getInt(config, category, "consumption", consumption, IntBounds.from(0, 1000), "Amount of energy consumed per operation or second");
        }
    }
}

