/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.Args;
import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.units.UnitId;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ForgeKeys {
    protected static final String KEY = "key";
    protected static final String CATEGORIES = "categories";
    protected static final String DELIMITER = ".";

    public static boolean affectPlayer() {
        return Minecraft.func_71410_x().field_71415_G;
    }

    public static boolean affectMenus() {
        return !ForgeKeys.affectPlayer();
    }

    public static GameSettings getGameSettings() {
        return Minecraft.func_71410_x().field_71474_y;
    }

    public static boolean isDown(KeyBinding key) {
        return key != null ? GameSettings.func_100015_a((KeyBinding)key) : false;
    }

    public static boolean isPressed(KeyBinding key) {
        return key != null ? key.func_151468_f() : false;
    }

    public static String getName(KeyBinding key) {
        String name = key != null ? key.getDisplayName() : "";
        return name.replace("Button 1", "Left Button").replace("Button 2", "Right Button").replace("Button 3", "Middle Button");
    }

    @Deprecated
    public static KeyBinding createBindingFor(String actionName, ForgeConfig config, String configCategory, int keyCode, KeyCategories keyCategory) {
        keyCode = ForgeConfig.getInt(config, configCategory, KEY + CommonString.capitalizeFirstChar(actionName), keyCode, ForgeBounds.KEY_CODE.getIntBounds(), "Defines the key code for the " + actionName + " action.\nKey codes can be found at: http://minecraft.gamepedia.com/Key_codes");
        ForgeConfig.save(config);
        return ForgeKeys.createBindingFor(actionName, keyCode, keyCategory);
    }

    public static KeyBinding createBindingFor(String actionName, int keyCode, KeyCategories keyCategory) {
        KeyBinding keyBinding = new KeyBinding(Args.joinDelim(DELIMITER, KEY, UnitId.dictToRegName(actionName)), keyCode, keyCategory.func_176610_l());
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        return keyBinding;
    }

    public static enum KeyCategories implements IForgeEnum
    {
        NONE,
        MOVEMENT,
        GAMEPLAY,
        INVENTORY,
        CREATIVE,
        MULTIPLAYER,
        UI,
        MISC;


        public String func_176610_l() {
            return Args.joinDelim(ForgeKeys.DELIMITER, ForgeKeys.KEY, ForgeKeys.CATEGORIES, this.getLowerCase(this.name()));
        }
    }
}

