/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.combat;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.materials.ForgeMaterial;
import com.endertech.minecraft.forge.materials.IMaterialBased;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.ItemState;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeArmor
extends ItemArmor
implements IForgeUnit,
IMaterialBased {
    public static final FloatBounds DAMAGE_REDUCTION = FloatBounds.from(Float.valueOf(0.0f), Float.valueOf(50.0f));
    public static final IntBounds DURABILITY = IntBounds.from(0, 2000);
    protected final UnitId repair;
    private final ForgeConfig config;
    private final UnitId id;
    private final ForgeMod mod;
    private final UnitEnabled unitEnabled;
    private final UnitVariant defaultVariant;
    private Map<Object, UnitVariant> variants = new HashMap<Object, UnitVariant>();
    private final ForgeMaterial material;

    public ForgeArmor(ForgeMod mod, UnitConfig config, ForgeMaterial material, ItemArmor.ArmorMaterial armorMaterial, EntityEquipmentSlot equipmentSlot) {
        super(armorMaterial, ItemArmor.ArmorMaterial.IRON.ordinal(), equipmentSlot);
        this.repair = material.getRepairId();
        this.mod = mod;
        this.id = this.createId(mod.getId(), material.getName());
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getUnitCategory(), true);
        this.material = material;
        this.defaultVariant = UnitVariant.from(this.id, IForgeUnit.Variants.INVENTORY);
        this.setRegistryName(this.getId().toResLoc());
        this.func_77655_b(this.getId().getRegName());
        this.register();
    }

    public static float calculateDamageReduction(float materialStrength) {
        return DAMAGE_REDUCTION.approxUp(materialStrength).floatValue();
    }

    public static int calculateDurability(float materialStrength) {
        return DURABILITY.approxUp(materialStrength);
    }

    protected static int[] calculateReductionAmounts(ForgeMaterial material) {
        float reduction = ForgeArmor.calculateDamageReduction(material.getStrength());
        int[] amounts = new int[]{(int)(0.15f * reduction), (int)(0.3f * reduction), (int)(0.4f * reduction), (int)(0.15f * reduction)};
        return amounts;
    }

    public static float calculateToughness(ForgeMaterial material) {
        return ForgeBounds.TOUGHNESS.getFloatBounds().approxUp(material.getHeaviness()).floatValue();
    }

    public static ItemArmor.ArmorMaterial createArmorMaterial(ForgeMaterial material) {
        int durability = ForgeArmor.calculateDurability(material.getStrength());
        int[] reductionAmounts = ForgeArmor.calculateReductionAmounts(material);
        int enchantability = ForgeMaterial.calculateEnchantability(material);
        float toughness = ForgeArmor.calculateToughness(material);
        String textureName = material.getId().toResLoc().toString();
        ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)material.getName(), (String)textureName, (int)(durability / 10), (int[])reductionAmounts, (int)enchantability, (SoundEvent)SoundEvents.field_187725_r, (float)toughness);
        armorMaterial.setRepairItem(new ItemStack((Item)material));
        return armorMaterial;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemState state = ItemState.from(repair);
        for (ItemState repairState : this.repair.getAllItemStates()) {
            if (!repairState.matches(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReadyToRegister() {
        return true;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }

    @Override
    public UnitId getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    @Override
    public boolean isRegistered() {
        return ForgeItem.isRegistered((Item)this);
    }

    @Override
    public void onInit() {
    }

    @Override
    public ForgeMaterial getMaterial() {
        return this.material;
    }

    @Override
    public ForgeMod getMod() {
        return this.mod;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
    }

    @Override
    public Map<Object, UnitVariant> getUnitVariants() {
        return this.variants;
    }

    @Override
    public UnitVariant getDefaultVariant() {
        return this.defaultVariant;
    }

    @Override
    public <E extends Enum<E>> void setUnitVariants(Class<E> clazz) {
        this.variants = this.createUnitVariants(clazz);
    }
}

