/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;
import sonar.fluxnetworks.common.core.FluxUtils;

public class LineChart {
    public int x;
    public int y;
    public int height;
    public int linePoints;
    public String displayUnitX;
    public String displayUnitY;
    public long maxUnitY;
    public String suffixUnitY;
    public List<Long> data = new ArrayList<Long>();
    public List<Double> currentHeight;
    public List<Double> targetHeight;

    public LineChart(int x, int y, int height, int linePoints, String displayUnitX, String suffixUnitY) {
        int i;
        this.x = x;
        this.y = y;
        this.height = height;
        this.linePoints = linePoints;
        this.displayUnitX = displayUnitX;
        this.suffixUnitY = suffixUnitY;
        this.currentHeight = new ArrayList<Double>(linePoints);
        for (i = 0; i < linePoints; ++i) {
            this.currentHeight.add(Double.valueOf(y + height));
        }
        this.targetHeight = new ArrayList<Double>(linePoints);
        for (i = 0; i < linePoints; ++i) {
            this.targetHeight.add(Double.valueOf(y + height));
        }
    }

    public void drawChart(Minecraft mc) {
        int i;
        GlStateManager.func_179123_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)773);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glBegin((int)3);
        for (i = 0; i < this.currentHeight.size(); ++i) {
            GL11.glVertex3d((double)(this.x + 20 * i), (double)this.currentHeight.get(i), (double)1.0);
        }
        GL11.glEnd();
        GlStateManager.func_179120_a((int)770, (int)773, (int)1, (int)0);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4354);
        GL11.glPointSize((float)8.0f);
        GL11.glBegin((int)0);
        for (i = 0; i < this.currentHeight.size(); ++i) {
            GL11.glVertex3d((double)(this.x + 20 * i), (double)this.currentHeight.get(i), (double)1.0);
        }
        GL11.glEnd();
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
        Gui.func_73734_a((int)(this.x - 16), (int)(this.y + this.height), (int)(this.x + 116), (int)(this.y + this.height + 1), (int)-1);
        Gui.func_73734_a((int)(this.x - 14), (int)(this.y - 6), (int)(this.x - 13), (int)(this.y + this.height + 3), (int)-1);
        GlStateManager.func_179152_a((float)0.625f, (float)0.625f, (float)0.625f);
        mc.field_71466_p.func_175065_a(this.suffixUnitY, (float)((double)(this.x - 15) * 1.6) - (float)mc.field_71466_p.func_78256_a(this.suffixUnitY), (float)(((double)this.y - 7.5) * 1.6), 0xFFFFFF, false);
        mc.field_71466_p.func_175065_a(this.displayUnitY, (float)((double)(this.x - 15) * 1.6) - (float)mc.field_71466_p.func_78256_a(this.displayUnitY), (float)((double)(this.y - 2) * 1.6), 0xFFFFFF, false);
        mc.field_71466_p.func_175065_a(this.displayUnitX, (float)((double)(this.x + 118) * 1.6 - (double)mc.field_71466_p.func_78256_a(this.displayUnitX)), (float)(((double)(this.y + this.height) + 1.5) * 1.6), 0xFFFFFF, false);
        for (i = 0; i < this.data.size(); ++i) {
            String d = FluxUtils.format(this.data.get(i), FluxUtils.TypeNumberFormat.COMPACT, "");
            mc.field_71466_p.func_175065_a(d, (float)(this.x + 20 * i) * 1.6f - (float)mc.field_71466_p.func_78256_a(d) / 2.0f + 1.0f, (float)((this.currentHeight.get(i) - 7.0) * 1.6), 0xFFFFFF, false);
            String c = String.valueOf((5 - i) * 5);
            mc.field_71466_p.func_175065_a(c, (float)(this.x + 20 * i) * 1.6f - (float)mc.field_71466_p.func_78256_a(c) / 2.0f, (float)((double)(this.y + this.height + 2) * 1.6), 0xFFFFFF, false);
        }
        GlStateManager.func_179152_a((float)1.6f, (float)1.6f, (float)1.6f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179099_b();
    }

    public void updateData(List<Long> newData) {
        this.data = newData;
        this.calculateUnitY(newData);
        this.calculateTargetHeight(newData);
    }

    public void updateHeight(float partialTick) {
        if (this.currentHeight.size() == 0) {
            return;
        }
        for (int i = 0; i < this.currentHeight.size(); ++i) {
            double a = this.targetHeight.get(i) - this.currentHeight.get(i);
            if (a == 0.0) continue;
            double p = partialTick / 16.0f;
            double c = Math.abs(a) <= p ? this.targetHeight.get(i) : (a > 0.0 ? this.currentHeight.get(i) + Math.max(Math.min(a, a / 4.0 * (double)partialTick), p) : this.currentHeight.get(i) + Math.min(Math.max(a, a / 4.0 * (double)partialTick), -p));
            this.currentHeight.set(i, c);
        }
    }

    private void calculateUnitY(List<Long> data) {
        AtomicLong maxValue = new AtomicLong();
        data.forEach(v -> maxValue.set(Math.max(maxValue.get(), v)));
        if (maxValue.get() == 0L) {
            this.maxUnitY = 1L;
            this.displayUnitY = FluxUtils.format(this.maxUnitY, FluxUtils.TypeNumberFormat.COMPACT, "");
            return;
        }
        int measureLevel = (int)Math.log10(maxValue.get());
        switch (measureLevel) {
            case 0: {
                this.maxUnitY = maxValue.get() + 1L;
                break;
            }
            case 1: {
                this.maxUnitY = (maxValue.get() / 5L + 1L) * 5L;
                break;
            }
            case 2: {
                this.maxUnitY = (maxValue.get() / 50L + 1L) * 50L;
                break;
            }
            default: {
                int p = (int)Math.pow(10.0, measureLevel - 1);
                this.maxUnitY = (maxValue.get() / (long)p + 1L) * (long)p;
            }
        }
        this.displayUnitY = FluxUtils.format(this.maxUnitY, FluxUtils.TypeNumberFormat.COMPACT, "");
    }

    private void calculateTargetHeight(List<Long> data) {
        if (data.size() != this.linePoints) {
            return;
        }
        int i = 0;
        for (Long value : data) {
            this.targetHeight.set(i, (double)this.y + (double)this.height * (1.0 - (double)value.longValue() / (double)this.maxUnitY));
            ++i;
        }
    }
}

