/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.structure;

import com.Fishmod.mod_LavaCow.entities.EntityAvaton;
import com.Fishmod.mod_LavaCow.entities.EntityMummy;
import com.Fishmod.mod_LavaCow.entities.tameable.EntityMimic;
import com.Fishmod.mod_LavaCow.entities.tameable.EntityUnburied;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.structure.DesertTombBlockProcessor;
import java.util.Map;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureUtil {
    private static ResourceLocation[] Desert_Tomb_SpawnEntityID = new ResourceLocation[]{EntityList.func_191306_a(EntityUnburied.class), EntityList.func_191306_a(EntityAvaton.class), EntityList.func_191306_a(EntitySpider.class), EntityList.func_191306_a(EntityCaveSpider.class), EntityList.func_191306_a(EntityMummy.class)};

    public static boolean CanStructureGenonBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!state.func_185914_p() || !state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            return false;
        }
        return !world.func_180495_p(pos.func_177984_a()).func_185914_p() && !(world.func_180495_p(pos.func_177981_b(2)).func_177230_c() instanceof BlockLiquid);
    }

    public static void GenStructureWithLoot(ResourceLocation structure, ResourceLocation loot, World world, BlockPos pos) {
        EnumFacing facing = EnumFacing.func_176731_b((int)world.field_73012_v.nextInt(4));
        Rotation rotation = StructureUtil.getRotationFromFacing(facing);
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(Mirror.NONE);
        Template template = templateManager.func_186237_a(server, structure);
        template.func_189960_a(world, pos, (ITemplateProcessor)new DesertTombBlockProcessor(pos, settings, loot), settings, 2);
    }

    public static void GenDesertTomb(ResourceLocation structure, ResourceLocation loot, World world, BlockPos pos) {
        EnumFacing facing = EnumFacing.func_176731_b((int)world.field_73012_v.nextInt(4));
        Rotation rotation = StructureUtil.getRotationFromFacing(facing);
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(Mirror.NONE);
        Template template = templateManager.func_186237_a(server, structure);
        template.func_189960_a(world, pos, (ITemplateProcessor)new DesertTombBlockProcessor(pos, settings, loot), settings, 2);
        Map map = template.func_186258_a(pos, settings);
        int GenMimic = world.field_73012_v.nextInt(4);
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockpos;
            if (((String)entry.getValue()).contains("chest")) {
                blockpos = (BlockPos)entry.getKey();
                if ("chest0".equals(entry.getValue())) {
                    world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 3);
                }
                if ("chest1".equals(entry.getValue())) {
                    world.func_180501_a(blockpos, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), 3);
                }
                if ("chest2".equals(entry.getValue())) {
                    world.func_180501_a(blockpos, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), 3);
                }
                if ("chest3".equals(entry.getValue())) {
                    world.func_180501_a(blockpos, Blocks.field_150322_A.func_176223_P(), 3);
                }
                if (i == GenMimic) {
                    EnumFacing Chestfacing = (EnumFacing)world.func_180495_p(blockpos.func_177977_b()).func_177229_b((IProperty)BlockChest.field_176459_a);
                    world.func_180501_a(blockpos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 3);
                    EntityMimic Mimic = new EntityMimic(world);
                    Mimic.func_70107_b((double)blockpos.func_177977_b().func_177958_n() + 0.5, blockpos.func_177977_b().func_177956_o(), (double)blockpos.func_177977_b().func_177952_p() + 0.5);
                    world.func_72838_d((Entity)Mimic);
                    Mimic.func_180482_a(world.func_175649_E(blockpos.func_177977_b()), null);
                    Mimic.setSkin(7);
                    Mimic.inventory.set(0, (Object)new ItemStack(FishItems.KINGS_CROWN, 1, 0));
                    Mimic.doMimicChest(Chestfacing);
                }
                ++i;
            }
            if (!((String)entry.getValue()).contains("mobspawner")) continue;
            blockpos = (BlockPos)entry.getKey();
            world.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 3);
            TileEntity tileentity = world.func_175625_s(blockpos);
            if (!(tileentity instanceof TileEntityMobSpawner)) continue;
            ((TileEntityMobSpawner)tileentity).func_145881_a().func_190894_a(Desert_Tomb_SpawnEntityID[world.field_73012_v.nextInt(Desert_Tomb_SpawnEntityID.length)]);
        }
    }

    public static Rotation getRotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }
}

