/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities.tameable;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.core.SpawnUtil;
import com.Fishmod.mod_LavaCow.entities.tameable.EntityFishTameable;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.init.ModMobEffects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLilSludge
extends EntityFishTameable {
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(EntityLilSludge.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean isAggressive = false;
    private int limitedLifeTicks;
    private int fire_aspect;
    private int sharpness;
    private int knockback;
    private int bane_of_arthropods;
    private int smite;
    private int lifesteal;
    private int poisonous;
    private int corrosive;
    private int unbreaking;

    public EntityLilSludge(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 2.0f);
        this.limitedLifeTicks = -1;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SKIN_TYPE, (Object)this.field_70146_Z.nextInt(2));
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new AICopyOwnerTarget((EntityCreature)this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.LilSludge_Health);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.LilSludge_Attack);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
    }

    public void setLimitedLife(int limitedLifeTicksIn) {
        this.limitedLifeTicks = limitedLifeTicksIn;
    }

    public float getBonusDamage(EntityLivingBase entityLivingBaseIn) {
        return 0.5f * (float)this.sharpness + 0.5f + (entityLivingBaseIn.func_70668_bt().equals((Object)EnumCreatureAttribute.ARTHROPOD) ? (float)this.bane_of_arthropods * 2.5f : 0.0f) + (entityLivingBaseIn.func_70668_bt().equals((Object)EnumCreatureAttribute.UNDEAD) ? (float)this.smite * 2.5f : 0.0f);
    }

    public int getLifestealLevel() {
        return this.lifesteal;
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN_TYPE);
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)skinType);
    }

    @Override
    protected boolean isCommandItem(Item itemIn) {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public void func_70636_d() {
        float f;
        if (this.limitedLifeTicks >= 0 && this.field_70173_aa >= this.limitedLifeTicks) {
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && this.func_70902_q() instanceof EntityPlayerMP) {
                this.func_70902_q().func_145747_a((ITextComponent)SpawnUtil.TimeupDeathMessage((Entity)this));
            }
            this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
            this.func_70106_y();
        }
        if (!Modconfig.SunScreen_Mode && !(this.func_70902_q() instanceof EntityPlayer) && this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            this.func_70015_d(8);
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
            if (entityIn instanceof EntityLivingBase) {
                if (this.fire_aspect > 0) {
                    entityIn.func_70015_d(this.fire_aspect * 4 - 1);
                }
                if (this.knockback > 0) {
                    ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)this.knockback * 0.5f, (this.field_70165_t - entityIn.field_70165_t) / (double)this.func_70032_d(entityIn), (this.field_70161_v - entityIn.field_70161_v) / (double)this.func_70032_d(entityIn));
                }
                if (this.bane_of_arthropods > 0 && ((EntityLivingBase)entityIn).func_70668_bt().equals((Object)EnumCreatureAttribute.ARTHROPOD)) {
                    int i = 20 + this.field_70146_Z.nextInt(10 * this.bane_of_arthropods);
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, i, 3));
                }
                if (this.poisonous > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 160, this.poisonous - 1));
                }
                if (this.corrosive > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(ModMobEffects.CORRODED, 80, this.corrosive - 1));
                }
            }
        }
        return flag;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        return livingdata;
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            this.isAggressive = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
        } else {
            this.isAggressive = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)34);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAggressive() {
        return this.isAggressive;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 11) {
            this.isAggressive = true;
        } else if (id == 34) {
            this.isAggressive = false;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70631_g_() {
        return true;
    }

    public float func_70047_e() {
        return 0.6f;
    }

    protected SoundEvent func_184639_G() {
        return FishItems.ENTITY_LILSLUDGE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FishItems.ENTITY_SLUDGELORD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_LILSLUDGE_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187939_hm;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setLimitedLife(compound.func_74762_e("LifeTicks"));
        this.setSkin(compound.func_74762_e("Variant"));
        this.fire_aspect = compound.func_74762_e("fire_aspect");
        this.sharpness = compound.func_74762_e("sharpness");
        this.knockback = compound.func_74762_e("knockback");
        this.bane_of_arthropods = compound.func_74762_e("bane_of_arthropods");
        this.smite = compound.func_74762_e("fire_aspect");
        this.lifesteal = compound.func_74762_e("lifesteal");
        this.poisonous = compound.func_74762_e("poisonous");
        this.corrosive = compound.func_74762_e("corrosive");
        this.unbreaking = compound.func_74762_e("unbreaking");
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.LilSludge_Health + (double)((float)this.unbreaking * 2.0f));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("LifeTicks", this.limitedLifeTicks - this.field_70173_aa);
        compound.func_74768_a("Variant", this.getSkin());
        compound.func_74768_a("fire_aspect", this.fire_aspect);
        compound.func_74768_a("sharpness", this.sharpness);
        compound.func_74768_a("knockback", this.knockback);
        compound.func_74768_a("bane_of_arthropods", this.bane_of_arthropods);
        compound.func_74768_a("smite", this.smite);
        compound.func_74768_a("lifesteal", this.lifesteal);
        compound.func_74768_a("poisonous", this.poisonous);
        compound.func_74768_a("corrosive", this.corrosive);
        compound.func_74768_a("unbreaking", this.unbreaking);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (!(this.func_70902_q() instanceof EntityPlayer) && recentlyHit) {
            int chance = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(1 + looting);
            for (int amount = 0; amount < chance; ++amount) {
                this.func_70099_a(new ItemStack(FishItems.SILKY_SLUDGE), 0.0f);
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    class AICopyOwnerTarget
    extends EntityAITarget {
        public AICopyOwnerTarget(EntityCreature creature) {
            super(creature, false);
        }

        public boolean func_75250_a() {
            return EntityLilSludge.this.func_70902_q() != null && EntityLilSludge.this.func_70902_q() instanceof EntityLiving && ((EntityLiving)EntityLilSludge.this.func_70902_q()).func_70638_az() != null && this.func_75296_a(((EntityLiving)EntityLilSludge.this.func_70902_q()).func_70638_az(), false);
        }

        public void func_75249_e() {
            EntityLilSludge.this.func_70624_b(((EntityLiving)EntityLilSludge.this.func_70902_q()).func_70638_az());
            super.func_75249_e();
        }
    }
}

