/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.core.SpawnUtil;
import com.Fishmod.mod_LavaCow.entities.IAggressive;
import com.Fishmod.mod_LavaCow.entities.ai.EntityFishAIBreakDoor;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityZombieFrozen
extends EntityZombie
implements IAggressive {
    private boolean isAggressive = false;
    private int attackTimer;

    public EntityZombieFrozen(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.95f);
        this.func_146070_a(false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityFishAIBreakDoor((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.ZombieFrozen_Health);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.ZombieFrozen_Attack);
    }

    public boolean func_70601_bi() {
        return SpawnUtil.isAllowedDimension(this.field_71093_bK) && super.func_70601_bi();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    protected boolean func_190730_o() {
        return !Modconfig.SunScreen_Mode;
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (super.func_70652_k(par1Entity)) {
            this.attackTimer = 5;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            if (par1Entity instanceof EntityLivingBase) {
                float local_difficulty = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40 * (int)local_difficulty, 4));
            }
            return true;
        }
        return false;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(FishItems.FROZENTHIGH));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76347_k()) {
            return super.func_70097_a(source, 2.0f * amount);
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            this.isAggressive = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
        } else {
            this.isAggressive = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)34);
        }
    }

    @Override
    public boolean isAggressive() {
        return this.isAggressive;
    }

    @Override
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    public void setAttackTimer(int i) {
        this.attackTimer = i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 5;
        } else if (id == 11) {
            this.isAggressive = true;
        } else if (id == 34) {
            this.isAggressive = false;
        } else {
            super.func_70103_a(id);
        }
    }

    protected SoundEvent func_184639_G() {
        return FishItems.ENTITY_ZOMBIEFROZEN_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FishItems.ENTITY_ZOMBIEFROZEN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_ZOMBIEFROZEN_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.ZOMBIEFROZEN;
    }
}

