/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities;

import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesLoadedChunkManager;
import com.feed_the_beast.ftbutilities.data.Leaderboard;
import com.feed_the_beast.ftbutilities.data.NodeEntry;
import com.feed_the_beast.ftbutilities.events.CustomPermissionPrefixesRegistryEvent;
import com.feed_the_beast.ftbutilities.events.LeaderboardRegistryEvent;
import com.feed_the_beast.ftbutilities.integration.ChiselsAndBitsIntegration;
import com.feed_the_beast.ftbutilities.integration.IChunUtilIntegration;
import com.feed_the_beast.ftbutilities.integration.aurora.AuroraIntegration;
import com.feed_the_beast.ftbutilities.integration.kubejs.KubeJSIntegration;
import com.feed_the_beast.ftbutilities.net.FTBUtilitiesNetHandler;
import com.feed_the_beast.ftbutilities.ranks.FTBUtilitiesPermissionHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;

public class FTBUtilitiesCommon {
    public static final Collection<NodeEntry> CUSTOM_PERM_PREFIX_REGISTRY = new HashSet<NodeEntry>();
    public static final Map<ResourceLocation, Leaderboard> LEADERBOARDS = new HashMap<ResourceLocation, Leaderboard>();
    public static final Map<String, String> KAOMOJIS = new HashMap<String, String>();

    public void preInit() {
        FTBUtilitiesConfig.sync();
        if (FTBUtilitiesConfig.ranks.enabled) {
            PermissionAPI.setPermissionHandler((IPermissionHandler)FTBUtilitiesPermissionHandler.INSTANCE);
        }
        FTBUtilitiesNetHandler.init();
        if (!ForgeChunkManager.getConfig().hasCategory("ftbutilities")) {
            ForgeChunkManager.getConfig().get("ftbutilities", "maximumChunksPerTicket", 1000000).setMinValue(0);
            ForgeChunkManager.getConfig().get("ftbutilities", "maximumTicketCount", 1000000).setMinValue(0);
            ForgeChunkManager.getConfig().save();
        }
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)FTBUtilities.INST, (ForgeChunkManager.LoadingCallback)FTBUtilitiesLoadedChunkManager.INSTANCE);
        new CustomPermissionPrefixesRegistryEvent(CUSTOM_PERM_PREFIX_REGISTRY::add).post();
        if (Loader.isModLoaded((String)"chiselsandbits")) {
            ChiselsAndBitsIntegration.init();
        }
        if (Loader.isModLoaded((String)"ichunutil")) {
            IChunUtilIntegration.init();
        }
        if (Loader.isModLoaded((String)"kubejs")) {
            KubeJSIntegration.init();
        }
        KAOMOJIS.put("shrug", "\u00af\\_(\u30c4)_/\u00af");
        KAOMOJIS.put("tableflip", "(\u256f\u00b0\u25a1\u00b0)\u256f \ufe35 \u253b\u2501\u253b");
        KAOMOJIS.put("unflip", "\u252c\u2500\u252c\u30ce( \u309c-\u309c\u30ce)");
        if (Loader.isModLoaded((String)"aurora")) {
            AuroraIntegration.init();
        }
    }

    public void init() {
        new LeaderboardRegistryEvent(leaderboard -> LEADERBOARDS.put(leaderboard.id, (Leaderboard)leaderboard)).post();
        FTBUtilitiesPermissions.registerPermissions();
    }

    public void postInit() {
    }

    public void imc(FMLInterModComms.IMCMessage message) {
    }
}

