/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.util.SNBTTagCompound;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class SNBT {
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final Pattern BYTE_ARRAY_MATCHER = Pattern.compile("\\[B;([\\s\\d,b]*)\\]", 2);
    private static final Pattern LONG_ARRAY_MATCHER = Pattern.compile("\\[L;([\\s\\d,l]*)\\]", 2);

    public static String handleEscape(String string) {
        return SIMPLE_VALUE.matcher(string).matches() ? string : NBTTagString.func_193588_a((String)string);
    }

    @Nullable
    public static NBTTagCompound readOrTransform(File dir, String filename) {
        File snbtFile = new File(dir, filename + ".snbt");
        File nbtFile = new File(dir, filename + ".nbt");
        NBTTagCompound nbt = SNBT.read(snbtFile);
        if (nbt != null) {
            if (nbtFile.exists()) {
                nbtFile.delete();
            }
            return nbt;
        }
        nbt = NBTUtils.readNBT((File)nbtFile);
        if (nbt != null && nbtFile.delete()) {
            SNBT.write(snbtFile, nbt);
        }
        return nbt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static NBTTagCompound read(File file) {
        if (!file.exists()) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            int i;
            CharSequence[] s3;
            String s2;
            String line;
            while ((line = reader.readLine()) != null) {
                s.append(line.trim());
            }
            String s1 = s.toString();
            StringBuffer sb = new StringBuffer(s1.length());
            Matcher matcher = BYTE_ARRAY_MATCHER.matcher(s1);
            while (matcher.find()) {
                s2 = matcher.group(1);
                if (!s2.isEmpty()) {
                    s3 = s2.split(",");
                    for (i = 0; i < s3.length; ++i) {
                        if (s3[i].endsWith("b") || s3[i].endsWith("B")) continue;
                        int n = i;
                        s3[n] = (String)s3[n] + 'b';
                    }
                    matcher.appendReplacement(sb, "[B;" + String.join((CharSequence)",", s3) + "]");
                    continue;
                }
                matcher.appendReplacement(sb, "[B;]");
            }
            matcher.appendTail(sb);
            s1 = sb.toString();
            sb = new StringBuffer(s1.length());
            matcher = LONG_ARRAY_MATCHER.matcher(s1);
            while (matcher.find()) {
                s2 = matcher.group(1);
                if (!s2.isEmpty()) {
                    s3 = s2.split(",");
                    for (i = 0; i < s3.length; ++i) {
                        if (((String)s3[i]).endsWith("l") || ((String)s3[i]).endsWith("L")) continue;
                        int n = i;
                        s3[n] = (String)s3[n] + 'L';
                    }
                    matcher.appendReplacement(sb, "[L;" + String.join((CharSequence)",", s3) + "]");
                    continue;
                }
                matcher.appendReplacement(sb, "[L;]");
            }
            matcher.appendTail(sb);
            s1 = sb.toString();
            NBTTagCompound nBTTagCompound = JsonToNBT.func_180713_a((String)s1);
            return nBTTagCompound;
        }
        catch (NBTException ex) {
            FTBQuests.LOGGER.error("Failed to read " + file.getAbsolutePath() + ": " + (Object)((Object)ex));
            return null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void write(File file, NBTTagCompound out) {
        if (!file.exists()) {
            File p = file.getParentFile();
            if (!p.exists()) {
                p.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            SNBTBuilder builder = new SNBTBuilder();
            SNBT.append(builder, (NBTBase)out);
            builder.println();
            for (String s : builder.lines) {
                writer.println(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void append(SNBTBuilder builder, @Nullable NBTBase nbt) {
        if (nbt == null || nbt instanceof NBTTagEnd) {
            builder.print("null");
        } else if (nbt instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            if (compound.func_82582_d()) {
                builder.print("{}");
                return;
            }
            builder.print("{");
            builder.println();
            builder.push();
            int index = 0;
            for (String key : compound.func_150296_c()) {
                builder.print(SNBT.handleEscape(key));
                builder.print(": ");
                SNBT.append(builder, compound.func_74781_a(key));
                if (++index != compound.func_186856_d()) {
                    builder.print(",");
                }
                builder.println();
            }
            builder.pop();
            builder.print("}");
        } else if (nbt instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)nbt;
            SNBT.appendCollection(builder, list.func_150303_d(), list.func_74745_c(), arg_0 -> ((NBTTagList)list).func_179238_g(arg_0), "");
        } else if (nbt instanceof NBTTagByteArray) {
            byte[] array = ((NBTTagByteArray)nbt).func_150292_c();
            SNBT.appendCollection(builder, 1, array.length, i -> new NBTTagByte(array[i]), "B;");
        } else if (nbt instanceof NBTTagIntArray) {
            int[] array = ((NBTTagIntArray)nbt).func_150302_c();
            SNBT.appendCollection(builder, 3, array.length, i -> new NBTTagInt(array[i]), "I;");
        } else if (nbt instanceof NBTTagLongArray) {
            long[] array0 = new long[]{};
            try {
                array0 = (long[])ObfuscationReflectionHelper.getPrivateValue(NBTTagLongArray.class, (Object)((NBTTagLongArray)nbt), (String)"field_193587_b");
            }
            catch (Throwable index) {
                // empty catch block
            }
            long[] array = array0;
            SNBT.appendCollection(builder, 4, array.length, i -> new NBTTagLong(array[i]), "L;");
        } else if (nbt == SNBTTagCompound.TRUE) {
            builder.print("true");
        } else if (nbt == SNBTTagCompound.FALSE) {
            builder.print("false");
        } else {
            builder.print(nbt.toString());
        }
    }

    private static void appendCollection(SNBTBuilder builder, int type, int size, Function<Integer, NBTBase> function, String opening) {
        if (size <= 0) {
            builder.print("[");
            builder.print(opening);
            builder.print("]");
            return;
        }
        builder.print("[");
        builder.print(opening);
        if (type != 10 && type != 9) {
            builder.println();
            builder.push();
        }
        for (int index = 0; index < size; ++index) {
            SNBT.append(builder, function.apply(index));
            if (index != size - 1) {
                builder.print(",");
                builder.println();
                continue;
            }
            if (type == 10 || type == 9) continue;
            builder.println();
        }
        if (type != 10 && type != 9) {
            builder.pop();
        }
        builder.print("]");
    }

    private static class SNBTBuilder {
        private String indent = "";
        private final List<String> lines = new ArrayList<String>();
        private final StringBuilder line = new StringBuilder();

        private SNBTBuilder() {
        }

        private void print(Object string) {
            this.line.append(string);
        }

        private void println() {
            this.line.insert(0, this.indent);
            this.lines.add(this.line.toString());
            this.line.setLength(0);
        }

        private void push() {
            this.indent = this.indent + "\t";
        }

        private void pop() {
            this.indent = this.indent.substring(1);
        }
    }
}

