/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.events.TaskStartedEvent;
import com.feed_the_beast.ftbquests.net.MessageUpdateTaskProgress;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.util.FTBQuestsInventoryListener;
import com.feed_the_beast.ftbquests.util.ServerQuestData;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;

public class TaskData<T extends Task>
implements ICapabilityProvider,
IItemHandler {
    public final T task;
    public final QuestData data;
    public long progress = 0L;
    private boolean taskCompleted = false;

    public TaskData(T q, QuestData d) {
        this.task = q;
        this.data = d;
    }

    public final void readProgress(long p) {
        this.progress = Math.max(0L, Math.min(p, ((Task)this.task).getMaxProgress()));
        this.taskCompleted = this.isComplete();
    }

    public final void setProgress(long p) {
        if (this.progress != (p = Math.max(0L, Math.min(p, ((Task)this.task).getMaxProgress())))) {
            long prevProgress = this.progress;
            this.progress = p;
            this.taskCompleted = false;
            ((Task)this.task).quest.chapter.file.clearCachedProgress();
            if (this.data instanceof ServerQuestData) {
                if (ChangeProgress.sendUpdates) {
                    new MessageUpdateTaskProgress(this.data.getTeamUID(), ((Task)this.task).id, this.progress).sendToAll();
                }
                if (p == 0L) {
                    MinecraftForge.EVENT_BUS.post((Event)new TaskStartedEvent(this));
                }
                if (FTBLibConfig.debugging.print_more_info) {
                    FTBQuests.LOGGER.info("Changed progress for " + this.data.getTeamID() + ":" + this.task + " (" + ((Task)this.task).getType().getRegistryName() + ") from " + prevProgress + " to " + this.progress + "/" + ((Task)this.task).getMaxProgress());
                }
                if (!this.taskCompleted && this.isComplete()) {
                    this.taskCompleted = true;
                    List onlineMembers = ((ServerQuestData)this.data).team.getOnlineMembers();
                    List notifiedPlayers = !((Task)this.task).quest.chapter.alwaysInvisible && !((Task)this.task).quest.canRepeat && ChangeProgress.sendNotifications.get(ChangeProgress.sendUpdates) ? onlineMembers : Collections.emptyList();
                    ((Task)this.task).onCompleted(this.data, onlineMembers, notifiedPlayers);
                    if (this.progress > prevProgress) {
                        for (EntityPlayerMP player : onlineMembers) {
                            FTBQuestsInventoryListener.detect(player, ItemStack.field_190927_a, ((Task)this.task).id);
                        }
                    }
                }
            }
            this.data.markDirty();
        }
    }

    public final void addProgress(long p) {
        this.setProgress(this.progress + p);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return false;
    }

    @Nullable
    public <C> C getCapability(Capability<C> capability, @Nullable EnumFacing facing) {
        return null;
    }

    public final int getRelativeProgress() {
        long max = ((Task)this.task).getMaxProgress();
        if (max <= 0L) {
            return 0;
        }
        if (this.progress <= 0L) {
            return 0;
        }
        if (this.progress >= max) {
            return 100;
        }
        return (int)Math.max(1.0, (double)this.progress * 100.0 / (double)max);
    }

    public final boolean isComplete() {
        long max = ((Task)this.task).getMaxProgress();
        return max > 0L && this.progress >= max;
    }

    public final boolean isStarted() {
        return this.progress > 0L && ((Task)this.task).getMaxProgress() > 0L;
    }

    public String getProgressString() {
        return StringUtils.formatDouble((double)this.progress, (boolean)true);
    }

    public String toString() {
        return this.data.toString() + "#" + this.task;
    }

    public ItemStack insertItem(ItemStack stack, boolean singleItem, boolean simulate, @Nullable EntityPlayer player) {
        return stack;
    }

    public final int getSlots() {
        return 1;
    }

    public final ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public final ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (((Task)this.task).canInsertItem() && ((Task)this.task).getMaxProgress() > 0L && this.progress < ((Task)this.task).getMaxProgress() && !stack.func_190926_b()) {
            return this.insertItem(stack, false, simulate, null);
        }
        return stack;
    }

    public final ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void submitTask(EntityPlayerMP player, ItemStack item) {
        if (!((Task)this.task).canInsertItem() || !item.func_190926_b()) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack1;
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(stack1 = this.insertItem(stack, false, false, (EntityPlayer)player)))) continue;
            changed = true;
            player.field_71071_by.field_70462_a.set(i, (Object)stack1);
        }
        if (changed) {
            player.field_71071_by.func_70296_d();
            player.field_71070_bA.func_75142_b();
        }
    }

    public final void submitTask(EntityPlayerMP player) {
        this.submitTask(player, ItemStack.field_190927_a);
    }
}

