/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.shop;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.mods.money.shop.Shop;
import com.feed_the_beast.mods.money.shop.ShopEntry;
import com.latmod.mods.itemfilters.item.ItemStackSerializer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class ShopTab
implements INBTSerializable<NBTTagCompound> {
    public final Shop shop;
    public String title = "";
    public ItemStack icon = ItemStack.field_190927_a;
    public int lock = 0;
    public final List<ShopEntry> entries = new ArrayList<ShopEntry>();

    public ShopTab(Shop s) {
        this.shop = s;
    }

    public NBTTagCompound serializeSettings() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("title", this.title);
        nbt.func_74782_a("icon", ItemStackSerializer.write((ItemStack)this.icon, (boolean)false));
        if (this.lock != 0) {
            nbt.func_74768_a("lock", this.lock);
        }
        return nbt;
    }

    public void deserializeSettings(NBTTagCompound nbt) {
        this.title = nbt.func_74779_i("title");
        this.icon = ItemStackSerializer.read((NBTBase)nbt.func_74781_a("icon"));
        this.lock = nbt.func_74762_e("lock");
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = this.serializeSettings();
        NBTTagList e = new NBTTagList();
        for (ShopEntry entry : this.entries) {
            e.func_74742_a((NBTBase)entry.serializeNBT());
        }
        nbt.func_74782_a("entries", (NBTBase)e);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.deserializeSettings(nbt);
        this.entries.clear();
        NBTTagList e = nbt.func_150295_c("entries", 10);
        for (int i = 0; i < e.func_74745_c(); ++i) {
            ShopEntry entry = new ShopEntry(this);
            entry.deserializeNBT(e.func_150305_b(i));
            if (entry.stack.func_190926_b()) continue;
            this.entries.add(entry);
        }
    }

    public int getIndex() {
        return this.shop.tabs.indexOf(this);
    }

    public void getConfig(ConfigGroup config) {
        config.addString("title", () -> this.title, v -> {
            this.title = v;
        }, "");
        config.add("icon", (ConfigValue)new ConfigItemStack.SimpleStack(() -> this.icon, v -> {
            this.icon = v;
        }), (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a));
    }
}

