/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.gui;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.mods.money.gui.ButtonAddEntry;
import com.feed_the_beast.mods.money.gui.ButtonShopEntry;
import com.feed_the_beast.mods.money.gui.GuiShop;
import com.feed_the_beast.mods.money.shop.Shop;
import com.feed_the_beast.mods.money.shop.ShopEntry;
import com.feed_the_beast.mods.money.shop.ShopTab;
import java.util.ArrayList;

public class PanelShopEntryButtons
extends Panel {
    public final GuiShop guiShop;

    public PanelShopEntryButtons(GuiShop g) {
        super((Panel)g);
        this.guiShop = g;
    }

    public void add(Widget widget) {
        if (this.guiShop.searchBox.getText().isEmpty() || widget.getTitle().toLowerCase().contains(this.guiShop.searchBox.getText().toLowerCase())) {
            super.add(widget);
        }
    }

    public void addWidgets() {
        ArrayList<ButtonShopEntry> buttons = new ArrayList<ButtonShopEntry>();
        ArrayList locked = new ArrayList();
        if (!this.guiShop.searchBox.getText().isEmpty()) {
            for (ShopTab tab : Shop.CLIENT.tabs) {
                for (ShopEntry entry : tab.entries) {
                    ButtonShopEntry b = new ButtonShopEntry(this, entry);
                    (b.locked == 0 ? buttons : locked).add(b);
                }
            }
        } else if (this.guiShop.selectedTab != null) {
            for (ShopEntry entry : this.guiShop.selectedTab.entries) {
                ButtonShopEntry b = new ButtonShopEntry(this, entry);
                (b.locked == 0 ? buttons : locked).add(b);
            }
        }
        buttons.sort(ButtonShopEntry.COMPARATOR);
        this.addAll(buttons);
        this.addAll(locked);
        if (this.guiShop.selectedTab != null && Shop.CLIENT.file.get().canEdit()) {
            this.add((Widget)new ButtonAddEntry(this));
        }
    }

    public void alignWidgets() {
        this.setY(23);
        int prevWidth = this.width;
        if (this.widgets.isEmpty()) {
            this.setWidth(100);
        } else {
            this.setWidth(0);
            for (Widget w : this.widgets) {
                this.setWidth(Math.max(this.width, w.width));
            }
        }
        this.setWidth(Math.max(this.width, prevWidth));
        for (Widget w : this.widgets) {
            w.setX(1);
            w.setWidth(this.width - 2);
        }
        this.setHeight(140);
        this.guiShop.scrollBar.setPosAndSize(this.posX + this.width + 6, this.posY - 1, 16, this.height + 2);
        this.guiShop.scrollBar.setMaxValue(this.align((WidgetLayout)new WidgetLayout.Vertical(1, 1, 1)));
        this.guiShop.setWidth(this.guiShop.scrollBar.posX + this.guiShop.scrollBar.width + 8);
        this.guiShop.setHeight(this.height + 32);
        this.guiShop.searchBox.setPosAndSize(8, 6, this.guiShop.width - 16, 12);
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawPanelBackground(x, y, w, h);
    }
}

