/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.command;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.mods.money.shop.Shop;
import com.feed_the_beast.mods.money.shop.ShopEntry;
import com.feed_the_beast.mods.money.shop.ShopTab;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CommandImportItemsFromChest
extends CommandBase {
    public String func_71517_b() {
        return "import_shop_items_from_chest";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ftbmoney.import_shop_items_from_chest.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 3) {
            return CommandImportItemsFromChest.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>(Shop.SERVER.tabs.size());
            for (ShopTab tab : Shop.SERVER.tabs) {
                list.add(tab.title.replace(" ", "").toLowerCase());
            }
            return CommandImportItemsFromChest.func_175762_a((String[])args, list);
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        IItemHandler handler;
        TileEntity tileEntity;
        EntityPlayerMP player = CommandImportItemsFromChest.func_71521_c((ICommandSender)sender);
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        ShopTab tab = Shop.SERVER.getTab(args[0]);
        if (tab == null) {
            throw FTBLib.error((ICommandSender)sender, (String)"commands.ftbmoney.import_shop_items_from_chest.invalid_id", (Object[])new Object[]{args[0]});
        }
        long price = args.length >= 2 ? CommandImportItemsFromChest.func_175760_a((String)args[1], (long)0L, (long)Long.MAX_VALUE) : 1L;
        boolean replace = args.length >= 3 && CommandImportItemsFromChest.func_180527_d((String)args[2]);
        RayTraceResult ray = MathUtils.rayTrace((EntityPlayer)player, (boolean)false);
        if (ray.field_72313_a == RayTraceResult.Type.BLOCK && (tileEntity = player.field_70170_p.func_175625_s(ray.func_178782_a())) != null && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, ray.field_178784_b)) != null) {
            if (replace) {
                tab.entries.clear();
            }
            int r = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ShopEntry entry = new ShopEntry(tab);
                entry.stack = stack.func_77946_l();
                entry.buy = price;
                tab.entries.add(entry);
                ++r;
            }
            Shop.SERVER.markDirty();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ftbmoney.import_shop_items_from_chest.text", new Object[]{r, tab.title}));
        }
    }
}

