/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.armor.ModelPartConcealer;
import com.phylogeny.extrabitmanipulation.armor.capability.ChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.packet.PacketArmorSlotInt;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetModelPartConcealed
extends PacketArmorSlotInt {
    private boolean isOverlay;
    private boolean remove;

    public PacketSetModelPartConcealed() {
    }

    public PacketSetModelPartConcealed(@Nullable ItemChiseledArmor.ArmorType armorType, int indexArmorSet, ItemChiseledArmor.ModelMovingPart part, boolean isOverlay, boolean remove) {
        super(armorType, indexArmorSet, part.ordinal());
        this.isOverlay = isOverlay;
        this.remove = remove;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeBoolean(this.isOverlay);
        buffer.writeBoolean(this.remove);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.isOverlay = buffer.readBoolean();
        this.remove = buffer.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketSetModelPartConcealed, IMessage> {
        public IMessage onMessage(final PacketSetModelPartConcealed message, final MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    ItemStack stack = PacketArmorSlotInt.getArmorStack((EntityPlayer)player, message);
                    if (stack.func_190926_b()) {
                        return;
                    }
                    NBTTagCompound nbt = stack.func_77978_p();
                    if (nbt == null) {
                        return;
                    }
                    ModelPartConcealer modelPartConcealer = ModelPartConcealer.loadFromNBT(nbt);
                    if (modelPartConcealer == null) {
                        modelPartConcealer = new ModelPartConcealer();
                    }
                    modelPartConcealer.addOrRemove(message.value, message.isOverlay, message.remove);
                    modelPartConcealer.saveToNBT(nbt);
                    player.field_71069_bz.func_75142_b();
                    IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability((EntityPlayer)player);
                    if (cap != null) {
                        cap.onContentsChanged(message.armorType.getSlotIndex(message.indexArmorSet));
                    }
                }
            });
            return null;
        }
    }
}

