/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.api.jei.shape;

import com.phylogeny.extrabitmanipulation.api.jei.InfoRecipeBase;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ShapeInfoRecipe
extends InfoRecipeBase {
    public static final String[] GRAPHIC_NAMES = new String[]{"sphere", "ellipsoid", "circular_cylinder", "elliptic_cylinder", "circular_cone", "elliptic_cone", "cube", "cuboid", "square_pyramid", "rectangular_pyramid"};
    private ResourceLocation graphicImageSymetrical;
    private ResourceLocation graphicImageAsymetrical;
    private int imageIndex;
    public static String textSolid;
    public static String textHollow;
    public static String textClosed;
    public static String textOpen;

    public static List<ShapeInfoRecipe> create(IGuiHelper guiHelper, List<ItemStack> sculptingStacks) {
        ArrayList<ShapeInfoRecipe> recipes = new ArrayList<ShapeInfoRecipe>();
        for (int i = 0; i < GRAPHIC_NAMES.length / 2; ++i) {
            boolean isNarrow = i % 3 == 0;
            recipes.add(new ShapeInfoRecipe(guiHelper, sculptingStacks, isNarrow ? 746 : 1070, isNarrow ? 615 : 690, "shape", i, isNarrow));
        }
        return recipes;
    }

    public ShapeInfoRecipe(IGuiHelper guiHelper, List<ItemStack> sculptingStacks, int imageWidth, int imageHeight, String catagoryName, int imageIndex, boolean isNarrow) {
        super(guiHelper, sculptingStacks, imageWidth, imageHeight, GRAPHIC_NAMES[imageIndex * 2 + 1], GRAPHIC_NAMES[imageIndex * 2 + 1].toLowerCase().replace(" ", "_"), catagoryName, isNarrow ? 19 : 2, 22, isNarrow ? 142 : 158, 123, catagoryName);
        this.imageIndex = imageIndex;
        this.graphicImageSymetrical = new ResourceLocation("extrabitmanipulation", "textures/jei/graphics/" + GRAPHIC_NAMES[imageIndex * 2] + ".png");
        this.graphicImageAsymetrical = new ResourceLocation("extrabitmanipulation", "textures/jei/graphics/" + GRAPHIC_NAMES[imageIndex * 2 + 1] + ".png");
        textSolid = this.translateName("solid");
        textHollow = this.translateName("hollow");
        textClosed = this.translateName("closed");
        textOpen = this.translateName("open");
    }

    protected String translateName(String name) {
        return this.translateName("shape", name);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int xPos = -5;
        int yPos = -3;
        ClientHelper.bindTexture(this.graphicImageSymetrical);
        Gui.func_152125_a((int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)870, (int)870, (int)24, (int)24, (float)870.0f, (float)870.0f);
        xPos = 20;
        ClientHelper.bindTexture(this.graphicImageAsymetrical);
        Gui.func_152125_a((int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)870, (int)870, (int)24, (int)24, (float)870.0f, (float)870.0f);
        xPos = 47;
        yPos = 0;
        this.slotDrawable.draw(minecraft, xPos, yPos);
        ClientHelper.bindTexture(this.image);
        GuiHelper.drawTexturedRect(this.imageBox.getMinX(), this.imageBox.getMinY(), this.imageBox.getMaxX(), this.imageBox.getMaxY());
        yPos += this.slotDrawable.getHeight() + 4;
        xPos = 69;
        int nameWidth = minecraft.field_71466_p.func_78256_a(this.name);
        if (nameWidth < 103) {
            xPos = (int)((double)xPos + (52.0 - (double)nameWidth * 0.5));
        }
        yPos = this.slotDrawable.getHeight() / 2 - minecraft.field_71466_p.field_78288_b / 2;
        minecraft.field_71466_p.func_78276_b(this.name, xPos, yPos, Color.black.getRGB());
        boolean isSloped = this.imageIndex == 2 || this.imageIndex == 4;
        int n = xPos = this.imageIndex % 3 == 0 ? 51 : 33;
        yPos = this.imageIndex == 3 ? 25 : (isSloped ? 30 : 28);
        minecraft.field_71466_p.func_78276_b(textSolid, xPos - minecraft.field_71466_p.func_78256_a(textSolid) / 2, yPos, Color.black.getRGB());
        xPos = 109;
        minecraft.field_71466_p.func_78276_b(textHollow, xPos - minecraft.field_71466_p.func_78256_a(textHollow) / 2, yPos, Color.black.getRGB());
        if (this.imageIndex % 3 != 0) {
            xPos = 79;
            yPos = isSloped ? 42 : 36;
            minecraft.field_71466_p.func_78276_b(textClosed, xPos - minecraft.field_71466_p.func_78256_a(textClosed) / 2, yPos, Color.black.getRGB());
            minecraft.field_71466_p.func_78276_b(textOpen, xPos + 55 - minecraft.field_71466_p.func_78256_a(textOpen) / 2, yPos, Color.black.getRGB());
        }
    }
}

